/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.util;

import com.biz.crm.mdm.tableconfig.MdmColumnConfigPersonalFeign;
import com.biz.crm.nebular.mdm.tableconfig.MdmColumnConfigPersonalRedisVo;
import com.biz.crm.nebular.mdm.tableconfig.MdmColumnConfigPersonalRespVo;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.Result;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class ColumnConfigPersonalUtil {
    private static final Logger log = LoggerFactory.getLogger(ColumnConfigPersonalUtil.class);
    private static RedisService redisService;
    private static MdmColumnConfigPersonalFeign mdmColumnConfigPersonalFeign;

    public static void setRedisService(RedisService redis) {
        redisService = redis;
    }

    public static void setMdmColumnConfigPersonalFeign(MdmColumnConfigPersonalFeign columnConfigPersonalFeign) {
        mdmColumnConfigPersonalFeign = columnConfigPersonalFeign;
    }

    public static List<MdmColumnConfigPersonalRespVo> getColumnConfigPersonal(String parentCode, String functionCode, String positionCode) {
        Assert.hasText((String)parentCode, (String)"\u7f3a\u5931\u83dc\u5355\u7f16\u7801");
        Assert.hasText((String)functionCode, (String)"\u7f3a\u5931\u529f\u80fd\u7f16\u7801");
        Assert.hasText((String)positionCode, (String)"\u7f3a\u5931\u804c\u4f4d\u7f16\u7801");
        List<MdmColumnConfigPersonalRedisVo> redisList = ColumnConfigPersonalUtil.get(parentCode, functionCode, positionCode);
        if (redisList != null && redisList.size() > 0) {
            return CrmBeanUtil.copyList(redisList, MdmColumnConfigPersonalRespVo.class);
        }
        return Collections.emptyList();
    }

    public static void deleteColumnConfig(String parentCode, String functionCode) {
        Assert.hasText((String)parentCode, (String)"\u7f3a\u5931\u83dc\u5355\u7f16\u7801");
        Assert.hasText((String)functionCode, (String)"\u7f3a\u5931\u529f\u80fd\u7f16\u7801");
        HashSet keys = new HashSet(16);
        keys.addAll(redisService.keys(ColumnConfigPersonalUtil.connectKeyParam("MDM_COLUMN_CONFIG_PERSONAL_0222:", parentCode, functionCode) + "*"));
        keys.addAll(redisService.keys(ColumnConfigPersonalUtil.connectKeyParam("MDM_COLUMN_CONFIG_PERSONAL_LOCK_0222:", parentCode, functionCode) + "*"));
        if (!keys.isEmpty()) {
            String[] strings = keys.toArray(new String[keys.size()]);
            redisService.del(strings);
        }
    }

    public static void deleteColumnConfigPersonal(String parentCode, String functionCode, String positionCode) {
        Assert.hasText((String)parentCode, (String)"\u7f3a\u5931\u83dc\u5355\u7f16\u7801");
        Assert.hasText((String)functionCode, (String)"\u7f3a\u5931\u529f\u80fd\u7f16\u7801");
        Assert.hasText((String)positionCode, (String)"\u7f3a\u5931\u804c\u4f4d\u7f16\u7801");
        HashSet keys = new HashSet(16);
        keys.addAll(redisService.keys(ColumnConfigPersonalUtil.connectKeyParam("MDM_COLUMN_CONFIG_PERSONAL_0222:", parentCode, functionCode, positionCode)));
        keys.addAll(redisService.keys(ColumnConfigPersonalUtil.connectKeyParam("MDM_COLUMN_CONFIG_PERSONAL_LOCK_0222:", parentCode, functionCode, positionCode)));
        if (!keys.isEmpty()) {
            String[] strings = keys.toArray(new String[keys.size()]);
            redisService.del(strings);
        }
    }

    public static void deletePersonal(String positionCode) {
        Assert.hasText((String)positionCode, (String)"\u7f3a\u5931\u804c\u4f4d\u7f16\u7801");
        HashSet keys = new HashSet(16);
        keys.addAll(redisService.keys("MDM_COLUMN_CONFIG_PERSONAL_0222:*" + positionCode));
        keys.addAll(redisService.keys("MDM_COLUMN_CONFIG_PERSONAL_LOCK_0222:*" + positionCode));
        if (!keys.isEmpty()) {
            String[] strings = keys.toArray(new String[keys.size()]);
            redisService.del(strings);
        }
    }

    private static List<MdmColumnConfigPersonalRedisVo> get(String parentCode, String functionCode, String positionCode) {
        ArrayList<MdmColumnConfigPersonalRedisVo> list = new ArrayList<MdmColumnConfigPersonalRedisVo>();
        String lockKey = ColumnConfigPersonalUtil.connectKeyParam("MDM_COLUMN_CONFIG_PERSONAL_LOCK_0222:", parentCode, functionCode, positionCode);
        String key = ColumnConfigPersonalUtil.connectKeyParam("MDM_COLUMN_CONFIG_PERSONAL_0222:", parentCode, functionCode, positionCode);
        Object o = redisService.get(lockKey);
        if (o == null) {
            Object obj = redisService.get(key);
            if (obj == null) {
                Result result = mdmColumnConfigPersonalFeign.findColumnConfigPersonalRedisList(parentCode, functionCode, positionCode);
                Assert.isTrue((boolean)result.isSuccess(), (String)("\u67e5\u8be2\u4e2a\u6027\u8bbe\u7f6e\u5931\u8d25\uff1a" + result.getMessage()));
                List redisList = (List)result.getResult();
                if (redisList == null || redisList.size() == 0) {
                    redisService.setDays(lockKey, (Object)lockKey, 30L);
                } else {
                    redisService.setDays(key, (Object)redisList, 30L);
                    list.addAll(redisList);
                }
            } else {
                list.addAll((List)obj);
            }
        }
        return list;
    }

    private static String connectKeyParam(String key, String parentCode, String functionCode) {
        return key + "/" + parentCode + ":/" + functionCode + ":/";
    }

    private static String connectKeyParam(String key, String parentCode, String functionCode, String positionCode) {
        return key + "/" + parentCode + ":/" + functionCode + ":/" + positionCode;
    }
}

