/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.util;

import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.mdm.feign.MdmDictFeign;
import com.biz.crm.nebular.mdm.dict.resp.DictAttrConfRedisVo;
import com.biz.crm.nebular.mdm.dict.resp.DictDataRedisVo;
import com.biz.crm.nebular.mdm.dict.resp.DictDataVo;
import com.biz.crm.nebular.mdm.dict.resp.DictGroupRedisVo;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.ReflectUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DictUtil {
    private static final Logger log = LoggerFactory.getLogger(DictUtil.class);
    public static final String PATH_SPLIT = "/";
    private static RedisService redisService;
    private static MdmDictFeign mdmDictFeign;

    public static void setRedisService(RedisService redis) {
        redisService = redis;
    }

    public static void setMdmDictFeign(MdmDictFeign feign) {
        mdmDictFeign = feign;
    }

    public static Map<String, String> dictMap(String dictTypeCode) {
        if (dictTypeCode != null && !"".equals(dictTypeCode)) {
            return DictUtil.fullMapByPath(dictTypeCode);
        }
        return new HashMap<String, String>(16);
    }

    public static Map<String, String> dictRevertMap(String dictTypeCode) {
        Map<String, String> map = DictUtil.dictMap(dictTypeCode);
        if (!map.isEmpty()) {
            return map.keySet().stream().collect(Collectors.toMap(map::get, x -> x, (x1, x2) -> x1));
        }
        return new HashMap<String, String>(16);
    }

    public static Map<String, String> dictSingleMap(String dictTypeCode) {
        Map<String, String> map = new LinkedHashMap<String, String>(16);
        if (dictTypeCode != null && !"".equals(dictTypeCode)) {
            map = DictUtil.singleMapByPath(dictTypeCode);
        }
        return map;
    }

    public static Map<String, Map<String, String>> getDictValueMapsByCodes(List<String> dictTypeCodes) {
        HashMap<String, Map<String, String>> maps = new HashMap<String, Map<String, String>>(16);
        try {
            if (dictTypeCodes != null && dictTypeCodes.size() > 0) {
                for (String dictTypeCode : dictTypeCodes) {
                    maps.put(dictTypeCode, DictUtil.dictMap(dictTypeCode));
                }
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5b57\u5178\u6570\u636e\u5f02\u5e38!!!!!!!!");
            e.printStackTrace();
        }
        return maps;
    }

    public static Map<String, String> getDictValueMapsByCodes(String dictTypeCode) {
        return DictUtil.dictMap(dictTypeCode);
    }

    public static Map<String, String> getChildrenMap(String dictTypeCode, String dictCode) {
        Map<String, String> map = new LinkedHashMap<String, String>(16);
        if (dictTypeCode != null && !"".equals(dictTypeCode) && dictCode != null && !"".equals(dictCode)) {
            map = DictUtil.singleMapByPath(dictTypeCode + PATH_SPLIT + dictCode);
        }
        return map;
    }

    public static Map<String, String> getExtendMap(String dictTypeCode, String dictCode) {
        List confList;
        String realDictTypeCode;
        DictGroupRedisVo group;
        if (dictTypeCode != null && !"".equals(dictTypeCode) && dictCode != null && !"".equals(dictCode) && (group = DictUtil.getDictGroup(realDictTypeCode = DictUtil.getRealDictTypeCode(dictTypeCode))) != null && (confList = group.getConfList()) != null && confList.size() > 0) {
            for (DictDataRedisVo data : group.getDataList()) {
                if (!dictCode.equals(data.getDictCode())) continue;
                return DictUtil.generateExtendMap(data, group.getConfList());
            }
        }
        return new LinkedHashMap<String, String>();
    }

    public static List<DictDataVo> tree(String dictTypeCode) {
        if (dictTypeCode != null && !"".equals(dictTypeCode)) {
            return DictUtil.treeByPath(dictTypeCode, true);
        }
        return new ArrayList<DictDataVo>();
    }

    public static List<DictDataVo> list(String dictTypeCode) {
        if (dictTypeCode != null && !"".equals(dictTypeCode)) {
            return DictUtil.listByPath(dictTypeCode, true);
        }
        return new ArrayList<DictDataVo>();
    }

    public static List<DictDataVo> getChildrenList(String dictTypeCode, String dictCode) {
        List<DictDataVo> list;
        if (dictTypeCode != null && !"".equals(dictTypeCode) && dictCode != null && !"".equals(dictCode) && (list = DictUtil.treeByPath(dictTypeCode + PATH_SPLIT + dictCode, true)) != null && list.size() > 0) {
            return list.stream().peek(item -> item.setChildren(null)).collect(Collectors.toList());
        }
        return new ArrayList<DictDataVo>();
    }

    public static String dictValue(String dictTypeCode, String dictCode) {
        Map<String, String> map;
        if (dictTypeCode != null && !"".equals(dictTypeCode) && dictCode != null && !"".equals(dictCode) && (map = DictUtil.fullMapByPath(dictTypeCode)).containsKey(dictCode)) {
            return map.get(dictCode);
        }
        return null;
    }

    public static List<String> getCodeListByValue(String dictTypeCode, String dictValue) {
        List<DictDataVo> listByPath;
        ArrayList<String> list = new ArrayList<String>();
        if (dictTypeCode != null && !"".equals(dictTypeCode) && dictValue != null && !"".equals(dictValue) && (listByPath = DictUtil.listByPath(dictTypeCode, false)) != null && listByPath.size() > 0) {
            list.addAll(listByPath.stream().filter(item -> dictValue.equals(item.getDictValue())).map(DictDataVo::getDictCode).collect(Collectors.toList()));
        }
        return list;
    }

    public static String getFirstCodeByValue(String dictTypeCode, String dictValue) {
        if (dictTypeCode != null && !"".equals(dictTypeCode) && dictValue != null && !"".equals(dictValue)) {
            List<DictDataVo> listByPath = DictUtil.listByPath(dictTypeCode, false);
            for (DictDataVo item : listByPath) {
                if (!item.getDictValue().equals(dictValue)) continue;
                return item.getDictCode();
            }
        }
        return null;
    }

    public static void deleteRedisCache(String dictTypeCode) {
        if (StringUtils.isNotEmpty((String)dictTypeCode)) {
            String realDictTypeCode = DictUtil.getRealDictTypeCode(dictTypeCode);
            redisService.del(new String[]{"DICT_TYPE_GROUP_1231:" + realDictTypeCode});
            redisService.del(new String[]{"DICT_TYPE_LOCK_1231:" + realDictTypeCode});
        }
    }

    private static DictGroupRedisVo getDictGroup(String dictTypeCode) {
        if (dictTypeCode != null && !"".equals(dictTypeCode)) {
            if (ThreadLocalUtil.dictGroupContains((String)dictTypeCode)) {
                return ThreadLocalUtil.getFromDictGroup((String)dictTypeCode);
            }
            Map<String, DictGroupRedisVo> dictGroupMap = DictUtil.getDictGroupMap(Collections.singletonList(dictTypeCode));
            DictGroupRedisVo group = dictGroupMap.get(dictTypeCode);
            ThreadLocalUtil.addToDictGroup((String)dictTypeCode, (DictGroupRedisVo)group);
            return group;
        }
        return null;
    }

    private static Map<String, DictGroupRedisVo> getDictGroupMap(List<String> dictTypeCodeList) {
        HashMap<String, DictGroupRedisVo> map = new HashMap<String, DictGroupRedisVo>(16);
        try {
            if (dictTypeCodeList != null && dictTypeCodeList.size() > 0) {
                List list;
                Result result;
                List unlockCodeList = dictTypeCodeList.stream().filter(dictTypeCode -> !DictUtil.checkLock(dictTypeCode)).collect(Collectors.toList());
                ArrayList<String> notCacheCodeList = new ArrayList<String>();
                for (String dictTypeCode2 : unlockCodeList) {
                    Object o = redisService.get("DICT_TYPE_GROUP_1231:" + dictTypeCode2);
                    if (o == null) {
                        notCacheCodeList.add(dictTypeCode2);
                        continue;
                    }
                    map.put(dictTypeCode2, (DictGroupRedisVo)o);
                }
                if (notCacheCodeList.size() > 0 && (result = mdmDictFeign.getDictGroupRedisList(dictTypeCodeList)).isSuccess() && (list = (List)result.getResult()) != null && list.size() > 0) {
                    Map<String, DictGroupRedisVo> collect = list.stream().collect(Collectors.toMap(DictGroupRedisVo::getDictTypeCode, v -> v));
                    for (String dictTypeCode3 : notCacheCodeList) {
                        if (!collect.containsKey(dictTypeCode3)) {
                            DictUtil.lock(dictTypeCode3);
                            continue;
                        }
                        DictUtil.addRedisCache(collect.get(dictTypeCode3));
                        map.put(dictTypeCode3, collect.get(dictTypeCode3));
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("\u6570\u636e\u5b57\u5178\u5de5\u5177\u7c7b\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
        return map;
    }

    private static void addRedisCache(DictGroupRedisVo group) {
        if (group != null) {
            redisService.set("DICT_TYPE_GROUP_1231:" + group.getDictTypeCode(), (Object)group);
        }
    }

    private static void lock(String dictTypeCode) {
        if (dictTypeCode != null && !"".equals(dictTypeCode)) {
            redisService.setSeconds("DICT_TYPE_LOCK_1231:" + dictTypeCode, (Object)dictTypeCode, 5L);
        }
    }

    private static boolean checkLock(String dictTypeCode) {
        if (dictTypeCode != null && !"".equals(dictTypeCode)) {
            return redisService.get("DICT_TYPE_LOCK_1231:" + dictTypeCode) != null;
        }
        return false;
    }

    private static String getRealDictTypeCode(String path) {
        if (StringUtils.isNotEmpty((String)path) && path.contains(PATH_SPLIT)) {
            String[] split = path.split(PATH_SPLIT);
            return split[0];
        }
        return path;
    }

    private static Map<String, String> fullMapByPath(String path) {
        List<DictDataVo> list;
        Map<String, String> map = new LinkedHashMap<String, String>(16);
        if (path != null && !"".equals(path) && (list = DictUtil.listByPath(path, false)) != null && list.size() > 0) {
            map = list.stream().collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictValue));
        }
        return map;
    }

    private static Map<String, String> singleMapByPath(String path) {
        List<DictDataVo> list;
        Map<String, String> map = new LinkedHashMap<String, String>(16);
        if (path != null && !"".equals(path) && (list = DictUtil.treeByPath(path, false)) != null && list.size() > 0) {
            map = list.stream().collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictValue));
        }
        return map;
    }

    private static List<DictDataVo> treeByPath(String path, boolean withExtend) {
        List<DictDataVo> list;
        ArrayList<DictDataVo> tree = new ArrayList<DictDataVo>();
        if (path != null && !"".equals(path) && (list = DictUtil.listByPath(path, withExtend)) != null && list.size() > 0) {
            tree.addAll(DictUtil.generateTree(list));
        }
        return tree;
    }

    private static List<DictDataVo> listByPath(String path, boolean withExtend) {
        String realDictTypeCode;
        DictGroupRedisVo dictGroup;
        if (!StringUtils.isEmpty((String)path) && (dictGroup = DictUtil.getDictGroup(realDictTypeCode = DictUtil.getRealDictTypeCode(path))) != null) {
            ArrayList<DictDataVo> list = new ArrayList<DictDataVo>();
            for (DictDataRedisVo item : dictGroup.getDataList()) {
                String path2 = path + PATH_SPLIT;
                if (!item.getPath().startsWith(path2)) continue;
                DictDataVo copy = CrmBeanUtil.copy(item, DictDataVo.class);
                if (withExtend && CollectionUtil.listNotEmptyNotSizeZero(dictGroup.getConfList())) {
                    copy.setExtendMap(DictUtil.generateExtendMap(item, dictGroup.getConfList()));
                }
                list.add(copy);
            }
            return list;
        }
        return new ArrayList<DictDataVo>();
    }

    private static Map<String, String> generateExtendMap(DictDataRedisVo data, List<DictAttrConfRedisVo> confList) {
        if (data != null && confList != null && confList.size() > 0) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (DictAttrConfRedisVo conf : confList) {
                Object obj = ReflectUtil.getFiledValueByName(data, conf.getExtField());
                map.put(conf.getFieldCode(), obj == null ? "" : (String)obj);
            }
            return map;
        }
        return Collections.emptyMap();
    }

    private static List<DictDataVo> generateTree(List<DictDataVo> totalList) {
        if (CollectionUtil.listEmpty(totalList)) {
            return new ArrayList<DictDataVo>();
        }
        ArrayList<DictDataVo> treeList = new ArrayList<DictDataVo>();
        ArrayList<Object> curLevelList = new ArrayList<Object>();
        ArrayList<Object> restList = new ArrayList<Object>();
        Map<String, DictDataVo> totalMap = totalList.stream().collect(Collectors.toMap(DictDataVo::getDictCode, v -> v));
        for (DictDataVo item : totalList) {
            if (StringUtils.isEmpty((String)item.getParentDictCode()) || !totalMap.containsKey(item.getParentDictCode())) {
                treeList.add(item);
                curLevelList.add(item);
                continue;
            }
            restList.add(item);
        }
        while (curLevelList.size() > 0 && restList.size() > 0) {
            ArrayList<DictDataVo> restTempList = new ArrayList<DictDataVo>();
            ArrayList<DictDataVo> curLevelTempList = new ArrayList<DictDataVo>();
            Map<String, String> curLevelMap = curLevelList.stream().collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictCode));
            HashMap curLevelChildrenMap = new HashMap();
            for (DictDataVo dictDataVo : restList) {
                if (curLevelMap.containsKey(dictDataVo.getParentDictCode())) {
                    curLevelTempList.add(dictDataVo);
                    ArrayList<DictDataVo> childrenList = new ArrayList<DictDataVo>();
                    if (curLevelChildrenMap.containsKey(dictDataVo.getParentDictCode())) {
                        childrenList.addAll((Collection)curLevelChildrenMap.get(dictDataVo.getParentDictCode()));
                    }
                    childrenList.add(dictDataVo);
                    curLevelChildrenMap.put(dictDataVo.getParentDictCode(), childrenList);
                    continue;
                }
                restTempList.add(dictDataVo);
            }
            for (DictDataVo dictDataVo : curLevelList) {
                if (!curLevelChildrenMap.containsKey(dictDataVo.getDictCode())) continue;
                dictDataVo.setChildren((List)curLevelChildrenMap.get(dictDataVo.getDictCode()));
            }
            curLevelList.clear();
            curLevelList.addAll(curLevelTempList);
            restList.clear();
            restList.addAll(restTempList);
        }
        return treeList;
    }
}

