package com.biz.crm.eunm.job;

import java.util.LinkedHashMap;
import java.util.Map;

/**
 * @AUTHOR: jerry7
 * @date 2020-12-22 11:29:45
 */
public enum JobColumnStr {

    //初始传递glueSource
    GLUE_SOURCE(JobIndicatorStr.GLUE_SOURCE_BEAN, JobIndicatorStr.GLUE_SOURCE_JAVA, JobIndicatorStr.GLUE_SOURCE_NODEJS,
            JobIndicatorStr.GLUE_SOURCE_PHP, JobIndicatorStr.GLUE_SOURCE_POWER_SHELL, JobIndicatorStr.GLUE_SOURCE_PYTHON,
            JobIndicatorStr.GLUE_SOURCE_SHELL);
    private Map<String, String> maps = new LinkedHashMap<>();

    /**
     * @param values 参数值
     */
    JobColumnStr(JobIndicatorStr... values) {
        for (JobIndicatorStr it : values) {
            maps.put(it.getCode(), it.getLabel());
        }
    }

    public String getLabelByCode(String code) {
        if (code == null) {
            return null;
        } else {
            return maps.get(code);
        }
    }


    public Map<String, String> getCodesAndLabels() {
        return maps;
    }

}
