package com.biz.crm.eunm.mdm;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author zxw
 * @date 2021-01-07 13:38
 **/
@AllArgsConstructor
@Getter
public enum MdmPermissionLevelEnum {

    /**
     * 权限层级
     */
    ALL("0","全部"),
    CURRENT("1", "当前"),
    CURRENT_SUB("2", "当前及下级"),
    CURRENT_UP("3", "当前及上级"),
    USER_POSITION("4", "用户所有职位"),
    DEFAULT("-1", "默认"),;

    private final String code;

    private final String desc;

    public static MdmPermissionLevelEnum convertEnum(String code) {
        if (code == null || "".equals(code.trim())) {
            return DEFAULT;
        }
        MdmPermissionLevelEnum[] values = MdmPermissionLevelEnum.values();
        for (MdmPermissionLevelEnum value : values) {
            if (value.getCode().equals(code)) {
                return value;
            }
        }
        return DEFAULT;
    }
}
