package com.biz.crm.eunm.sfa;

import java.util.HashMap;
import java.util.Map;

/**
 * @Description:sfa 拜访常量
 * @Author: liuhongming
 * @Date: 2020/9/21 18:25
 **/
public class SfaVisitEnum {

    /**
     * 拜访类型
     */
    public enum visitType {
        TEMP_VISIT("temporary", "临时拜访"), //临时拜访  计划外
        PLAN_VISIT("plan", "计划拜访"), //计划拜访-计划内
        ASSIT_TYPE("helpDefense", "协访"),; //协访
        private String val;
        private String desc;

        visitType(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (visitType type : visitType.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

    /**
     * 拜访大类型
     */
    public enum sfaVisitType {
        VISIT("visit","拜访"),
        ASSIT_TYPE("helpDefense", "协访"),; //协访
        private String val;
        private String desc;

        sfaVisitType(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (sfaVisitType type : sfaVisitType.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }


    /**
     * 拜访状态 拜访状态;0:未拜访 1:拜访中 2:拜访完成
     */
    public enum visitStatus {
        V1("0", "未拜访"),
        V2("1", "拜访中"),
        V3("2", "拜访完成"),
        V4("3", "异常"),
        ;
        private String val;
        private String desc;

        visitStatus(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (visitStatus type : visitStatus.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }


    public enum visitButton {
        NAVIGATION("1", "导航"),
        PHONE("2", "电话"),
        EXCEPTION("3", "异常"),
        VISIT("4", "拜访"),
        DETAIL("5", "详情");
        private String val;
        private String desc;

        visitButton(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (visitStatus type : visitStatus.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

    /**
     * 维度类型（线路组、网点、频率	）
     */
    public enum routeTypeEnum {
        R1("line", "线路组"),
        R2("outlets", "网点"),
        R3("rate", "频率");
        private String val;
        private String desc;

        routeTypeEnum(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (SfaVisitEnum.routeTypeEnum type : SfaVisitEnum.routeTypeEnum.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }


        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }


    /**
     * 拜访排除周几
     */
    public enum visitWeek {
        MONDAY("1", "星期一"),
        TUESDAY("2", "星期二"),
        WEDNESDAY("3", "星期三"),
        THURSDAY("4", "星期四"),
        FRIDAY("5", "星期五"),
        SATURDAY("6", "星期六"),
        SUNDAY("7", "星期天");
        private String val;
        private String desc;

        visitWeek(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (SfaVisitEnum.visitWeek type : SfaVisitEnum.visitWeek.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }


    public enum visitPicType {
        DEALER_IN_STORE_PIC("1", "进店打卡"),
        DEALER_OUT_STORE_PIC("2", "离店打卡"),
        DEALER_EXCEPTION_PIC("3", "异常报备拍照"),
        CONTEND_COMMODITY_PIC("4", "竞品采集拍照");
        private String val;
        private String desc;

        visitPicType(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (SfaVisitEnum.visitPicType type : SfaVisitEnum.visitPicType.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }


    /**
     * 客户类型
     */
    public enum visitCusType {
        VISIT_CUS_DEALER("dealer", "经销商"),
        VISIT_CUS_BATCH_DEALER("batchDealer", "分销商"),
        VISIT_CUS_TERMINAL("terminal", "终端"),
        ;
        private String val;
        private String desc;

        visitCusType(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (SfaVisitEnum.visitCusType type : SfaVisitEnum.visitCusType.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }


    public enum checkStoreType {
        REGULAR_SHELF_DISPLAY("0", "常规货架陈列"),
        MATERIAL_DISPLAY("1", "物料陈列"),
        PRICE("2", "价格签"),
        ;
        private String val;
        private String desc;

        checkStoreType(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (checkStoreType type : checkStoreType.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }


}
