package com.biz.crm.util;

import com.biz.crm.config.SpringApplicationContextUtil;
import com.biz.crm.mdm.MdmCommonUserFeign;
import com.biz.crm.mdm.permission.MdmDataPermissionFeign;
import com.biz.crm.nebular.mdm.permission.MdmPermissionSetVo;

import java.util.Collections;
import java.util.List;
import java.util.Optional;

/**
 * @author zxw
 * @date 2021-03-01 15:29
 **/
public class PermissionUtil {

    private static MdmDataPermissionFeign mdmDataPermissionFeign;

    public static List<MdmPermissionSetVo> currentUserPermissionSql(){
        if (mdmDataPermissionFeign == null) {
            mdmDataPermissionFeign = SpringApplicationContextUtil.getApplicationContext().getBean(MdmDataPermissionFeign.class);
        }
        return Optional.ofNullable(mdmDataPermissionFeign.currentUserPermissionSql())
                .map(Result::getResult)
                .orElse(Collections.emptyList());
    }
}
