package com.biz.crm.base;


import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import org.apache.commons.lang3.StringUtils;

import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import java.io.Serializable;

/**
 * @Description: 基本字段entity，用于每个表
 * @Author: zhangyuzhu
 * @Date: 2020/8/19 10:01
 **/
@Getter
@Setter
@ToString
@NoArgsConstructor
@MappedSuperclass
public class CrmBaseEntity<T> extends BaseIdEntity implements Serializable {

    private static final long serialVersionUID = -3517167521124118330L;
    /**
     * 数据状态（删除状态）
     */
    @TableField(fill = FieldFill.INSERT,updateStrategy = FieldStrategy.NOT_EMPTY)
    @Column(name = "del_flag", length = 10 )
    private String delFlag;

    /**
     * 数据业务状态（启用状态）
     */
    @TableField(fill = FieldFill.INSERT,updateStrategy = FieldStrategy.NOT_EMPTY)
    @Column(name = "enable_status", length = 10)
    private String enableStatus;

    /**
     * 创建时间 yyyy-mm-dd
     */
    @TableField(fill = FieldFill.INSERT,updateStrategy = FieldStrategy.NOT_EMPTY)
    @Column(name = "create_date", length = 20)
    private String createDate;
    /**
     * 创建时间 hh:mm:ss
     */
    @TableField(fill = FieldFill.INSERT,updateStrategy = FieldStrategy.NOT_EMPTY)
    @Column(name = "create_date_second", length = 20)
    private String createDateSecond;

    /**
     * 创建人账号
     */
    @TableField(fill = FieldFill.INSERT,updateStrategy = FieldStrategy.NOT_EMPTY)
    @Column(name = "create_code", length = 60)
    private String createCode;

    /**
     * 创建人名称
     */
    @TableField(fill = FieldFill.INSERT,updateStrategy = FieldStrategy.NOT_EMPTY)
    @Column(name = "create_name", length = 60)
    private String createName;

    /**
     * 创建人组织编码
     */
    @TableField(fill = FieldFill.INSERT,updateStrategy = FieldStrategy.NOT_EMPTY)
    @Column(name = "create_org_code", length = 40)
    private String createOrgCode;

    /**
     * 创建人组织名称
     */
    @TableField(fill = FieldFill.INSERT,updateStrategy = FieldStrategy.NOT_EMPTY)
    @Column(name = "create_org_name", length = 60)
    private String createOrgName;

    /**
     * 创建人职位code
     */
    @TableField(fill = FieldFill.INSERT,updateStrategy = FieldStrategy.NOT_EMPTY)
    @Column(name = "create_pos_code", length = 40)
    private String createPosCode;

    /**
     * 创建人职位名称
     */
    @TableField(fill = FieldFill.INSERT,updateStrategy = FieldStrategy.NOT_EMPTY)
    @Column(name = "create_pos_name", length = 60)
    private String createPosName;

    /**
     * 修改时间 yyyy-mm-dd
     */
    @TableField(fill = FieldFill.UPDATE,updateStrategy = FieldStrategy.NOT_EMPTY)
    @Column(name = "update_date", length = 20)
    private String updateDate;

    /**
     * 更新时间 hh:mm:ss
     */
    @TableField(fill = FieldFill.UPDATE,updateStrategy = FieldStrategy.NOT_EMPTY)
    @Column(name = "update_date_second", length = 20)
    private String updateDateSecond;

    /**
     * 修改人账号
     */
    @TableField(fill = FieldFill.UPDATE,updateStrategy = FieldStrategy.NOT_EMPTY)
    @Column(name = "update_code", length = 40)
    private String updateCode;

    /**
     * 修改人名称
     */
    @TableField(fill = FieldFill.UPDATE,updateStrategy = FieldStrategy.NOT_EMPTY)
    @Column(name = "update_name", length = 60)
    private String updateName;

    /**
     * 修改人组织编码
     */
    @TableField(fill = FieldFill.UPDATE,updateStrategy = FieldStrategy.NOT_EMPTY)
    @Column(name = "update_org_code", length = 40)
    private String updateOrgCode;

    /**
     * 修改人组织名称
     */
    @TableField(fill = FieldFill.UPDATE,updateStrategy = FieldStrategy.NOT_EMPTY)
    @Column(name = "update_org_name", length = 60)
    private String updateOrgName;

    /**
     * 修改人职位code
     */
    @TableField(fill = FieldFill.UPDATE,updateStrategy = FieldStrategy.NOT_EMPTY)
    @Column(name = "update_pos_code", length = 40)
    private String updatePosCode;

    /**
     * 修改人职位名称
     */
    @TableField(fill = FieldFill.UPDATE,updateStrategy = FieldStrategy.NOT_EMPTY)
    @Column(name = "update_pos_name", length = 60)
    private String updatePosName;


    /**
     * 备注
     */
    @Column(name = "remarks", length = 400)
    private String remarks;
    /**
     * 判断数据状态是否正常
     * @return
     */
    @JsonIgnore
    public boolean isNormal(){
        if(StringUtils.equals(CrmDelFlagEnum.NORMAL.getCode(),this.delFlag)){
            return true;
        }
        return false;
    }

    /**
     * 数据状态删除
     * @return
     */
    public T delete(){
        this.delFlag = CrmDelFlagEnum.DELETE.getCode();
        return (T) this;
    }

    /**
     * 数据状态正常
     * @return
     */
    public T normal(){
        this.delFlag = CrmDelFlagEnum.NORMAL.getCode();
        return (T) this;
    }

    /**
     * 业务状态启用
     * @return
     */
    public T enable(){
        this.enableStatus = CrmEnableStatusEnum.ENABLE.getCode();
        return (T) this;
    }

    /**
     * 业务状态禁用
     * @return
     */
    public T disable(){
        this.enableStatus = CrmEnableStatusEnum.DISABLE.getCode();
        return (T) this;
    }
}
