package com.biz.crm.eunm.sfa;

import java.util.HashMap;
import java.util.Map;

/**
 * @Description:sfa 拜访常量
 * @Author: liuhongming
 * @Date: 2020/9/21 18:25
 **/
public class SfaVisitEnum {

    /**
     * 拜访类型
     */
    public enum visitType {
        TEMP_VISIT("temporary", "临时拜访"), //临时拜访  计划外
        PLAN_VISIT("plan", "计划拜访"), //计划拜访-计划内
        ASSIT_TYPE("helpDefense", "协访"),; //协访
        private String val;
        private String desc;

        visitType(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (visitType type : visitType.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

    /**
     * 拜访大类型
     */
    public enum sfaVisitType {
        VISIT("visit","拜访"),
        ASSIT_TYPE("helpDefense", "协访"),; //协访
        private String val;
        private String desc;

        sfaVisitType(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (sfaVisitType type : sfaVisitType.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }


    /**
     * 拜访状态 拜访状态;0:未拜访 1:拜访中 2:拜访完成
     */
    public enum visitStatus {
        V1("0", "未拜访"),
        V2("1", "拜访中"),
        V3("2", "拜访完成"),
        V4("3", "异常"),
        ;
        private String val;
        private String desc;

        visitStatus(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (visitStatus type : visitStatus.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }


    public enum visitButton {
        NAVIGATION("1", "导航"),
        PHONE("2", "电话"),
        EXCEPTION("3", "异常"),
        VISIT("4", "拜访"),
        DETAIL("5", "详情");
        private String val;
        private String desc;

        visitButton(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (visitStatus type : visitStatus.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

    /**
     * 维度类型（线路组、网点、频率	）
     */
    public enum routeTypeEnum {
        R1("line", "线路组"),
        R2("outlets", "网点"),
        R3("rate", "频率");
        private String val;
        private String desc;

        routeTypeEnum(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (SfaVisitEnum.routeTypeEnum type : SfaVisitEnum.routeTypeEnum.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }


        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }


    /**
     * 拜访排除周几
     */
    public enum visitWeek {
        MONDAY("1", "星期一"),
        TUESDAY("2", "星期二"),
        WEDNESDAY("3", "星期三"),
        THURSDAY("4", "星期四"),
        FRIDAY("5", "星期五"),
        SATURDAY("6", "星期六"),
        SUNDAY("7", "星期天");
        private String val;
        private String desc;

        visitWeek(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (SfaVisitEnum.visitWeek type : SfaVisitEnum.visitWeek.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }


    public enum visitPicType {
        DEALER_IN_STORE_PIC("1", "进店打卡"),
        DEALER_OUT_STORE_PIC("2", "离店打卡"),
        DEALER_EXCEPTION_PIC("3", "异常报备拍照"),
        CONTEND_COMMODITY_PIC("4", "竞品采集拍照"),
        REGULAR_SHELF_DISPLAY("5", "常规货架陈列"),
        MATERIAL_DISPLAY("6", "物料陈列"),
        PRICE("7", "价格签");

        private String val;
        private String desc;

        visitPicType(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (SfaVisitEnum.visitPicType type : SfaVisitEnum.visitPicType.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }


    /**
     * 客户类型
     */
    public enum visitCusType {
        VISIT_CUS_DEALER("dealer", "经销商"),
        VISIT_CUS_BATCH_DEALER("batchDealer", "分销商"),
        VISIT_CUS_TERMINAL("terminal", "终端"),
        ;
        private String val;
        private String desc;

        /**
         * 系统数据字典
         */
        public static final String DICT_CODE = "sfacusType";
        visitCusType(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (SfaVisitEnum.visitCusType type : SfaVisitEnum.visitCusType.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }


    public enum checkStoreType {
        REGULAR_SHELF_DISPLAY("0", "常规货架陈列"),
        MATERIAL_DISPLAY("1", "物料陈列"),
        PRICE("2", "价格签"),
        ;
        private String val;
        private String desc;

        checkStoreType(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (checkStoreType type : checkStoreType.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

    /**
     * 协访状态
     */
    public enum helpDefenseStatus {
        READY_HELP_DEFENSE("0", "待协访"),
        IN_HELP_DEFENSE("1", "协访中"),
        ALREADY_SUCCESS("2", "已协访"),
        ALREADY_OVERDUE("3","已过期"),
        ;
        private String val;
        private String desc;

        helpDefenseStatus(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (helpDefenseStatus type : helpDefenseStatus.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }


    /**
     * 是否完成
     */
    public enum isSuccess {
        NOT_SUCCESS("0", "未完成"),
        ALREADY_SUCCESS("1", "已完成"),
        ;
        private String val;
        private String desc;

        isSuccess(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (isSuccess type : isSuccess.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }


    /**
     * 拜访步骤
     */
    public enum visitStep {
        VISIT_STEP_IN_STORE(visitStep.inStore,"进店打卡"),
        VISIT_STEP_OUT_STORE(visitStep.outStore,"离店打卡"),
        VISIT_STEP_STOCK(visitStep.stock,"库存盘点"),
        VISIT_STEP_COMPETITOR(visitStep.competitor,"竞品采集"),
        VISIT_STEP_ORDER(visitStep.order,"订单采集"),
        VISIT_STEP_DISPLAY(visitStep.display,"陈列活动"),
        VISIT_STEP_COST(visitStep.cost,"费用活动"),
        VISIT_STEP_TPM(visitStep.tpm,"tpm活动"),
        VISIT_STEP_SUMMARY(visitStep.summary,"拜访总结"),
        VISIT_STEP_STORE_CHECK(visitStep.storeCheck,"店面检查"),
        ;

        /** 进店打卡 */
        public static final String inStore = "inStore";
        /** 离店打卡 */
        public static final String outStore = "outStore";
        /** 库存盘点 */
        public static final String stock = "stock";
        /** 竞品采集 */
        public static final String competitor = "competitor";
        /** 订单采集 */
        public static final String order = "order";
        /** 陈列活动 */
        public static final String display = "display";
        /** 费用活动 */
        public static final String cost = "cost";
        /** tpm活动 */
        public static final String tpm = "tpm";
        /** 拜访总结 */
        public static final String summary = "summary";
        /** 店面检查 */
        public static final String storeCheck = "storeCheck";


        private String val;
        private String desc;

        visitStep(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (visitStep type : visitStep.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }



    /**
     * 是否合格
     */
    public enum isQualified {
        QUALIFIED("1","合格"),
        NOT_QUALIFIED("0","不合格"),

        ;
        private String val;
        private String desc;

        isQualified(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (isQualified type : isQualified.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }
}
