package com.biz.crm.util;

import com.biz.crm.common.param.RedisParam;
import com.biz.crm.mdm.approval.MdmApprovalConfigFeign;
import com.biz.crm.nebular.mdm.approval.resp.MdmApprovalConfigRedisVo;
import com.biz.crm.service.RedisService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Slf4j
public class ApprovalConfigUtil {

    private static RedisService redisService;

    private static MdmApprovalConfigFeign mdmApprovalConfigFeign;

    public static void setRedisService(RedisService redis) {
        redisService = redis;
    }

    public static void setMdmApprovalConfigFeign(MdmApprovalConfigFeign approvalConfigFeign) {
        mdmApprovalConfigFeign = approvalConfigFeign;
    }

    public static MdmApprovalConfigRedisVo getConfig(String menuCode, String businessCode) {
        return getConfig(menuCode, businessCode, false);
    }

    public static MdmApprovalConfigRedisVo getConfig(String menuCode, String businessCode, boolean notNull) {
        Assert.hasText(menuCode, "缺失菜单编码");
        Assert.hasText(businessCode, "缺失业务编码");
        if (!StringUtils.isEmpty(menuCode) && !StringUtils.isEmpty(businessCode)) {
            MdmApprovalConfigRedisVo redisVo = get(menuCode, businessCode);
            if (notNull) {
                Assert.notNull(redisVo, "未找到配置");
            }
            return redisVo;
        }
        return null;
    }
//
//    public static boolean check(String menuCode, String businessCode, Object paramObj) {
//        boolean flag = false;
//        try {
//            MdmApprovalConfigRedisVo redisVo = get(menuCode, businessCode);
//            if (redisVo != null) {
//                if (CrmEnableStatusEnum.ENABLE.getCode().equals(redisVo.getEnableStatus())) {
//                    if (YesNoEnum.yesNoEnum.ONE.getValue().equals(redisVo.getControlFlag())) {
//                        if (MdmApprovalConfig.ControlScope.PART.getValue().equals(redisVo.getControlScope())) {
//                            List<MdmApprovalConfigConditionRedisVo> conditionList = redisVo.getConditionList();
//                            if (CollectionUtil.listEmpty(conditionList)) {
//                                throw new BusinessException("缺失配置条件");
//                            }
//                            Map<String, Boolean> conditionResultMap = new HashMap<>(16);
//                            for (MdmApprovalConfigConditionRedisVo condition :
//                                    conditionList) {
//                                String fieldCode = condition.getFieldCode();
//                                if (!ReflectUtil.checkFieldExist(paramObj, fieldCode)) {
//                                    throw new BusinessException("参数未找到字段" + condition.getFieldName() + "[" + condition.getFieldCode() + "]");
//                                }
//                                Object filedValueObj = ReflectUtil.getFiledValueByName(paramObj, fieldCode);
//                                boolean b = checkCondition(filedValueObj == null ? "" : filedValueObj.toString(), condition);
//                                if (MdmApprovalConfig.ConditionLogicalType.OR.getValue().equals(redisVo.getConditionLogicalType())) {
//                                    if (b) {
//                                        return true;
//                                    }
//                                }
//                                if (MdmApprovalConfig.ConditionLogicalType.AND.getValue().equals(redisVo.getConditionLogicalType())) {
//                                    if (!b) {
//                                        return false;
//                                    }
//                                }
//                                conditionResultMap.put(condition.getFieldCode(), b);
//                            }
//                            if (MdmApprovalConfig.ConditionLogicalType.OR.getValue().equals(redisVo.getConditionLogicalType())) {
//                                List<Boolean> collect = conditionResultMap.values().stream().filter(x -> x).collect(Collectors.toList());
//                                if (!collect.isEmpty()) {
//                                    return true;
//                                }
//                            } else if (MdmApprovalConfig.ConditionLogicalType.AND.getValue().equals(redisVo.getConditionLogicalType())) {
//                                List<Boolean> collect = conditionResultMap.values().stream().filter(x -> !x).collect(Collectors.toList());
//                                if (collect.isEmpty()) {
//                                    return true;
//                                } else {
//                                    return false;
//                                }
//                            } else {
//                                //自定义
//                            }
//                        } else {
//                            //全部
//                            flag = true;
//                        }
//                    } else {
//                        //关闭
//                    }
//                } else {
//                    //禁用
//                }
//            } else {
//                //未找到配置
//            }
//        } catch (Exception e) {
//            //TODO 异常
//        }
//        return flag;
//    }
//
//    private static boolean checkCondition(String fieldValue, MdmApprovalConfigConditionRedisVo condition) {
//        if (!YesNoEnum.yesNoEnum.ONE.getValue().equals(condition.getControlFlag())) {
//            return true;
//        }
//        String fieldKeywords = condition.getFieldKeywords();
//        if (StringUtils.isEmpty(fieldKeywords)) {
//            throw new BusinessException("条件" + condition.getFieldName() + "缺失关键值");
//        }
//        String[] split = fieldKeywords.split(",");
//        for (String keywords :
//                split) {
//            if (MdmApprovalConfig.FieldCompareType.EQ.getValue().equals(condition.getCompareType())) {
//                if (fieldValue.equals(keywords)) {
//                    return true;
//                }
//            }
//        }
//        return false;
//    }

    public static void deleteCache(String menuCode) {
        if (StringUtils.isEmpty(menuCode)) {
            return;
        }
        deleteCache(Collections.singletonList(menuCode));
    }

    public static void deleteCache(List<String> menuCodeList) {
        if (menuCodeList == null || menuCodeList.size() == 0) {
            return;
        }
        Set<String> keys = new HashSet<>(16);
        for (String menuCode :
                menuCodeList) {
            keys.addAll(redisService.keys(connectKey(menuCode, "*")));
        }
        if (!keys.isEmpty()) {
            redisService.del(keys.toArray(new String[keys.size()]));
        }
    }

    public static void deleteCache(String menuCode, String businessCode) {
        redisService.del(connectKey(menuCode, businessCode));
        redisService.del(connectKeyLock(menuCode, businessCode));
    }

    /*-------------------------------------------------以下为私有方法-------------------------------------------------*/

    private static MdmApprovalConfigRedisVo get(String menuCode, String businessCode) {
        MdmApprovalConfigRedisVo redisVo = null;
        if (!checkLock(menuCode, businessCode)) {
            String key = connectKey(menuCode, businessCode);
            Object o = redisService.get(key);
            if (o == null) {
                Result<MdmApprovalConfigRedisVo> result = mdmApprovalConfigFeign.queryForRedis(menuCode, businessCode);
                Assert.isTrue(result.isSuccess(), "获取审批配置失败");
                if (result.getResult() == null) {
                    lock(menuCode, businessCode);
                } else {
                    redisVo = result.getResult();
                    redisService.setDays(key, redisVo, RedisParam.TIME30);
                }
            } else {
                redisVo = (MdmApprovalConfigRedisVo) o;
            }
        }
        return redisVo;
    }

    private static void lock(String menuCode, String businessCode) {
        String lockKey = connectKeyLock(menuCode, businessCode);
//        redisService.setSeconds(lockKey, lockKey, RedisParam.TIME5);
        redisService.setDays(lockKey, lockKey, RedisParam.TIME30);
    }

    private static boolean checkLock(String menuCode, String businessCode) {
        return redisService.get(connectKeyLock(menuCode, businessCode)) != null;
    }

    private static String connectKey(String menuCode, String businessCode) {
        return RedisParam.MDM_APPROVAL_CONFIG + "/" + menuCode + ":/" + businessCode;
    }

    private static String connectKeyLock(String menuCode, String businessCode) {
        return RedisParam.MDM_APPROVAL_CONFIG_LOCK + "/" + menuCode + ":/" + businessCode;
    }

}
