package com.biz.crm.wx;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.config.GlobalExceptionHandler;
import com.biz.crm.config.resttemplate.RestTemplateUtils;
import com.biz.crm.nebular.mdm.mdmbuglistmanagement.req.MdmBugListManagementReqVo;
import com.biz.crm.util.Result;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import javax.validation.constraints.Max;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.wx
 * @Description: TODO
 * @date 2020/12/29 下午2:31
 */
@Slf4j
@Component
public class WxMsgUtil {
    public static final String markdown = "markdown";
    public static final String text = "text";
    private static String wxUrl;
    @Value("${WxMsgUrl:}")
    private String wxMsgUrl;
    @PostConstruct
    public void setUrl(){
        if(StringUtils.isEmpty(this.wxMsgUrl)){
            wxUrl="https://qyapi.weixin.qq.com/cgi-bin/webhook/send?key=e6170edb-0633-4601-ad0e-7c9ec4dc834f";
        }else {
            wxUrl=this.wxMsgUrl;
        }
    }

    public static void sendMarkdownMsg(String msg){
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("msgtype",markdown);
        JSONObject markdown = new JSONObject();
        markdown.put("content",msg);
        jsonObject.put("markdown",markdown);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        ResponseEntity<Result> response = RestTemplateUtils.postForEntity(wxUrl, headers, jsonObject, Result.class);
    }

    /**
     *
     * @param reqVo
     */
    // TODO: 2021/2/22  得拼接名字和手机号 检验   需要加字段
    public static void sendBugMsg(MdmBugListManagementReqVo reqVo) {
        StringBuilder stringBuffer = new StringBuilder();
        try {
            stringBuffer.append(reqVo.getChargeMan()+" 您有新的加急处理禅道事项,编码:"+reqVo.getBugCode());
        }catch (Exception e){
            log.error("消息微信推送失败",e);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("msgtype",text);
        JSONObject text = new JSONObject();
        text.put("mentioned_mobile_list", Lists.newArrayList(reqVo.getCodeByPhone()));
        text.put("content",stringBuffer.toString());
        jsonObject.put("text",text);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        ResponseEntity<Result> response = RestTemplateUtils.postForEntity(wxUrl, headers, jsonObject, Result.class);;
    }
    public static void sendTextMsg(String msg){
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("msgtype","text");
        JSONObject text = new JSONObject();
        text.put("content",msg);
        jsonObject.put("text",text);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        ResponseEntity<Result> response = RestTemplateUtils.postForEntity(wxUrl, headers, jsonObject, Result.class);
    }


}
