package com.biz.crm.config.resttemplate;

import lombok.SneakyThrows;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.TrustStrategy;
import org.springframework.http.client.SimpleClientHttpRequestFactory;

import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import java.net.HttpURLConnection;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

/**
 * @Description:
 * @project：crm
 * @package：com.biz.crm.config.restTemplate
 * @author：lifei
 * @create：2020/12/3 4:41 下午
 */
public class HttpsClientRequestFactory extends SimpleClientHttpRequestFactory {

    @SneakyThrows
    @Override
    protected void prepareConnection(HttpURLConnection connection, String httpMethod) {
        if (!(connection instanceof HttpsURLConnection)) {// http协议
            //throw new RuntimeException("An instance of HttpsURLConnection is expected");
            super.prepareConnection(connection, httpMethod);
        }
        if (connection instanceof HttpsURLConnection) {// https协议，修改协议版本
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            // 信任任何链接
            TrustStrategy anyTrustStrategy = new TrustStrategy() {
                @Override
                public boolean isTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                    return true;
                }
            };
            SSLContext ctx = SSLContexts.custom().useTLS().loadTrustMaterial(trustStore, anyTrustStrategy).build();
            ((HttpsURLConnection) connection).setSSLSocketFactory(ctx.getSocketFactory());
            HttpsURLConnection httpsConnection = (HttpsURLConnection) connection;
            super.prepareConnection(httpsConnection, httpMethod);
        }
    }
}
