package com.biz.crm.eunm.sfa;

import java.util.HashMap;
import java.util.Map;

/**
 * @Description:
 * @project：crm
 * @package：com.biz.crm.enums
 * @author：lifei
 * @create：2020/11/27 11:13 上午
 */
public class SfaCodeEnum {

    /**
     * 公告编码
     */
    public enum NoticeCode {
        SFA_NOTICE_CODE("notice_code","公告编码"),
        ;
        private String val;
        private String desc;

        NoticeCode(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (NoticeCode type : NoticeCode.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

    /**
     * 拜访步骤编码
     */
    public enum VisitStepCode {
        SFA_VISIT_STEP_CODE("sfa_visit_step","拜访步骤编码"),
        ;
        private String val;
        private String desc;

        VisitStepCode(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (VisitStepCode type : VisitStepCode.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }


    /**
     * 线路组编码
     */
    public enum VisitGroupCode {
        SFA_VISIT_GROUP_CODE("sfa_visit_group","线路组编码"),
        ;
        private String val;
        private String desc;

        VisitGroupCode(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (VisitGroupCode type : VisitGroupCode.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }


    /**
     * 拜访计划编码
     */
    public enum VisitPLanCode {
        SFA_VISIT_LINE_CODE("sfa_visit_line_code","线路组拜访计划编码"),
        SFA_VISIT_OUTLETS_CODE("sfa_visit_outlets_code","网点拜访计划编码"),
        SFA_VISIT_RATE_CODE("sfa_visit_rate_code","频率拜访计划编码"),
        ;
        private String val;
        private String desc;

        VisitPLanCode(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (VisitPLanCode type : VisitPLanCode.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

    /**
     * 订单编码
     */
    public enum ORDER_CODE {
        SFA_ORDER_CODE("order_code","订单编码"),
        ;
        private String val;
        private String desc;

        ORDER_CODE(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (ORDER_CODE type : ORDER_CODE.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

    /**
     * 活动编码
     */
    public enum activityCode {
        ACTIVITY_CODE("activity_code","活动编码"),
        ;
        private String val;
        private String desc;

        activityCode(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (activityCode type : activityCode.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

    /**
     * 活动方案编码
     */
    public enum schemeCode {
        SCHEME_CODE("scheme_code","活动方案编码"),
        SCHEME_ACTIVITY_CODE("scheme_activity_code","方案活动编码"),
        ;
        private String val;
        private String desc;

        schemeCode(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (activityCode type : activityCode.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

}
