package com.biz.crm.util;

import org.apache.commons.beanutils.PropertyUtils;
import org.springframework.util.ReflectionUtils;

import java.lang.reflect.Field;

/**
 * 反射工具类
 *
 * @author Tao.Chen
 * @date 2020-11-21 10:35:54
 */
public class ReflectUtil extends ReflectionUtils {

    /**
     * 通过反射给对象字段赋值
     *
     * @param object    对象
     * @param filedName 字段名
     * @param value     字段值
     */
    public static void setFieldValue(Object object, String filedName, Object value) {
        if (object != null && filedName != null && !"".equals(filedName)) {
            Field field = ReflectionUtils.findField(object.getClass(), filedName);
            if (field != null) {
                ReflectionUtils.makeAccessible(field);
                ReflectionUtils.setField(field, object, value);
            }
        }
    }

    /**
     * 反射获取对象中的字段值
     *
     * @param obj  对象
     * @param name 字段名
     * @return
     */
    public static Object getFiledValueByName(Object obj, String name) {
        Object simpleProperty;
        try {
            simpleProperty = PropertyUtils.getSimpleProperty(obj, name);
        } catch (NullPointerException e) {
            return "";
        } catch (Exception e) {
            e.printStackTrace();
            return "";
        }
        return simpleProperty;
    }

    /**
     * 校验对象中是否存在字段
     *
     * @param obj  对象
     * @param name 字段名
     * @return
     */
    public static boolean checkFieldExist(Object obj, String name) {
        boolean flag = false;
        try {
            Object simpleProperty = PropertyUtils.getSimpleProperty(obj, name);
            flag = true;
        } catch (Exception e) {
            flag = false;
        }
        return flag;
    }
}