package com.biz.crm.eunm.sfa;

/**
 * @Description:sfa     考勤常量
 * @Author: liuhongming
 * @Date: 2020/9/21 18:25
 **/
public class SfaWorkSignEnum {


    /**
     * 规则类型 FREE:自由签到; STATIC:固定时间上下班规则; FREE_TIME:自由时间上下班规则
     */
    public enum WorkSignRuleType {
        /** 自由签到 */
        FREE("FREE","自由签到"), //自由签到
        /** 固定时间上下班规则 */
        STATIC("STATIC","固定时间上下班规则"), //固定时间上下班规则
        /** 自由时间上下班规则 */
        FREE_TIME("FREE_TIME","自由时间上下班规则"); //自由时间上下班规则
        private String val;
        private String desc;

        /** 查询描述信息 */
        public static String getDesc(String val) {
            for(WorkSignRuleType e : WorkSignRuleType.values()) {
                if(e.getVal().equals(val)) {
                    return e.getDesc();
                }
            }
            return null;
        }

        WorkSignRuleType(String val,String desc) {
            this.val = val;
            this.desc = desc;
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }
    public enum ElectronFenceEnum {
        /** 无电子围栏 */
        NONE("NONE","无电子围栏"), //无电子围栏
        /** 允许范围外打卡，地点记录为异常 */
        OUT_SIGN_EX("OUT_SIGN_EX","允许范围外打卡，地点记录为异常"), //允许范围外打卡，地点记录为异常
        /** 允许范围外打卡，地点记录为正常 */
        OUT_SIGN_OK("OUT_SIGN_OK","允许范围外打卡，地点记录为正常"), //允许范围外打卡，地点记录为正常
        /** 不允许范围外打卡 */
        NO_OUT_SIGN("NO_OUT_SIGN","不允许范围外打卡");
        private String val;
        private String desc;

        ElectronFenceEnum(String val,String desc) {
            this.val = val;
            this.desc = desc;
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }
    /**
     * 规则生效日期
     */
    public enum RuleEffective {
        /** 马上生效 */
        NOW("NOW","马上生效"),
        /** 明日生效 */
        TOMORROW("TOMORROW","明日生效");
        private String val;
        private String desc;

        RuleEffective(String val,String desc) {
            this.val = val;
            this.desc = desc;
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

    /**
     * 签到地点状态 OK : 正常; EX : 异常;
     */
    public enum wsPlaceStatusEnum {
        OK("OK","正常"),
        EX("EX","异常");
        private String val;
        private String desc;


        /** 查询描述信息 */
        public static String getDesc(String val) {
            for(wsPlaceStatusEnum e : wsPlaceStatusEnum.values()) {
                if(e.getVal().equals(val)) {
                    return e.getDesc();
                }
            }
            return null;
        }

        wsPlaceStatusEnum(String val,String desc) {
            this.val = val;
            this.desc = desc;
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

    /**
     * 工作日
     */
    public enum workingDayEnum {
        Mon("1","星期一"),
        Tues("2","星期二"),
        Wed("3","星期三"),
        Thur("4","星期四"),
        Fri("5","星期五"),
        Sat("6","星期六"),
        Sun("7","星期日");
        private String val;
        private String desc;

        workingDayEnum(String val,String desc) {
            this.val = val;
            this.desc = desc;
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }


    /**
     * 下班打卡限制
     *  @author: luoqi
     *  @Date: 2020-11-11 14:09
     *  @version: V1.0
     *  @Description:
     */
    public enum GooffWorkSignAstrictEnum {
        /** 下班不需要打卡 */
        NO_SIGN("NO_SIGN","下班不需要打卡"),
        /** 下班需要打卡，且必须打上班卡才能打下班卡 */
        GOTO_WORK_REQUIRED("GOTO_WORK_REQUIRED","下班需要打卡，且必须打上班卡才能打下班卡"),
        /** 下班需要打卡，无需打上班卡，就能打下班卡 */
        GOTO_WORK_NO_REQUIRED("GOTO_WORK_NO_REQUIRED","下班需要打卡，无需打上班卡，就能打下班卡");
        private String val;
        private String desc;

        GooffWorkSignAstrictEnum(String val,String desc) {
            this.val = val;
            this.desc = desc;
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

    /**
     * 特殊日期 - 类型
     */
    public enum workSignSpecialType{
        One("1","必须打卡的日期"),
        Two("2","不用打卡的日期");
        private String val;
        private String desc;

        workSignSpecialType(String val,String desc) {
            this.val = val;
            this.desc = desc;
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

    /**
     * 打卡类型 CLOCK_IN : 上班签到; CLOCK_OUT : 下班签退;
     */
    public enum WorkSignType {
        CLOCK_ALL("CLOCK_ALL", "上下班打卡"), //上下班打卡
        CLOCK_IN("CLOCK_IN","上班签到"), //上班签到
        CLOCK_OUT("CLOCK_OUT","下班签退"); //下班签退
        private String val;
        private String desc;

        /** 查询描述信息 */
        public static String getDesc(String val) {
            for(WorkSignType e : WorkSignType.values()) {
                if(e.getVal().equals(val)) {
                    return e.getDesc();
                }
            }
            return null;
        }

        WorkSignType(String val,String desc) {
            this.val = val;
            this.desc = desc;
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

    /**
     * 签到签退状态 NONE:未打卡;OK:正常;BE_LATE:迟到;LEAVE_EARLY:早退;
     */
    public enum WorkSignStatus {
        OK("OK","正常"),
        BE_LATE("BE_LATE","迟到"),
        LEAVE_EARLY("LEAVE_EARLY","早退"),
        NONE("NONE","未打卡");
        private String val;
        private String desc;

        /** 查询描述信息 */
        public static String getDesc(String val) {
            for(WorkSignStatus e : WorkSignStatus.values()) {
                if(e.getVal().equals(val)) {
                    return e.getDesc();
                }
            }
            return null;
        }

        WorkSignStatus(String val,String desc) {
            this.val = val;
            this.desc = desc;
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

    /**
     * 考勤规则制定的考勤状态
     */
    public enum SignRuleStatus {
        ATTENDANCE("OK+OK", "出勤")
        ,LATE("BE_LATE+OK", "迟到")
        ,EARLY("OK+LEAVE_EARLY", "早退")
        ,LATE_EARLY("BE_LATE+LEAVE_EARLY", "迟到+早退")
        ,MORNING_TRUANCY("NONE+OK", "旷工")
        ,MORNING_EARLY("NONE+LEAVE_EARLY", "旷工")
        ,MORNING_NIGHT("NONE+NONE", "旷工")
        ,NIGHT_TRUANCY("OK+NONE", "旷工")
        ,NIGHT_LATE("BE_LATE+NONE", "旷工")
        ;
        private String val;
        private String desc;

        /** 查询描述信息 */
        public static String getDesc(String val) {
            for(SignRuleStatus e : SignRuleStatus.values()) {
                if(e.getVal().equals(val)) {
                    return e.getDesc();
                }
            }
            return null;
        }

        SignRuleStatus(String val,String desc) {
            this.val = val;
            this.desc = desc;
        }
        public String getVal() {
            return val;
        }
        public String getDesc() {
            return desc;
        }
    }

    /**
     * 有效期数据字典key枚举
     */
    public enum SignRuleIndateKey{
        SIGN_RULE_INDATE("sign_rule_indate", "考勤有效期规则key")
        ,OVERTIME_INDATE("overtime_indate","加班调休有效期key")
        ,LEAVE_INDATE("leave_indate", "请假对冲有效期key")
        ;
        private String val;
        private String desc;

        /** 查询描述信息 */
        public static String getDesc(String val) {
            for(SignRuleIndateKey e : SignRuleIndateKey.values()) {
                if(e.getVal().equals(val)) {
                    return e.getDesc();
                }
            }
            return null;
        }

        SignRuleIndateKey(String val,String desc) {
            this.val = val;
            this.desc = desc;
        }
        public String getVal() {
            return val;
        }
        public String getDesc() {
            return desc;
        }
    }

}
