package com.biz.crm.config;

import com.biz.crm.util.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport;

import java.util.ArrayList;
import java.util.List;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.config
 * @Description: TODO
 * @date 2020/11/18 上午11:28
 */
@Configuration
public class WebConfig extends WebMvcConfigurationSupport {
    //spring.resources.static-locations
    @Value("${spring.resources.static-locations:}")
    private String[] resourceslocations;
    @Value("${crm.whitelist:}")
    private String[] whiteList;
    @Value("${oss.localPath:}")
    private String localPath;
    /**
     * @return
     */
    @Bean
    LoginInterceptor loginInterceptor() {
        return new LoginInterceptor();
    }

    @Autowired
    private ResultResponseInterceptor resultResponseInterceptor;
    /**
     * 添加拦截器
     *
     * @param registry
     */
    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        List<String> excludeUrl = new ArrayList<>();
        if(resourceslocations!=null){
            for(String temp : this.resourceslocations){
                if(StringUtils.isNotEmpty(temp)){
                    excludeUrl.add(temp);
                }
            }
        }
        if(whiteList!=null){
            for(String temp : this.whiteList){
                if(StringUtils.isNotEmpty(temp)){
                    excludeUrl.add(temp);
                }
            }
        }
//        registry.addInterceptor(resultResponseInterceptor);
        registry.addInterceptor(loginInterceptor()).excludePathPatterns(excludeUrl);
    }
    /**
     * 配置静态资源
     * @param registry
     */
    @Override
    protected void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler("/activitipage/**").addResourceLocations("classpath:/activitipage/");
        // 解决swagger无法访问
        registry.addResourceHandler("/doc.html").addResourceLocations("classpath:/META-INF/resources/");
        // 解决swagger的js文件无法访问
        registry.addResourceHandler("/webjars/**").addResourceLocations("classpath:/META-INF/resources/webjars/");
        if(StringUtils.isNotEmpty(localPath)){
            registry.addResourceHandler("/crmfile/**").addResourceLocations("file:"+localPath);
        }
        super.addResourceHandlers(registry);
    }
}
