package com.biz.crm.eunm.tpm;

import org.apache.commons.lang3.StringUtils;

/**
 * @author maoshen
 * @date 2021/2/3.
 */
public enum IncomeGroupEnum {
    ORG("org","组织"),
    TERMINAL("terminal","门店"),
    CUSTOMER("customer","客户"),
    PRODUCT("product","产品")
    ;
    private String code;
    private String des;

    IncomeGroupEnum(String code, String des) {
        this.code =code;
        this.des = des;
    }

    public static String getStatusName(String code){
        IncomeGroupEnum[] values = IncomeGroupEnum.values();
        String desc=null;
        for (IncomeGroupEnum o : values){
            if(StringUtils.equals(o.getCode(),code)){
                desc=o.getDes();
                break;
            }
        }
        return desc;
    }
    public static String getStatusCode(String des){
        IncomeGroupEnum[] values = IncomeGroupEnum.values();
        String code=null;
        for (IncomeGroupEnum o : values){
            if(StringUtils.equals(o.getDes(),des)){
                code=o.getCode();
                break;
            }
        }
        return code;
    }
    public String getCode() {
        return code;
    }

    public String getDes() {
        return des;
    }
}
