package com.biz.crm.eunm.tpm;

import org.apache.commons.lang3.StringUtils;

/**
 * @Description:crm 酒类活动预算事务明细的业务操作类型枚举
 * @Author: huanglong
 * @Date: 2020/8/20 18:25
 **/
public enum LiqueurActBudgetBusinessTypeEnum {
    ACT("act","活动申请"),
    ACT_REGISTER("act_register","活动明细登记"),
    AUDIT("audit","活动核销"),

;

    private String code;
    private String des;

    LiqueurActBudgetBusinessTypeEnum(String code, String des) {
        this.code = code;
        this.des = des;
    }
    public static String getStatusName(String code){
        LiqueurActBudgetBusinessTypeEnum[] values = LiqueurActBudgetBusinessTypeEnum.values();
        String desc=null;
        for (LiqueurActBudgetBusinessTypeEnum o : values){
            if(StringUtils.equals(o.getCode(),code)){
                desc=o.getDes();
                break;
            }
        }
        return desc;
    }
    public String getCode() {
        return code;
    }

    public String getDes() {
        return des;
    }
}
