package com.biz.crm.exception.tpm;

import com.biz.crm.exception.CrmExceptionType;

/**
 * @Project crm
 * @PackageName com.biz.crm.exception.tpm
 * @ClassName FeeBudgetException
 * @Author HuangLong
 * @Date 2020/9/2 11:04
 * @Description 活动异常枚举
 */
public enum ActException implements CrmExceptionType {

    DATA_NOT_EXIST("tpm_70001","活动数据不存在"),
    DATA_DUPLICATE("tpm_70002","活动数据重复,请检查"),
    DATA_CODE_DUPLICATE("tpm_70003","活动编码已存在,请检查"),
    ;

    private String code;
    private String description;

    ActException(String code, String description) {
        this.code = code;
        this.description = description;
    }

    @Override
    public String getCode() {
        return code;
    }

    @Override
    public String getDescription() {
        return description;
    }
}
