package com.biz.crm.eunm.sfa;

import java.util.HashMap;
import java.util.Map;

/**
 * @author lf
 * @describe 计算薪资日期日志表实体类
 * @project crm
 * @package com.biz.crm.eunm.sfa
 * @date 2020/12/30 15:52
 */
public class SfaActivityEnum {

    /**
     * 活动类型
     */
    public enum activityType {
        COST_ACTIVITY("cost", "费用活动"),
        DISPLAY_ACTIVITY("display", "陈列活动"),
        TPM_ACTIVITY("tpm","tpm活动"),
        SCHEME_ACTIVITY("scheme","方案活动");
        private String val;
        private String desc;

        activityType(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (activityType type : activityType.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

    /**
     * 活动状态
     */
    public enum activityStatus {
        NOT_START("0", "未开始"),
        ALREADY_START("1", "已开始"),
        ALREADY_END("2","已结束"),
        ;
        private String val;
        private String desc;

        activityStatus(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (activityStatus type : activityStatus.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

    /**
     * 活动要求
     */
    public enum activityRequire {
        ACTIVITY_PIC("0", "活动照"),
        DOOR_PIC("1", "门头照"),
        DISPLAY_PIC("2","陈列照"),
        ;
        private String val;
        private String desc;

        activityRequire(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (activityRequire type : activityRequire.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }


    /**
     * 活动范围类型
     */
    public enum rangeType {
        ORG("0", "组织"),
        CHANNEL("1", "渠道"),
        CUSTOMER("2","客户"),
        ;
        private String val;
        private String desc;

        rangeType(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (rangeType type : rangeType.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }


    /**
     * 活动范围类型
     */
    public enum actSchemeRangeType {
        ORG("0", "组织"),
        POSLEVEL("1", "职位级别"),
        POS("2", "职位"),
        ;
        private String val;
        private String desc;

        actSchemeRangeType(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (actSchemeRangeType type : actSchemeRangeType.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

    /**
     * 方案活动产品行类型
     */
    public enum bpItemType {
        bp("1", "本品"),
        zp("2", "赠品"),
        ;
        private String val;
        private String desc;

        bpItemType(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (bpItemType type : bpItemType.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }


    /**
     * 方案活动结兑付方式
     */
    public enum paymentMethod {
        XJ("xj", "现金兑付"),
        HW("hw", "货物兑付");
        private String val;
        private String desc;

        paymentMethod(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (paymentMethod type : paymentMethod.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }
    /**
     * 方案活动结案状态
     */
    public enum schemeEndCaseState {
        NOT("0", "未结案"),
        TOO("1", "已结案");
        private String val;
        private String desc;

        schemeEndCaseState(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (schemeEndCaseState type : schemeEndCaseState.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

    /**
     * 方案活动执行  参与类型
     */
    public enum participateInType {
        F("0", "免费参与"),
        A("1", "协议参与");
        private String val;
        private String desc;

        participateInType(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (participateInType type : participateInType.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

    /**
     * 方案活动执行  协议状态
     */
    public enum TreatyStatus {
        IN_EXECUTION("0", "执行中"),
        CASHED("1", "已兑付"),
        END("2", "终止"),
        ;
        private String val;
        private String desc;

        TreatyStatus(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (TreatyStatus type : TreatyStatus.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

    /**
     * 方案活动协议 文件类型 类型（SIGN_签名照/PDF_文件/IMAGE_图片）
     */
    public enum SignFileType {
        SIGN("SIGN", "签名照"),
        PDF("PDF", "PDF文件"),
        IMAGE("IMAGE", "PDF图片"),
        ;
        private String val;
        private String desc;

        SignFileType(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (SignFileType type : SignFileType.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

}
