/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.util.mdm;

import com.biz.crm.eunm.mdm.LoginFromTypeEnum;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.ParamUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class LoginHelpUtil {
    private static final Logger log = LoggerFactory.getLogger(LoginHelpUtil.class);
    private static RedisService redisService;

    @Autowired
    public void setRedisService(RedisService redis) {
        redisService = redis;
    }

    public static long getLockMinutes(String userName2, String phone, String email) {
        if (StringUtils.isNotEmpty((CharSequence)userName2)) {
            return LoginHelpUtil.getLockMinutes("LOGIN_LOCK_USER_0319:", userName2);
        }
        if (StringUtils.isNotEmpty((CharSequence)phone)) {
            return LoginHelpUtil.getLockMinutes("LOGIN_LOCK_PHONE_0319:", phone);
        }
        if (StringUtils.isNotEmpty((CharSequence)email)) {
            return LoginHelpUtil.getLockMinutes("LOGIN_LOCK_EMAIL_0319:", email);
        }
        return 0L;
    }

    public static long addErrorAndGetTimes(String userName2, String phone, String email) {
        long maxErrorTimes;
        Assert.hasText((String)userName2, (String)"\u7f3a\u5931\u767b\u5f55\u8d26\u53f7");
        long lastTimes = maxErrorTimes = LoginHelpUtil.getMaxErrorTimes();
        if (StringUtils.isNotEmpty((CharSequence)userName2)) {
            Object lockObj = redisService.hget("LOGIN_LOCK_USER_0319:", userName2);
            if (lockObj != null) {
                lastTimes = 0L;
            } else {
                Object errorTimesObj = redisService.hget("LOGIN_LOCK_USER_ERROR_TIMES_0319:", userName2);
                if (maxErrorTimes == 1L) {
                    LoginHelpUtil.lock(userName2, phone, email);
                    lastTimes = 0L;
                } else {
                    int thisAfterAddTimes = 1;
                    if (errorTimesObj != null) {
                        thisAfterAddTimes += ((Integer)errorTimesObj).intValue();
                    }
                    if ((long)thisAfterAddTimes >= maxErrorTimes) {
                        LoginHelpUtil.lock(userName2, phone, email);
                        lastTimes = 0L;
                    } else {
                        LoginHelpUtil.setErrorTimes(userName2, phone, email, thisAfterAddTimes);
                        lastTimes = maxErrorTimes - (long)thisAfterAddTimes;
                    }
                }
            }
        }
        return lastTimes;
    }

    public static void unlock(String userName2, String phone, String email) {
        if (StringUtils.isNotEmpty((CharSequence)userName2)) {
            redisService.hdel("LOGIN_LOCK_USER_0319:", new Object[]{userName2});
            redisService.hdel("LOGIN_LOCK_USER_ERROR_TIMES_0319:", new Object[]{userName2});
        }
        if (StringUtils.isNotEmpty((CharSequence)phone)) {
            redisService.hdel("LOGIN_LOCK_PHONE_0319:", new Object[]{phone});
            redisService.hdel("LOGIN_LOCK_PHONE_ERROR_TIMES_0319:", new Object[]{phone});
        }
        if (StringUtils.isNotEmpty((CharSequence)email)) {
            redisService.hdel("LOGIN_LOCK_EMAIL_0319:", new Object[]{email});
            redisService.hdel("LOGIN_LOCK_EMAIL_ERROR_TIMES_0319:", new Object[]{email});
        }
    }

    public static long getMaxLockMinutes() {
        long maxLockSeconds = LoginHelpUtil.getMaxLockSeconds();
        BigDecimal divide = new BigDecimal(maxLockSeconds).divide(new BigDecimal(60), 0, 0);
        return divide.longValue();
    }

    public static String saveVerificationCodeRelUserAndPhone(String fromType, String userName2, String phone) {
        String verification = LoginHelpUtil.generateVerificationCode();
        redisService.hset("LOGIN_PHONE_VERIFICATION_0319:" + fromType + ":" + phone, verification, (Object)userName2, 300L);
        return verification;
    }

    public static void sendPhoneVerificationCode(String fromType, String phone, String verificationCode) {
        log.info("\u53d1\u9001\u624b\u673a\u53f7\u767b\u5f55\u9a8c\u8bc1\u7801\u6210\u529f\uff1a\u767b\u5f55\u7cfb\u7edf\uff1a{}\uff0c\u90ae\u7bb1\uff1a{}\uff0c\u9a8c\u8bc1\u7801\uff1a{}", new Object[]{LoginFromTypeEnum.getDesc((String)fromType), phone, verificationCode});
    }

    public static String getUserNameByPhoneAndVerificationCode(String fromType, String phone, String verificationCode) {
        Object hget = redisService.hget("LOGIN_PHONE_VERIFICATION_0319:" + fromType + ":" + phone, verificationCode);
        if (hget != null) {
            redisService.del(new String[]{"LOGIN_PHONE_VERIFICATION_0319:" + fromType + ":" + phone});
            return (String)hget;
        }
        return null;
    }

    public static String saveVerificationCodeRelUserAndEmail(String fromType, String userName2, String email) {
        String verification = LoginHelpUtil.generateVerificationCode();
        redisService.hset("LOGIN_EMAIL_VERIFICATION_0319:" + fromType + ":" + email, verification, (Object)userName2, 3600L);
        return verification;
    }

    public static void sendEmailVerificationCode(String fromType, String email, String verificationCode) {
        log.info("\u53d1\u9001\u90ae\u7bb1\u767b\u5f55\u9a8c\u8bc1\u7801\u6210\u529f\uff1a\u767b\u5f55\u7cfb\u7edf\uff1a{}\uff0c\u90ae\u7bb1\uff1a{}\uff0c\u9a8c\u8bc1\u7801\uff1a{}", new Object[]{LoginFromTypeEnum.getDesc((String)fromType), email, verificationCode});
    }

    public static String getUserNameByEmailVerificationCode(String fromType, String email, String verificationCode) {
        Object hget = redisService.hget("LOGIN_EMAIL_VERIFICATION_0319:" + fromType + ":" + email, verificationCode);
        if (hget != null) {
            redisService.del(new String[]{"LOGIN_EMAIL_VERIFICATION_0319:" + fromType + ":" + email});
            return (String)hget;
        }
        return null;
    }

    public static Set<String> checkAndGetLockUserName(Set<String> userNameSet) {
        Map hmget;
        HashSet<String> lockUserNameSet = new HashSet<String>(16);
        if (!userNameSet.isEmpty() && (hmget = redisService.hmget("LOGIN_LOCK_USER_0319:")) != null) {
            lockUserNameSet.addAll(hmget.keySet().stream().map(x -> (String)x).filter(userNameSet::contains).collect(Collectors.toSet()));
        }
        return lockUserNameSet;
    }

    public static boolean checkStartEndTime(String startDateTime, String endDateTime) {
        String now = DateUtil.dateNowHms();
        if (StringUtils.isNotEmpty((CharSequence)startDateTime) && now.compareTo(startDateTime) < 0) {
            return false;
        }
        return !StringUtils.isNotEmpty((CharSequence)endDateTime) || now.compareTo(endDateTime) <= 0;
    }

    private static void lock(String userName2, String phone, String email) {
        long lockSeconds = LoginHelpUtil.getMaxLockSeconds();
        long unlockDateTime = System.currentTimeMillis() + lockSeconds * 1000L;
        if (StringUtils.isNotEmpty((CharSequence)userName2)) {
            redisService.hset("LOGIN_LOCK_USER_0319:", userName2, (Object)unlockDateTime, lockSeconds);
            redisService.hdel("LOGIN_LOCK_USER_ERROR_TIMES_0319:", new Object[]{userName2});
        }
        if (StringUtils.isNotEmpty((CharSequence)phone)) {
            redisService.hset("LOGIN_LOCK_PHONE_0319:", phone, (Object)unlockDateTime, lockSeconds);
            redisService.hdel("LOGIN_LOCK_PHONE_ERROR_TIMES_0319:", new Object[]{phone});
        }
        if (StringUtils.isNotEmpty((CharSequence)email)) {
            redisService.hset("LOGIN_LOCK_EMAIL_0319:", email, (Object)unlockDateTime, lockSeconds);
            redisService.hdel("LOGIN_LOCK_EMAIL_ERROR_TIMES_0319:", new Object[]{email});
        }
    }

    private static void setErrorTimes(String userName2, String phone, String email, int times) {
        long errorResetSeconds = LoginHelpUtil.getErrorResetSeconds();
        if (StringUtils.isNotEmpty((CharSequence)userName2)) {
            redisService.hset("LOGIN_LOCK_USER_ERROR_TIMES_0319:", userName2, (Object)times, errorResetSeconds);
        }
        if (StringUtils.isNotEmpty((CharSequence)phone)) {
            redisService.hset("LOGIN_LOCK_PHONE_ERROR_TIMES_0319:", phone, (Object)times, errorResetSeconds);
        }
        if (StringUtils.isNotEmpty((CharSequence)email)) {
            redisService.hset("LOGIN_LOCK_EMAIL_ERROR_TIMES_0319:", email, (Object)times, errorResetSeconds);
        }
    }

    private static long getLockMinutes(String lockKey, String name) {
        Long unlockDateTimeLong;
        long l;
        Object obj;
        if (StringUtils.isNotEmpty((CharSequence)name) && (obj = redisService.hget(lockKey, name)) != null && (l = (unlockDateTimeLong = (Long)obj) - System.currentTimeMillis()) > 0L) {
            BigDecimal divide = new BigDecimal(l).divide(new BigDecimal(60000L), 0, 0);
            return divide.longValue();
        }
        return 0L;
    }

    private static long getErrorResetSeconds() {
        try {
            String parameterValue = ParamUtil.getParameterValueNoException("login_password_error_reset_minutes");
            if (StringUtils.isNotEmpty((CharSequence)parameterValue)) {
                return new BigDecimal(parameterValue).multiply(new BigDecimal("60")).setScale(0, RoundingMode.HALF_UP).longValue();
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5bc6\u7801\u9519\u8bef\u91cd\u7f6e\u65f6\u95f4\u5931\u8d25");
        }
        return 64800L;
    }

    private static long getMaxErrorTimes() {
        try {
            String parameterValue = ParamUtil.getParameterValueNoException("login_error_frequency");
            if (StringUtils.isNotEmpty((CharSequence)parameterValue)) {
                return Long.valueOf(parameterValue);
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u7528\u6237\u5bc6\u7801\u6700\u5927\u8f93\u5165\u9519\u8bef\u6b21\u6570\u5931\u8d25");
        }
        return 5L;
    }

    private static long getMaxLockSeconds() {
        try {
            String parameterValue = ParamUtil.getParameterValueNoException("login_lock_time");
            if (StringUtils.isNotEmpty((CharSequence)parameterValue)) {
                return new BigDecimal(parameterValue).multiply(new BigDecimal("60")).setScale(0, RoundingMode.HALF_UP).longValue();
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u7528\u6237\u6700\u5927\u9501\u5b9a\u65f6\u957f\u5931\u8d25");
        }
        return 900L;
    }

    private static String generateVerificationCode() {
        int length = 4;
        double random = Math.random();
        return String.format("%" + length + "d", new BigDecimal(random).multiply(new BigDecimal(Math.pow(10.0, length))).setScale(0, RoundingMode.HALF_UP).longValue());
    }
}

