/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.util;

import com.biz.crm.base.BusinessException;
import com.biz.crm.config.SpringApplicationContextUtil;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.mdm.feign.MdmCodeRuleGeneratorFeign;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.Result;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CodeUtil {
    private static RedisService redisService;
    private final long workerIdBits = 5L;
    private final long datacenterIdBits = 5L;
    private final long maxWorkerId = 31L;
    private final long maxDatacenterId = 31L;
    private final long sequenceBits = 10L;
    private final long timestampLeftShift = 10L;
    private final long sequenceMask = 1023L;
    private long workerId;
    private long datacenterId;
    private long sequence = 0L;
    private long lastTimestamp = -1L;
    private static CodeUtil idWorker;
    private final long TWEPOCH = 1596037883039L;
    private static MdmCodeRuleGeneratorFeign mdmCodeRuleGeneratorFeign;
    public static final String RULE_CODE = "RULE_CODE_";
    static final char[] DIGITS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getCode() {
        if (idWorker != null) return CodeUtil.to62RadixString(idWorker.nextId());
        Class<CodeUtil> clazz = CodeUtil.class;
        synchronized (CodeUtil.class) {
            if (idWorker != null) return CodeUtil.to62RadixString(idWorker.nextId());
            idWorker = new CodeUtil(0L, 0L);
            // ** MonitorExit[var0] (shouldn't be in output)
            return CodeUtil.to62RadixString(idWorker.nextId());
        }
    }

    private CodeUtil(long workerId, long datacenterId) {
        if (workerId > 31L || workerId < 0L) {
            throw new IllegalArgumentException(String.format("worker Id can't be greater than %d or less than 0", 31L));
        }
        if (datacenterId > 31L || datacenterId < 0L) {
            throw new IllegalArgumentException(String.format("datacenter Id can't be greater than %d or less than 0", 31L));
        }
        this.workerId = workerId;
        this.datacenterId = datacenterId;
    }

    protected long tilNextMillis(long lastTimestamp) {
        long timestamp = System.currentTimeMillis();
        while (timestamp <= lastTimestamp) {
            timestamp = System.currentTimeMillis();
        }
        return timestamp;
    }

    protected synchronized long nextId() {
        long timestamp = System.currentTimeMillis();
        if (timestamp < this.lastTimestamp) {
            throw new RuntimeException(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", this.lastTimestamp - timestamp));
        }
        if (this.lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & 0x3FFL;
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = timestamp;
        return timestamp - 1596037883039L << 10 | this.sequence;
    }

    private static String to62RadixString(long seq) {
        StringBuilder sb = new StringBuilder();
        do {
            int remainder = (int)(seq % 62L);
            sb.append(DIGITS[remainder]);
        } while ((seq /= 62L) != 0L);
        return sb.reverse().toString();
    }

    public static String fullThree(String parentCode, int rank) {
        String rankStr = "";
        rankStr = rank < 10 ? "00" + rank : (rank < 100 ? "0" + rank : "" + rank);
        if (parentCode == null || parentCode.equals("")) {
            return rankStr;
        }
        return new StringBuffer(parentCode).append(rankStr).toString();
    }

    public static String createCode() {
        return CodeUtil.getCode();
    }

    public static String createOneCode(String functionName) {
        return CodeUtil.generateCodeList(functionName, 1).get(0);
    }

    public static List<String> createCodeList(String functionName, int num) {
        return CodeUtil.generateCodeList(functionName, num);
    }

    public static void setMdmCodeRuleGeneratorFeign(MdmCodeRuleGeneratorFeign feign) {
        mdmCodeRuleGeneratorFeign = feign;
    }

    public static List<String> generateCodeList(int number) {
        ArrayList<String> list = new ArrayList<String>();
        if (number > 0) {
            Result result = mdmCodeRuleGeneratorFeign.generateCodeList(CodeRuleEnum.DEFAULT_CODE.getCode(), Integer.valueOf(number));
            if (!result.isSuccess()) {
                throw new BusinessException("\u751f\u6210\u9ed8\u8ba4\u7f16\u7801\u5931\u8d25\uff1a" + result.getMessage());
            }
            list.addAll((Collection)result.getResult());
        }
        return list;
    }

    public static List<String> generateCodeList(String ruleCode, int number) {
        ArrayList<String> list = new ArrayList<String>();
        if (ruleCode != null && !"".equals(ruleCode) && number > 0) {
            Result result = mdmCodeRuleGeneratorFeign.generateCodeList(ruleCode, Integer.valueOf(number));
            if (!result.isSuccess()) {
                throw new BusinessException(ruleCode + "\u751f\u6210\u7f16\u7801\u5931\u8d25\uff1a" + result.getMessage());
            }
            return (List)result.getResult();
        }
        return list;
    }

    public static String generateCode() {
        List<String> list = CodeUtil.generateCodeList(1);
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return "";
    }

    public static String generateCode(String ruleCode) {
        List<String> list = CodeUtil.generateCodeList(ruleCode, 1);
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return "";
    }

    public static String getCodeDefault() {
        if (redisService == null) {
            redisService = (RedisService)SpringApplicationContextUtil.getApplicationContext().getBean(RedisService.class);
        }
        String nodate = String.valueOf(System.currentTimeMillis());
        long numCode = redisService.incr(RULE_CODE, 1L);
        if (numCode == 999999L) {
            redisService.set(RULE_CODE, (Object)1);
            numCode = 1L;
        }
        return nodate + String.format("%06d", numCode);
    }

    static {
        DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    }
}

