/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.util;

import com.biz.crm.base.BusinessException;
import com.biz.crm.parameter.feign.ParameterFeign;
import com.biz.crm.parameter.vo.ParameterVo;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.Result;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ParamUtil {
    private static final Logger log = LoggerFactory.getLogger(ParamUtil.class);
    private static ParameterFeign parameterFeign;
    private static RedisService redisService;

    @Autowired
    public void setParameterFeign(ParameterFeign feign) {
        parameterFeign = feign;
    }

    @Autowired
    public void setRedisService(RedisService redis) {
        redisService = redis;
    }

    public static String getParameterValue(String parameterCode) {
        if (parameterCode == null || "".equals(parameterCode)) {
            throw new BusinessException("\u8bf7\u4f20\u5165\u5168\u5c40\u53c2\u6570\u7f16\u7801");
        }
        ParameterVo parameterVo = ParamUtil.getParameterVo(parameterCode);
        if (parameterVo == null) {
            throw new BusinessException("\u672a\u914d\u7f6e\u5168\u5c40\u53c2\u6570\uff1a" + parameterCode);
        }
        return parameterVo.getParameterValue();
    }

    public static String getParameterValueNoException(String parameterCode) {
        try {
            ParameterVo parameterVo;
            if (parameterCode != null && !"".equals(parameterCode) && (parameterVo = ParamUtil.getParameterVo(parameterCode)) != null) {
                return parameterVo.getParameterValue();
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5168\u5c40\u53c2\u6570\u5f02\u5e38\uff1a{}", (Object)parameterCode);
        }
        return null;
    }

    public static Map<String, String> getParameterValueMap(List<String> parameterCodeList) {
        Map<String, ParameterVo> parameterVoMap;
        HashMap<String, String> map = new HashMap<String, String>(16);
        if (parameterCodeList != null && parameterCodeList.size() > 0 && !(parameterVoMap = ParamUtil.basicMap(parameterCodeList)).isEmpty()) {
            for (Map.Entry<String, ParameterVo> entry : parameterVoMap.entrySet()) {
                map.put(entry.getKey(), entry.getValue().getParameterValue());
            }
        }
        return map;
    }

    public static ParameterVo getParameterVo(String parameterCode) {
        Map<String, ParameterVo> parameterVoMap;
        if (parameterCode != null && !"".equals(parameterCode) && !(parameterVoMap = ParamUtil.basicMap(Collections.singletonList(parameterCode))).isEmpty()) {
            return parameterVoMap.get(parameterCode);
        }
        return null;
    }

    public static Map<String, ParameterVo> getParameterVoMap(List<String> parameterCodeList) {
        if (parameterCodeList != null && parameterCodeList.size() > 0) {
            return ParamUtil.basicMap(parameterCodeList);
        }
        return new HashMap<String, ParameterVo>();
    }

    private static Map<String, ParameterVo> basicMap(List<String> parameterCodeList) {
        HashMap<String, ParameterVo> map = new HashMap<String, ParameterVo>(16);
        try {
            if (parameterCodeList != null && parameterCodeList.size() > 0) {
                List list;
                Result<List<ParameterVo>> result;
                List unlockCodeList = parameterCodeList.stream().filter(parameterCode -> !ParamUtil.checkLock(parameterCode)).collect(Collectors.toList());
                ArrayList<String> notCacheCodeList = new ArrayList<String>();
                for (String parameterCode2 : unlockCodeList) {
                    Object o = redisService.get("PARAMETER_:" + parameterCode2);
                    if (o == null) {
                        notCacheCodeList.add(parameterCode2);
                        continue;
                    }
                    map.put(parameterCode2, (ParameterVo)o);
                }
                if (notCacheCodeList.size() > 0 && (result = parameterFeign.getParameterRedisList(parameterCodeList)).isSuccess() && (list = (List)result.getResult()) != null && list.size() > 0) {
                    Map<String, ParameterVo> collect = list.stream().collect(Collectors.toMap(ParameterVo::getParameterCode, v -> v));
                    for (String parameterCode3 : notCacheCodeList) {
                        if (!collect.containsKey(parameterCode3)) {
                            ParamUtil.lock(parameterCode3);
                            continue;
                        }
                        ParamUtil.addRedisCache(collect.get(parameterCode3));
                        map.put(parameterCode3, collect.get(parameterCode3));
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("\u5168\u5c40\u53c2\u6570\u5de5\u5177\u7c7b\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
        return map;
    }

    private static List<ParameterVo> getParameterVoList(List<String> parameterCodeList) {
        List list;
        Result<List<ParameterVo>> result = parameterFeign.getParameterRedisList(parameterCodeList);
        if (result.isSuccess() && (list = (List)result.getResult()) != null && list.size() > 0) {
            return list;
        }
        return new ArrayList<ParameterVo>();
    }

    public static void deleteRedisCache(String parameterCode) {
        if (parameterCode != null && !"".equals(parameterCode)) {
            redisService.del(new String[]{"PARAMETER_:" + parameterCode});
            redisService.del(new String[]{"PARAMETER_LOCK_:" + parameterCode});
        }
    }

    private static void addRedisCache(ParameterVo parameterVo) {
        if (parameterVo != null) {
            redisService.set("PARAMETER_:" + parameterVo.getParameterCode(), (Object)parameterVo);
        }
    }

    private static void lock(String parameterCode) {
        if (parameterCode != null && !"".equals(parameterCode)) {
            redisService.setSeconds("PARAMETER_LOCK_:" + parameterCode, (Object)parameterCode, 5L);
        }
    }

    private static boolean checkLock(String parameterCode) {
        if (parameterCode != null && !"".equals(parameterCode)) {
            return redisService.get("PARAMETER_LOCK_:" + parameterCode) != null;
        }
        return false;
    }
}

