/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.util;

import com.alibaba.fastjson.JSON;
import java.beans.FeatureDescriptor;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;

public class CrmBeanUtil {
    private static final Logger log = LoggerFactory.getLogger(CrmBeanUtil.class);

    public static void copyProperties(Object source, Object target) {
        BeanUtils.copyProperties((Object)source, (Object)target);
    }

    public static void copyBeanProperties(Object source, Object target) {
        try {
            BeanUtils.copyProperties((Object)source, (Object)target);
        }
        catch (BeansException e) {
            log.error("\u62f7\u8d1d\u5bf9\u8c61\u5c5e\u6027\u5931\u8d25", (Object)e.getMessage());
        }
    }

    public static <T> T copy(Object source, Class<T> target) {
        if (source == null) {
            return null;
        }
        try {
            T newInstance = target.newInstance();
            BeanUtils.copyProperties((Object)source, newInstance);
            return newInstance;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T, K> List<K> copyList(List<T> source, Class<K> target) {
        if (null == source || source.isEmpty()) {
            return Collections.emptyList();
        }
        return source.stream().map(e -> CrmBeanUtil.copy(e, target)).collect(Collectors.toList());
    }

    public static void copyExt10(Object source, Object target) {
        if (source == null || target == null) {
            return;
        }
        HashSet<String> props = new HashSet<String>(16);
        for (int i = 1; i <= 10; ++i) {
            props.add("ext" + i);
        }
        String[] filteredPropertyNames = (String[])Arrays.stream(BeanUtils.getPropertyDescriptors(source.getClass())).map(FeatureDescriptor::getName).filter(item -> !props.contains(item)).toArray(String[]::new);
        if (filteredPropertyNames.length > 0) {
            BeanUtils.copyProperties((Object)source, (Object)target, (String[])filteredPropertyNames);
        }
    }

    public static void copyExt50(Object source, Object target) {
        if (source == null || target == null) {
            return;
        }
        HashSet<String> props = new HashSet<String>(64);
        for (int i = 1; i <= 50; ++i) {
            props.add("ext" + i);
        }
        String[] filteredPropertyNames = (String[])Arrays.stream(BeanUtils.getPropertyDescriptors(source.getClass())).map(FeatureDescriptor::getName).filter(item -> !props.contains(item)).toArray(String[]::new);
        if (filteredPropertyNames.length > 0) {
            BeanUtils.copyProperties((Object)source, (Object)target, (String[])filteredPropertyNames);
        }
    }

    public static <T> T copyByJson(Object obj, Class<T> tClass) {
        if (null == obj) {
            return null;
        }
        String jsonStr = JSON.toJSONString((Object)obj);
        return (T)JSON.parseObject((String)jsonStr, tClass);
    }
}

