/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.util;

import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.ParamUtil;
import com.biz.crm.util.StringUtils;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeRuleCodeUtil {
    private static final Logger log = LoggerFactory.getLogger(TreeRuleCodeUtil.class);

    public static String numToSingleCode(Integer num) {
        int length = TreeRuleCodeUtil.getRuleCodeSplitLength();
        return String.format("%0" + length + "d", num);
    }

    public static Set<String> splitParentRuleCodes(String ruleCode) {
        int length = TreeRuleCodeUtil.getRuleCodeSplitLength();
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        if (StringUtils.isNotEmpty((String)ruleCode)) {
            set.add(ruleCode);
            while (ruleCode.length() > length) {
                ruleCode = ruleCode.substring(0, ruleCode.length() - length);
                set.add(ruleCode);
            }
        }
        return set;
    }

    public static Set<String> splitParentRuleCodes(List<String> ruleCodeList) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (String ruleCode : ruleCodeList) {
            set.addAll(TreeRuleCodeUtil.splitParentRuleCodes(ruleCode));
        }
        return set;
    }

    public static Set<String> splitParentRuleCodesExcludeSelf(String ruleCode) {
        int length = TreeRuleCodeUtil.getRuleCodeSplitLength();
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        if (StringUtils.isNotEmpty((String)ruleCode)) {
            while (ruleCode.length() > length) {
                ruleCode = ruleCode.substring(0, ruleCode.length() - length);
                set.add(ruleCode);
            }
        }
        return set;
    }

    public static Set<String> splitParentRuleCodesExcludeSelf(List<String> ruleCodeList) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        if (CollectionUtil.listNotEmptyNotSizeZero(ruleCodeList)) {
            for (String ruleCode : ruleCodeList) {
                set.addAll(TreeRuleCodeUtil.splitParentRuleCodesExcludeSelf(ruleCode));
            }
        }
        return set;
    }

    public static Set<String> splitParentRuleCodesExcludeAnySelf(List<String> ruleCodeList) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        if (CollectionUtil.listNotEmptyNotSizeZero(ruleCodeList)) {
            HashSet<String> collect = new HashSet<String>(ruleCodeList);
            for (String ruleCode : collect) {
                set.addAll(TreeRuleCodeUtil.splitParentRuleCodesExcludeSelf(ruleCode));
            }
            return set.stream().filter(item -> !collect.contains(item)).collect(Collectors.toSet());
        }
        return set;
    }

    public static int getCurLevelCodeValue(String ruleCode) {
        int length = TreeRuleCodeUtil.getRuleCodeSplitLength();
        if (ruleCode != null && !"".equals(ruleCode) && ruleCode.length() >= length) {
            return Integer.valueOf(ruleCode.substring(ruleCode.length() - length));
        }
        return 0;
    }

    public static int getRuleCodeSplitLength() {
        int length = 3;
        try {
            String parameterValue = ParamUtil.getParameterValue("tree_reduction_rule_code_split_length");
            length = Integer.valueOf(parameterValue);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u964d\u7ef4\u7f16\u7801\u957f\u5ea6\u5931\u8d25\uff1a{}", (Throwable)e);
        }
        return length;
    }

    public static int getMaxRuleCodeValueInLevel() {
        int ruleCodeSplitLength = TreeRuleCodeUtil.getRuleCodeSplitLength();
        int max = 1;
        for (int i = 1; i <= ruleCodeSplitLength; ++i) {
            max *= 10;
        }
        return max - 1;
    }
}

