/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.util.cache.mdm;

import com.biz.crm.mdm.function.MdmFunctionFeign;
import com.biz.crm.nebular.mdm.function.MdmFunctionReqVo;
import com.biz.crm.nebular.mdm.function.MdmFunctionRespVo;
import com.biz.crm.service.RedisService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class FunctionUtil {
    private static RedisService redisService;
    private static MdmFunctionFeign mdmFunctionFeign;

    @Autowired
    public void setRedisService(RedisService redisService) {
        FunctionUtil.redisService = redisService;
    }

    @Autowired
    public void setMdmFunctionFeign(MdmFunctionFeign mdmFunctionFeign) {
        FunctionUtil.mdmFunctionFeign = mdmFunctionFeign;
    }

    public static List<MdmFunctionRespVo> findAllFunction() {
        ArrayList<MdmFunctionRespVo> result = new ArrayList<MdmFunctionRespVo>();
        List list = redisService.lGet("MDM_FUNCTION:", 0L, -1L);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (Object o : list) {
                result.add((MdmFunctionRespVo)o);
            }
            return result;
        }
        List dbList = (List)mdmFunctionFeign.list(new MdmFunctionReqVo()).getResult();
        if (CollectionUtils.isEmpty((Collection)dbList)) {
            return Collections.emptyList();
        }
        redisService.lSetAll("MDM_FUNCTION:", (Collection)dbList, 86400L);
        return dbList;
    }

    public static void clear() {
        redisService.del(new String[]{"MDM_FUNCTION:"});
    }
}

