/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.base;

import com.biz.crm.eunm.LanguageTypeEnum;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.util.MsgTranslateUtil;

public class BusinessException
extends RuntimeException {
    private Integer code;
    private String msg;

    public BusinessException() {
    }

    public BusinessException(String msg) {
        super(msg);
        this.msg = msg;
    }

    public BusinessException(String msg, String ... formats) {
        super(String.format(msg, formats));
        this.msg = String.format(msg, formats);
    }

    public BusinessException msg(String msg) {
        this.msg = msg;
        return this;
    }

    public BusinessException(Integer code, String msg) {
        super(new StringBuffer(code).append(":").append(msg).toString());
        this.msg = msg;
        this.code = code;
    }

    public BusinessException(String msg, Throwable t) {
        super(msg, t);
        this.msg = msg;
    }

    public BusinessException(CrmExceptionType exceptionType) {
        super(MsgTranslateUtil.convert(exceptionType.getCode(), exceptionType.getDescription(), LanguageTypeEnum.CHINA));
        this.msg = exceptionType.getDescription();
    }

    public BusinessException(Integer code, String msg, Throwable t) {
        super(new StringBuffer(code).append(":").append(msg).toString(), t);
        this.code = code;
        this.msg = msg;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    @Override
    public String toString() {
        return "BusinessException(code=" + this.getCode() + ", msg=" + this.getMsg() + ")";
    }
}

