/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.base;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.time.LocalDateTime;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.elasticsearch.annotations.DateFormat;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;

public class CrmBaseEntity<T>
extends BaseIdEntity
implements Serializable {
    private static final long serialVersionUID = -3517167521124118330L;
    @TableField(fill=FieldFill.INSERT, updateStrategy=FieldStrategy.NOT_EMPTY)
    @CrmColumn(name="del_flag", length=10, note="\u6570\u636e\u72b6\u6001\uff08\u5220\u9664\u72b6\u6001\uff09")
    private String delFlag;
    @TableField(fill=FieldFill.INSERT, updateStrategy=FieldStrategy.NOT_EMPTY)
    @CrmColumn(name="enable_status", length=10, note="\u6570\u636e\u4e1a\u52a1\u72b6\u6001\uff08\u542f\u7528\u72b6\u6001\uff09")
    private String enableStatus;
    @TableField(fill=FieldFill.INSERT, updateStrategy=FieldStrategy.NOT_EMPTY)
    @CrmColumn(name="create_date", length=20, note="\u521b\u5efa\u65f6\u95f4 yyyy-mm-dd")
    @Field(type=FieldType.Date, format=DateFormat.date)
    private String createDate;
    @TableField(fill=FieldFill.INSERT, updateStrategy=FieldStrategy.NOT_EMPTY)
    @CrmColumn(name="create_date_second", length=20, note="\u521b\u5efa\u65f6\u95f4 hh:mm:ss")
    @Field(type=FieldType.Date, format=DateFormat.hour_minute_second)
    private String createDateSecond;
    @TableField(fill=FieldFill.INSERT, updateStrategy=FieldStrategy.NOT_EMPTY)
    @CrmColumn(name="create_code", length=60, note="\u521b\u5efa\u4eba\u8d26\u53f7")
    private String createCode;
    @TableField(fill=FieldFill.INSERT, updateStrategy=FieldStrategy.NOT_EMPTY)
    @CrmColumn(name="create_name", length=128, note="\u521b\u5efa\u4eba\u540d\u79f0")
    private String createName;
    @TableField(fill=FieldFill.INSERT, updateStrategy=FieldStrategy.NOT_EMPTY)
    @CrmColumn(name="create_org_code", length=40, note="\u521b\u5efa\u4eba\u7ec4\u7ec7\u7f16\u7801")
    private String createOrgCode;
    @TableField(fill=FieldFill.INSERT, updateStrategy=FieldStrategy.NOT_EMPTY)
    @CrmColumn(name="create_org_name", length=128, note="\u521b\u5efa\u4eba\u7ec4\u7ec7\u540d\u79f0")
    private String createOrgName;
    @TableField(fill=FieldFill.INSERT, updateStrategy=FieldStrategy.NOT_EMPTY)
    @CrmColumn(name="create_pos_code", length=40, note="\u521b\u5efa\u4eba\u804c\u4f4dcode")
    private String createPosCode;
    @TableField(fill=FieldFill.INSERT, updateStrategy=FieldStrategy.NOT_EMPTY)
    @CrmColumn(name="create_pos_name", length=128, note="\u521b\u5efa\u4eba\u804c\u4f4d\u540d\u79f0")
    private String createPosName;
    @TableField(fill=FieldFill.UPDATE, updateStrategy=FieldStrategy.NOT_EMPTY)
    @CrmColumn(name="update_date", length=20, note="\u4fee\u6539\u65f6\u95f4 yyyy-mm-dd")
    @Field(type=FieldType.Date, format=DateFormat.date)
    private String updateDate;
    @TableField(fill=FieldFill.UPDATE, updateStrategy=FieldStrategy.NOT_EMPTY)
    @CrmColumn(name="update_date_second", length=20, note="\u66f4\u65b0\u65f6\u95f4 hh:mm:ss")
    @Field(type=FieldType.Date, format=DateFormat.hour_minute_second)
    private String updateDateSecond;
    @TableField(fill=FieldFill.UPDATE, updateStrategy=FieldStrategy.NOT_EMPTY)
    @CrmColumn(name="update_code", length=40, note="\u4fee\u6539\u4eba\u8d26\u53f7")
    private String updateCode;
    @TableField(fill=FieldFill.UPDATE, updateStrategy=FieldStrategy.NOT_EMPTY)
    @CrmColumn(name="update_name", length=128, note="\u4fee\u6539\u4eba\u540d\u79f0")
    private String updateName;
    @TableField(fill=FieldFill.UPDATE, updateStrategy=FieldStrategy.NOT_EMPTY)
    @CrmColumn(name="update_org_code", length=40, note="\u4fee\u6539\u4eba\u7ec4\u7ec7\u7f16\u7801")
    private String updateOrgCode;
    @TableField(fill=FieldFill.UPDATE, updateStrategy=FieldStrategy.NOT_EMPTY)
    @CrmColumn(name="update_org_name", length=128, note="\u4fee\u6539\u4eba\u7ec4\u7ec7\u540d\u79f0")
    private String updateOrgName;
    @TableField(fill=FieldFill.UPDATE, updateStrategy=FieldStrategy.NOT_EMPTY)
    @CrmColumn(name="update_pos_code", length=40, note="\u4fee\u6539\u4eba\u804c\u4f4dcode")
    private String updatePosCode;
    @TableField(fill=FieldFill.UPDATE, updateStrategy=FieldStrategy.NOT_EMPTY)
    @CrmColumn(name="update_pos_name", length=128, note="\u4fee\u6539\u4eba\u804c\u4f4d\u540d\u79f0")
    private String updatePosName;
    @CrmColumn(name="remarks", length=400, note="\u5907\u6ce8")
    private String remarks;
    @TableField(fill=FieldFill.UPDATE, updateStrategy=FieldStrategy.NOT_EMPTY)
    @CrmColumn(name="update_date_all", length=40, note="\u4fee\u6539\u65f6\u95f4\u5b8c\u6574")
    private String updateDateAll;
    @TableField(fill=FieldFill.INSERT, updateStrategy=FieldStrategy.NOT_EMPTY)
    @CrmColumn(name="create_date_all", length=40, note="\u521b\u5efa\u65f6\u95f4\u5b8c\u6574")
    private String createDateAll;

    @JsonIgnore
    public boolean isNormal() {
        return StringUtils.equals((CharSequence)CrmDelFlagEnum.NORMAL.getCode(), (CharSequence)this.delFlag);
    }

    public T delete() {
        this.delFlag = CrmDelFlagEnum.DELETE.getCode();
        return (T)this;
    }

    public T normal() {
        this.delFlag = CrmDelFlagEnum.NORMAL.getCode();
        return (T)this;
    }

    public T enable() {
        this.enableStatus = CrmEnableStatusEnum.ENABLE.getCode();
        return (T)this;
    }

    public T disable() {
        this.enableStatus = CrmEnableStatusEnum.DISABLE.getCode();
        return (T)this;
    }

    public static void buildDefEntityData(CrmBaseEntity entity) {
        UserRedis userRedis = UserUtils.getUser();
        entity.setCreateCode(userRedis.getUsername());
        entity.setCreateName(userRedis.getRealname());
        LocalDateTime now = LocalDateTime.now();
        entity.setCreateDate(now.format(CrmDateUtils.yyyyMMdd));
        entity.setCreateDateSecond(now.format(CrmDateUtils.HHmmss));
        entity.setCreateDateAll(now.format(CrmDateUtils.yyyyMMddHHmmss));
        entity.setCreateOrgCode(userRedis.getOrgcode());
        entity.setCreateOrgName(userRedis.getOrgname());
        entity.setCreatePosCode(userRedis.getPoscode());
        entity.setCreatePosName(userRedis.getPosname());
    }

    public String getDelFlag() {
        return this.delFlag;
    }

    public String getEnableStatus() {
        return this.enableStatus;
    }

    public String getCreateDate() {
        return this.createDate;
    }

    public String getCreateDateSecond() {
        return this.createDateSecond;
    }

    public String getCreateCode() {
        return this.createCode;
    }

    public String getCreateName() {
        return this.createName;
    }

    public String getCreateOrgCode() {
        return this.createOrgCode;
    }

    public String getCreateOrgName() {
        return this.createOrgName;
    }

    public String getCreatePosCode() {
        return this.createPosCode;
    }

    public String getCreatePosName() {
        return this.createPosName;
    }

    public String getUpdateDate() {
        return this.updateDate;
    }

    public String getUpdateDateSecond() {
        return this.updateDateSecond;
    }

    public String getUpdateCode() {
        return this.updateCode;
    }

    public String getUpdateName() {
        return this.updateName;
    }

    public String getUpdateOrgCode() {
        return this.updateOrgCode;
    }

    public String getUpdateOrgName() {
        return this.updateOrgName;
    }

    public String getUpdatePosCode() {
        return this.updatePosCode;
    }

    public String getUpdatePosName() {
        return this.updatePosName;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public String getUpdateDateAll() {
        return this.updateDateAll;
    }

    public String getCreateDateAll() {
        return this.createDateAll;
    }

    public void setDelFlag(String delFlag) {
        this.delFlag = delFlag;
    }

    public void setEnableStatus(String enableStatus) {
        this.enableStatus = enableStatus;
    }

    public void setCreateDate(String createDate) {
        this.createDate = createDate;
    }

    public void setCreateDateSecond(String createDateSecond) {
        this.createDateSecond = createDateSecond;
    }

    public void setCreateCode(String createCode) {
        this.createCode = createCode;
    }

    public void setCreateName(String createName) {
        this.createName = createName;
    }

    public void setCreateOrgCode(String createOrgCode) {
        this.createOrgCode = createOrgCode;
    }

    public void setCreateOrgName(String createOrgName) {
        this.createOrgName = createOrgName;
    }

    public void setCreatePosCode(String createPosCode) {
        this.createPosCode = createPosCode;
    }

    public void setCreatePosName(String createPosName) {
        this.createPosName = createPosName;
    }

    public void setUpdateDate(String updateDate) {
        this.updateDate = updateDate;
    }

    public void setUpdateDateSecond(String updateDateSecond) {
        this.updateDateSecond = updateDateSecond;
    }

    public void setUpdateCode(String updateCode) {
        this.updateCode = updateCode;
    }

    public void setUpdateName(String updateName) {
        this.updateName = updateName;
    }

    public void setUpdateOrgCode(String updateOrgCode) {
        this.updateOrgCode = updateOrgCode;
    }

    public void setUpdateOrgName(String updateOrgName) {
        this.updateOrgName = updateOrgName;
    }

    public void setUpdatePosCode(String updatePosCode) {
        this.updatePosCode = updatePosCode;
    }

    public void setUpdatePosName(String updatePosName) {
        this.updatePosName = updatePosName;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public void setUpdateDateAll(String updateDateAll) {
        this.updateDateAll = updateDateAll;
    }

    public void setCreateDateAll(String createDateAll) {
        this.createDateAll = createDateAll;
    }

    @Override
    public String toString() {
        return "CrmBaseEntity(delFlag=" + this.getDelFlag() + ", enableStatus=" + this.getEnableStatus() + ", createDate=" + this.getCreateDate() + ", createDateSecond=" + this.getCreateDateSecond() + ", createCode=" + this.getCreateCode() + ", createName=" + this.getCreateName() + ", createOrgCode=" + this.getCreateOrgCode() + ", createOrgName=" + this.getCreateOrgName() + ", createPosCode=" + this.getCreatePosCode() + ", createPosName=" + this.getCreatePosName() + ", updateDate=" + this.getUpdateDate() + ", updateDateSecond=" + this.getUpdateDateSecond() + ", updateCode=" + this.getUpdateCode() + ", updateName=" + this.getUpdateName() + ", updateOrgCode=" + this.getUpdateOrgCode() + ", updateOrgName=" + this.getUpdateOrgName() + ", updatePosCode=" + this.getUpdatePosCode() + ", updatePosName=" + this.getUpdatePosName() + ", remarks=" + this.getRemarks() + ", updateDateAll=" + this.getUpdateDateAll() + ", createDateAll=" + this.getCreateDateAll() + ")";
    }
}

