/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.util;

import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.config.SpringApplicationContextUtil;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.mdm.AdminEnum;
import com.biz.crm.eunm.mdm.MdmPermissionObjEnum;
import com.biz.crm.mdm.org.MdmOrgFeign;
import com.biz.crm.mdm.permission.MdmDataPermissionFeign;
import com.biz.crm.mdm.role.MdmRoleFeign;
import com.biz.crm.nebular.mdm.org.req.MdmOrgReqVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.permission.MdmCurrentPermissionRespVo;
import com.biz.crm.nebular.mdm.permission.MdmCurrentUserPermissionRespVo;
import com.biz.crm.nebular.mdm.permission.MdmPermissionSetVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.OrgUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class PermissionUtil {
    private static final Logger log = LoggerFactory.getLogger(PermissionUtil.class);
    private static MdmDataPermissionFeign mdmDataPermissionFeign;
    private static MdmRoleFeign mdmRoleFeign;
    private static MdmOrgFeign mdmOrgFeign;

    public static List<MdmPermissionSetVo> currentUserPermissionSql() {
        if (mdmDataPermissionFeign == null) {
            mdmDataPermissionFeign = (MdmDataPermissionFeign)SpringApplicationContextUtil.getApplicationContext().getBean(MdmDataPermissionFeign.class);
        }
        return Optional.ofNullable(mdmDataPermissionFeign.currentUserPermissionSql()).map(Result::getResult).orElse(Collections.emptyList());
    }

    public static MdmCurrentPermissionRespVo currentUserPermissionList() {
        if (mdmDataPermissionFeign == null) {
            mdmDataPermissionFeign = (MdmDataPermissionFeign)SpringApplicationContextUtil.getApplicationContext().getBean(MdmDataPermissionFeign.class);
        }
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        Object functionCodeObj = ThreadLocalUtil.getObj((String)"functionCode");
        String menuCode = Objects.nonNull(menuCodeObj) ? menuCodeObj.toString() : null;
        String functionCode = Objects.nonNull(functionCodeObj) ? functionCodeObj.toString() : null;
        log.info("[\u6743\u9650\u5de5\u5177\u7c7b]\u83dc\u5355\u7f16\u7801:{}", (Object)menuCode);
        log.info("[\u6743\u9650\u5de5\u5177\u7c7b]\u529f\u80fd\u7f16\u7801:{}", (Object)functionCode);
        if (StringUtils.isEmpty((String)menuCode) || StringUtils.isEmpty((String)functionCode)) {
            return new MdmCurrentPermissionRespVo();
        }
        return Optional.ofNullable(mdmDataPermissionFeign.currentUserDataPermission(menuCode, functionCode)).map(Result::getResult).orElse(new MdmCurrentPermissionRespVo());
    }

    public static boolean valAdmin() {
        if (mdmRoleFeign == null) {
            mdmRoleFeign = (MdmRoleFeign)SpringApplicationContextUtil.getApplicationContext().getBean(MdmRoleFeign.class);
        }
        UserRedis user = UserUtils.getUser();
        Assert.notNull((Object)user, (String)"\u5f53\u524d\u7528\u6237\u4e0d\u5b58\u5728");
        log.info("[\u6570\u636e\u6743\u9650]\u83b7\u53d6\u5f53\u524d\u7528\u6237\u6743\u9650,\u7528\u6237\u4fe1\u606f:{}", (Object)user);
        String username = user.getUsername();
        Assert.hasText((String)username, (String)"\u7528\u6237\u5e10\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        String positionCode = user.getPoscode();
        Assert.hasText((String)positionCode, (String)"\u7528\u6237\u6ca1\u6709\u5f53\u524d\u804c\u4f4d\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        List roleCodeList = (List)ApiResultUtil.objResult((Result)mdmRoleFeign.getRoleByPositionCode(positionCode), (boolean)true);
        Assert.notEmpty((Collection)roleCodeList, (String)("\u5f53\u524d\u804c\u4f4d[" + positionCode + "]\u672a\u5206\u914d\u89d2\u8272"));
        return AdminEnum.ADMIN.name().equalsIgnoreCase(username) || roleCodeList.stream().anyMatch(x -> AdminEnum.ADMIN.name().equalsIgnoreCase((String)x));
    }

    public static List<String> getOrgCodes() {
        String orgCode;
        MdmOrgRespVo topParentOrgByCode;
        List<String> orgCodeList;
        ArrayList<String> orgPermissionList = new ArrayList<String>();
        MdmCurrentPermissionRespVo mdmCurrentPermissionRespVo = PermissionUtil.currentUserPermissionList();
        if (Objects.nonNull(mdmCurrentPermissionRespVo)) {
            List userPermissionList;
            List permissionObjCodeList = mdmCurrentPermissionRespVo.getPermissionObjCodeList();
            if (!CollectionUtils.isEmpty((Collection)permissionObjCodeList) && permissionObjCodeList.contains(MdmPermissionObjEnum.ORG.getCode()) && !CollectionUtils.isEmpty((Collection)(userPermissionList = mdmCurrentPermissionRespVo.getUserPermissionList()))) {
                orgCodeList = userPermissionList.stream().filter(x -> MdmPermissionObjEnum.ORG.getCode().equals(x.getPermissionObjCode())).filter(x -> !CollectionUtils.isEmpty((Collection)x.getPermissionValueList())).flatMap(x -> x.getPermissionValueList().stream()).collect(Collectors.toList());
                orgPermissionList.addAll(orgCodeList);
            }
            if (!CollectionUtils.isEmpty((Collection)permissionObjCodeList) && permissionObjCodeList.contains(MdmPermissionObjEnum.COMPANY.getCode())) {
                userPermissionList = mdmCurrentPermissionRespVo.getUserPermissionList();
                orgCodeList = PermissionUtil.companyDownList(userPermissionList);
                orgCodeList.removeAll(orgPermissionList);
                orgPermissionList.addAll(orgCodeList);
            }
        }
        if (CollectionUtil.listEmpty(orgPermissionList) && Objects.nonNull(topParentOrgByCode = OrgUtil.getTopParentOrgByCode(orgCode = UserUtils.getUser().getOrgcode())) && StringUtils.isNotEmpty((String)topParentOrgByCode.getOrgCode())) {
            orgCodeList = PermissionUtil.allCompanyList((List<String>)new ArrayList<String>(){
                {
                    this.add(topParentOrgByCode.getOrgCode());
                }
            });
            orgPermissionList.addAll(orgCodeList);
        }
        return orgPermissionList;
    }

    public static List<String> companyDownList(List<MdmCurrentUserPermissionRespVo> userPermissionList) {
        if (!CollectionUtils.isEmpty(userPermissionList)) {
            List<String> companyCodeList = userPermissionList.stream().filter(x -> MdmPermissionObjEnum.COMPANY.getCode().equals(x.getPermissionObjCode())).filter(x -> !CollectionUtils.isEmpty((Collection)x.getPermissionValueList())).flatMap(x -> x.getPermissionValueList().stream()).collect(Collectors.toList());
            if (CollectionUtil.listEmpty(companyCodeList)) {
                return Collections.emptyList();
            }
            return PermissionUtil.allCompanyList(companyCodeList);
        }
        return Collections.emptyList();
    }

    public static List<String> allCompanyList(List<String> companyCodeList) {
        if (mdmOrgFeign == null) {
            mdmOrgFeign = (MdmOrgFeign)SpringApplicationContextUtil.getApplicationContext().getBean(MdmOrgFeign.class);
        }
        ArrayList<String> orgCodeList = new ArrayList<String>();
        companyCodeList.forEach(code -> {
            MdmOrgReqVo reqVo = new MdmOrgReqVo();
            reqVo.setOrgCode(code);
            List childrenOrgList = (List)ApiResultUtil.objResult((Result)mdmOrgFeign.findAllChildrenOrgList(reqVo), (boolean)true);
            List collect = childrenOrgList.stream().filter(vo -> !CrmDelFlagEnum.DELETE.getCode().equals(vo.getDelFlag()) && !CrmEnableStatusEnum.DISABLE.getCode().equals(vo.getEnableStatus())).map(MdmOrgRespVo::getOrgCode).distinct().collect(Collectors.toList());
            orgCodeList.addAll(collect);
        });
        return orgCodeList;
    }
}

