/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.util.fee;

import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.fee.FeePoolOperationTypeExtendEnum;
import com.biz.crm.eunm.fee.FeePoolOperationTypeGroupEnum;
import com.biz.crm.eunm.fee.FeePoolTypeEnum;
import com.biz.crm.nebular.fee.pool.resp.FeeSelectOptionVo;
import com.biz.crm.nebular.mdm.dict.resp.DictDataVo;
import com.biz.crm.util.DictUtil;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.util.Assert;

public class FeePoolConfigUtil {
    public static List<FeeSelectOptionVo> getDiscountSelectList() {
        return DictUtil.list("fee_pool_discount_type").stream().map(item -> {
            FeeSelectOptionVo option = new FeeSelectOptionVo();
            option.setValue(item.getDictCode());
            option.setText(item.getDictValue());
            return option;
        }).collect(Collectors.toList());
    }

    public static List<String> getOperationTypeList() {
        return DictUtil.list("fee_pool_operation_type").stream().map(DictDataVo::getDictCode).collect(Collectors.toList());
    }

    public static List<String> getOperationTypeList(FeePoolOperationTypeExtendEnum extendEnum) {
        return DictUtil.list("fee_pool_operation_type").stream().filter(item -> extendEnum == null || YesNoEnum.yesNoEnum.ONE.getValue().equals(item.getExtendMap().get(extendEnum.getValue()))).map(DictDataVo::getDictCode).collect(Collectors.toList());
    }

    public static List<String> getOperationTypeList(FeePoolOperationTypeGroupEnum groupEnum) {
        return DictUtil.list("fee_pool_operation_type").stream().filter(item -> groupEnum == null || groupEnum.getValue().equals(item.getExtendMap().get(FeePoolOperationTypeExtendEnum.GROUP.getValue()))).map(DictDataVo::getDictCode).collect(Collectors.toList());
    }

    public static List<FeeSelectOptionVo> getOperationTypeSelectList(String filterExtend) {
        return DictUtil.list("fee_pool_operation_type").stream().filter(item -> YesNoEnum.yesNoEnum.ONE.getValue().equals(item.getExtendMap().get(filterExtend))).map(item -> {
            FeeSelectOptionVo option = new FeeSelectOptionVo();
            option.setValue(item.getDictCode());
            option.setText(item.getDictValue());
            return option;
        }).collect(Collectors.toList());
    }

    public static List<FeeSelectOptionVo> getOperationTypeSelectList(FeePoolOperationTypeExtendEnum extendEnum) {
        return DictUtil.list("fee_pool_operation_type").stream().filter(item -> extendEnum == null || YesNoEnum.yesNoEnum.ONE.getValue().equals(item.getExtendMap().get(extendEnum.getValue()))).map(item -> {
            FeeSelectOptionVo option = new FeeSelectOptionVo();
            option.setValue(item.getDictCode());
            option.setText(item.getDictValue());
            return option;
        }).collect(Collectors.toList());
    }

    public static List<FeeSelectOptionVo> getPayTypeSelectList() {
        Map<String, String> payTypeMap = DictUtil.dictMap("fee_pool_pay_type");
        return DictUtil.list("fee_pool_type").stream().map(item -> {
            String payType = (String)item.getExtendMap().get("payType");
            Assert.hasText((String)payType, (String)(item.getDictValue() + "\u672a\u914d\u7f6e\u652f\u4ed8\u65b9\u5f0f"));
            String payTypeValue = (String)payTypeMap.get(payType);
            Assert.hasText((String)payTypeValue, (String)(item.getDictValue() + "\u914d\u7f6e\u7684\u652f\u4ed8\u65b9\u5f0f\u4e0d\u5b58\u5728"));
            FeeSelectOptionVo option = new FeeSelectOptionVo();
            option.setValue(payType);
            option.setText(payTypeValue);
            option.setPoolType(item.getDictCode());
            return option;
        }).collect(Collectors.toList());
    }

    public static boolean checkOperationTypeUsable(String operationType, FeePoolOperationTypeExtendEnum feePoolOperationTypeExtendEnum) {
        String operationTypeValue = DictUtil.dictValue("fee_pool_operation_type", operationType);
        Assert.hasText((String)operationTypeValue, (String)"\u65e0\u6548\u7684\u64cd\u4f5c\u7c7b\u578b");
        Map<String, String> extendMap = DictUtil.getExtendMap("fee_pool_operation_type", operationType);
        Assert.isTrue((boolean)extendMap.containsKey(feePoolOperationTypeExtendEnum.getValue()), (String)("\u64cd\u4f5c\u7c7b\u578b" + operationTypeValue + "\u672a\u914d\u7f6e" + feePoolOperationTypeExtendEnum.getDesc()));
        return YesNoEnum.yesNoEnum.ONE.getValue().equals(extendMap.get(feePoolOperationTypeExtendEnum.getValue()));
    }

    public static boolean checkOperationTypeGroup(String operationType, FeePoolOperationTypeGroupEnum groupEnum) {
        String operationTypeValue = DictUtil.dictValue("fee_pool_operation_type", operationType);
        Assert.hasText((String)operationTypeValue, (String)"\u65e0\u6548\u7684\u64cd\u4f5c\u7c7b\u578b");
        Map<String, String> extendMap = DictUtil.getExtendMap("fee_pool_operation_type", operationType);
        Assert.isTrue((boolean)extendMap.containsKey(FeePoolOperationTypeExtendEnum.GROUP.getValue()), (String)("\u64cd\u4f5c\u7c7b\u578b" + operationTypeValue + "\u672a\u914d\u7f6e" + FeePoolOperationTypeExtendEnum.GROUP.getDesc()));
        return groupEnum.getValue().equals(extendMap.get(FeePoolOperationTypeExtendEnum.GROUP.getValue()));
    }

    public static String getPayType(String poolType) {
        String poolTypeValue = DictUtil.dictValue("fee_pool_type", poolType);
        Assert.hasText((String)poolTypeValue, (String)"\u65e0\u6548\u7684\u8d39\u7528\u6c60\u7c7b\u578b");
        Map<String, String> discountExtendMap = DictUtil.getExtendMap("fee_pool_type", poolType);
        String payType = discountExtendMap.get("payType");
        Assert.hasText((String)payType, (String)(poolTypeValue + "\u672a\u914d\u7f6e\u652f\u4ed8\u65b9\u5f0f"));
        return payType;
    }

    public static FeePoolOperationTypeGroupEnum getOperationTypeGroup(String operationType) {
        String operationTypeValue = DictUtil.dictValue("fee_pool_operation_type", operationType);
        Assert.hasText((String)operationTypeValue, (String)"\u65e0\u6548\u7684\u64cd\u4f5c\u7c7b\u578b");
        Map<String, String> extendMap = DictUtil.getExtendMap("fee_pool_operation_type", operationType);
        String group = extendMap.get(FeePoolOperationTypeExtendEnum.GROUP.getValue());
        Assert.hasText((String)group, (String)("\u64cd\u4f5c\u7c7b\u578b" + operationTypeValue + "\u672a\u914d\u7f6e" + FeePoolOperationTypeExtendEnum.GROUP.getDesc()));
        FeePoolOperationTypeGroupEnum anEnum = FeePoolOperationTypeGroupEnum.getEnum((String)group);
        Assert.notNull((Object)anEnum, (String)("\u64cd\u4f5c\u7c7b\u578b" + operationTypeValue + "\u914d\u7f6e\u5206\u7ec4\u65e0\u6548"));
        return anEnum;
    }

    public static FeePoolTypeEnum getPoolTypeByPayType(String payType) {
        String payTypeValue = DictUtil.dictValue("fee_pool_pay_type", payType);
        Assert.hasText((String)payTypeValue, (String)"\u65e0\u6548\u7684\u652f\u4ed8\u65b9\u5f0f");
        List<DictDataVo> list = DictUtil.list("fee_pool_type");
        Assert.notEmpty(list, (String)"\u8d39\u7528\u6c60\u7c7b\u578b\u6570\u636e\u5b57\u5178\u914d\u7f6e\u6709\u8bef");
        List collect = list.stream().filter(item -> payType.equals(item.getExtendMap().get("payType"))).collect(Collectors.toList());
        Assert.notEmpty(collect, (String)("\u672a\u627e\u5230\u652f\u4ed8\u65b9\u5f0f" + payTypeValue + "\u5bf9\u5e94\u7684\u8d39\u7528\u6c60\u7c7b\u578b"));
        Assert.isTrue((collect.size() == 1 ? 1 : 0) != 0, (String)("\u652f\u4ed8\u65b9\u5f0f" + payTypeValue + "\u5173\u8054\u4e86\u591a\u4e2a\u8d39\u7528\u6c60\u7c7b\u578b"));
        String dictCode = ((DictDataVo)collect.get(0)).getDictCode();
        FeePoolTypeEnum poolTypeEnum = FeePoolTypeEnum.getEnum((String)dictCode);
        Assert.notNull((Object)poolTypeEnum, (String)"\u8d39\u7528\u6c60\u7c7b\u578b\u6570\u636e\u5b57\u5178\u6709\u8bef");
        return poolTypeEnum;
    }
}

