/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.util;

import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.mdm.ApprovalType;
import com.biz.crm.eunm.mdm.MdmApprovalConfig;
import com.biz.crm.eunm.mdm.MdmBpmStatusEnum;
import com.biz.crm.mdm.approval.MdmApprovalConfigFeign;
import com.biz.crm.mdm.role.MdmRoleFeign;
import com.biz.crm.nebular.mdm.approval.resp.MdmApprovalConfigConditionRedisVo;
import com.biz.crm.nebular.mdm.approval.resp.MdmApprovalConfigRedisVo;
import com.biz.crm.nebular.mdm.approval.resp.MdmApprovalConfigSubmitterRedisVo;
import com.biz.crm.nebular.mdm.approval.resp.MdmApprovalConfigVo;
import com.biz.crm.nebular.mdm.constant.UserTypeEnum;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.OrgUtil;
import com.biz.crm.util.PositionUtil;
import com.biz.crm.util.ReflectUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class ApprovalConfigUtil {
    private static final Logger log = LoggerFactory.getLogger(ApprovalConfigUtil.class);
    private static RedisService redisService;
    private static MdmApprovalConfigFeign mdmApprovalConfigFeign;
    private static MdmRoleFeign mdmRoleFeign;

    @Autowired
    public void setRedisService(RedisService redis) {
        redisService = redis;
    }

    @Autowired
    public void setMdmApprovalConfigFeign(MdmApprovalConfigFeign approvalConfigFeign) {
        mdmApprovalConfigFeign = approvalConfigFeign;
    }

    @Autowired
    public void setMdmRoleFeign(MdmRoleFeign mdmRoleFeign) {
        ApprovalConfigUtil.mdmRoleFeign = mdmRoleFeign;
    }

    public static MdmApprovalConfigVo getConfig(String businessCode) {
        return ApprovalConfigUtil.getConfig(businessCode, false);
    }

    public static MdmApprovalConfigVo getConfig(String businessCode, boolean notNull) {
        Assert.hasText((String)businessCode, (String)"\u7f3a\u5931\u4e1a\u52a1\u7f16\u7801");
        if (!StringUtils.isEmpty((CharSequence)businessCode)) {
            MdmApprovalConfigRedisVo redisVo = ApprovalConfigUtil.get(businessCode);
            if (notNull) {
                Assert.notNull((Object)redisVo, (String)"\u672a\u627e\u5230\u914d\u7f6e");
            }
            return CrmBeanUtil.copy(redisVo, MdmApprovalConfigVo.class);
        }
        return null;
    }

    public static ApprovalType checkAndGet(String businessCode, Object paramObj) {
        MdmApprovalConfigRedisVo redisVo = ApprovalConfigUtil.get(businessCode);
        if (redisVo == null || YesNoEnum.yesNoEnum.ZERO.getValue().equals(redisVo.getControlFlag())) {
            return ApprovalType.NULL;
        }
        String businessName = redisVo.getBusinessName();
        Assert.hasText((String)redisVo.getApprovalType(), (String)("\u5ba1\u6279\u914d\u7f6e\u3010" + businessName + "\u3011\u4e0d\u5b8c\u6574\uff0c\u7f3a\u5931\u5ba1\u6279\u7c7b\u578b"));
        Assert.hasText((String)redisVo.getControlScope(), (String)("\u5ba1\u6279\u914d\u7f6e\u3010" + businessName + "\u3011\u4e0d\u5b8c\u6574\uff0c\u7f3a\u5931\u63a7\u5236\u8303\u56f4"));
        if (MdmApprovalConfig.ControlScope.ALL_IN.getValue().equals(redisVo.getControlScope())) {
            return ApprovalType.getEnum((String)redisVo.getApprovalType());
        }
        if (MdmApprovalConfig.ControlScope.ALL_OUT.getValue().equals(redisVo.getControlScope())) {
            return ApprovalType.NULL;
        }
        Assert.hasText((String)redisVo.getGroupCheckWay(), (String)("\u5ba1\u6279\u914d\u7f6e\u3010" + businessName + "\u3011\u4e0d\u5b8c\u6574\uff0c\u7f3a\u5931\u6761\u4ef6\u7ec4\u5224\u65ad\u903b\u8f91"));
        Assert.hasText((String)redisVo.getConditionCheckWay(), (String)("\u5ba1\u6279\u914d\u7f6e\u3010" + businessName + "\u3011\u4e0d\u5b8c\u6574\uff0c\u7f3a\u5931\u4e1a\u52a1\u6570\u636e\u6761\u4ef6\u5224\u65ad\u903b\u8f91"));
        Assert.hasText((String)redisVo.getSubmitterCheckWay(), (String)("\u5ba1\u6279\u914d\u7f6e\u3010" + businessName + "\u3011\u4e0d\u5b8c\u6574\uff0c\u7f3a\u5931\u63d0\u4ea4\u4eba\u6761\u4ef6\u5224\u65ad\u903b\u8f91"));
        boolean conditionGroupCheck = true;
        HashSet<Boolean> conditionCheckSet = new HashSet<Boolean>(16);
        boolean submitterGroupCheck = true;
        HashSet<Boolean> submitterCheckSet = new HashSet<Boolean>(16);
        if (CollectionUtil.listNotEmptyNotSizeZero(redisVo.getConditionList())) {
            for (MdmApprovalConfigConditionRedisVo condition : redisVo.getConditionList()) {
                if (!YesNoEnum.yesNoEnum.ONE.getValue().equals(condition.getControlFlag())) continue;
                String fieldCode = condition.getFieldCode();
                if (!ReflectUtil.checkFieldExist(paramObj, fieldCode)) {
                    throw new BusinessException("\u53c2\u6570\u672a\u627e\u5230\u5b57\u6bb5" + condition.getFieldName() + "[" + condition.getFieldCode() + "]");
                }
                Object filedValueObj = ReflectUtil.getFiledValueByName(paramObj, fieldCode);
                boolean b = ApprovalConfigUtil.checkCondition(filedValueObj == null ? "" : filedValueObj.toString(), condition);
                conditionCheckSet.add(b);
                if ((!b || !MdmApprovalConfig.ConditionCheckWay.OR.getValue().equals(redisVo.getConditionCheckWay())) && (b || !MdmApprovalConfig.ConditionCheckWay.AND.getValue().equals(redisVo.getConditionCheckWay()))) continue;
                break;
            }
            if (MdmApprovalConfig.ConditionCheckWay.OR.getValue().equals(redisVo.getConditionCheckWay())) {
                conditionGroupCheck = conditionCheckSet.contains(true);
            } else if (MdmApprovalConfig.ConditionCheckWay.AND.getValue().equals(redisVo.getConditionCheckWay())) {
                boolean bl = conditionGroupCheck = !conditionCheckSet.contains(false);
            }
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(redisVo.getSubmitterList())) {
            UserRedis user = UserUtils.getUser();
            if (user == null || StringUtils.isEmpty((CharSequence)user.getUsername())) {
                throw new BusinessException("\u8bf7\u5148\u767b\u5f55");
            }
            for (MdmApprovalConfigSubmitterRedisVo submitter : redisVo.getSubmitterList()) {
                if (!YesNoEnum.yesNoEnum.ONE.getValue().equals(submitter.getControlFlag())) continue;
                boolean b = ApprovalConfigUtil.checkSubmitter(user, submitter);
                submitterCheckSet.add(b);
                if ((!b || !MdmApprovalConfig.ConditionCheckWay.OR.getValue().equals(redisVo.getSubmitterCheckWay())) && (b || !MdmApprovalConfig.ConditionCheckWay.AND.getValue().equals(redisVo.getSubmitterCheckWay()))) continue;
                break;
            }
            if (MdmApprovalConfig.ConditionCheckWay.OR.getValue().equals(redisVo.getSubmitterCheckWay())) {
                submitterGroupCheck = submitterCheckSet.contains(true);
            } else if (MdmApprovalConfig.ConditionCheckWay.AND.getValue().equals(redisVo.getSubmitterCheckWay())) {
                submitterGroupCheck = !submitterCheckSet.contains(false);
            }
        }
        boolean check = true;
        if (MdmApprovalConfig.ConditionCheckWay.OR.getValue().equals(redisVo.getGroupCheckWay())) {
            check = conditionGroupCheck || submitterGroupCheck;
        } else if (MdmApprovalConfig.ConditionCheckWay.AND.getValue().equals(redisVo.getGroupCheckWay())) {
            boolean bl = check = conditionGroupCheck && submitterGroupCheck;
        }
        if (check && MdmApprovalConfig.ControlScope.PART_IN_CONDITION.getValue().equals(redisVo.getControlScope())) {
            return ApprovalType.getEnum((String)redisVo.getApprovalType());
        }
        if (!check && MdmApprovalConfig.ControlScope.PART_IN_CONDITION.getValue().equals(redisVo.getControlScope())) {
            return ApprovalType.NULL;
        }
        if (check && MdmApprovalConfig.ControlScope.PART_OUT_CONDITION.getValue().equals(redisVo.getControlScope())) {
            return ApprovalType.NULL;
        }
        if (!check && MdmApprovalConfig.ControlScope.PART_OUT_CONDITION.getValue().equals(redisVo.getControlScope())) {
            return ApprovalType.getEnum((String)redisVo.getApprovalType());
        }
        return ApprovalType.NULL;
    }

    public static boolean editableCheck(String approvalType, String approvalStatus) {
        return approvalType == null || "".equals(approvalType) || approvalStatus == null || "".equals(approvalStatus) || !ApprovalType.BPM.getValue().equals(approvalType) && !ApprovalType.STATUS.getValue().equals(approvalType) || !MdmBpmStatusEnum.PASS.getValue().equals(approvalStatus) && !MdmBpmStatusEnum.APPROVAL.getValue().equals(approvalStatus);
    }

    public static void deleteCache(String businessCode) {
        if (StringUtils.isNotEmpty((CharSequence)businessCode)) {
            redisService.del(new String[]{"MDM_APPROVAL_CONFIG_0426:" + businessCode});
            redisService.del(new String[]{"MDM_APPROVAL_CONFIG_LOCK_0426:" + businessCode});
        }
    }

    public static void deleteCache(List<String> businessCodeList) {
        if (businessCodeList != null && businessCodeList.size() > 0) {
            redisService.del((String[])businessCodeList.stream().map(x -> "MDM_APPROVAL_CONFIG_0426:" + x).toArray(String[]::new));
            redisService.del((String[])businessCodeList.stream().map(x -> "MDM_APPROVAL_CONFIG_LOCK_0426:" + x).toArray(String[]::new));
        }
    }

    private static boolean checkCondition(String fieldValue, MdmApprovalConfigConditionRedisVo condition) {
        String[] split;
        if (!YesNoEnum.yesNoEnum.ONE.getValue().equals(condition.getControlFlag())) {
            return true;
        }
        String fieldKeywords = condition.getFieldKeywords();
        if (StringUtils.isEmpty((CharSequence)fieldKeywords)) {
            throw new BusinessException("\u6761\u4ef6" + condition.getFieldName() + "\u7f3a\u5931\u5173\u952e\u503c");
        }
        for (String keywords : split = fieldKeywords.split(",")) {
            if (!MdmApprovalConfig.FieldCompareType.EQ.getValue().equals(condition.getCompareType()) || !fieldValue.equals(keywords)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean checkSubmitter(UserRedis user, MdmApprovalConfigSubmitterRedisVo submitter) {
        Assert.hasText((String)submitter.getSubmitterType(), (String)"\u7f3a\u5931\u63d0\u4ea4\u4eba\u5339\u914d\u5bf9\u8c61");
        HashSet<String> keyWordSet = new HashSet<String>(Arrays.asList(submitter.getFieldKeywords().split(",")));
        if (MdmApprovalConfig.SubmitterType.ORG.getValue().equals(submitter.getSubmitterType())) {
            if (!StringUtils.isNotEmpty((CharSequence)user.getOrgcode())) return false;
            ArrayList<String> strings = new ArrayList<String>();
            strings.addAll(Arrays.asList(user.getOrgcode().split(",")));
            if (MdmApprovalConfig.SubmitterCompareType.EQ.getValue().equals(submitter.getCompareType())) {
                strings.retainAll(keyWordSet);
                if (strings.size() <= 0) return false;
                return true;
            }
            if (MdmApprovalConfig.SubmitterCompareType.NE.getValue().equals(submitter.getCompareType())) {
                strings.retainAll(keyWordSet);
                if (strings.size() != 0) return false;
                return true;
            }
            if (MdmApprovalConfig.SubmitterCompareType.IN_PARENT.getValue().equals(submitter.getCompareType()) || MdmApprovalConfig.SubmitterCompareType.NOT_IN_PARENT.getValue().equals(submitter.getCompareType())) {
                List<String> parentOrgCodeSet = OrgUtil.getParentOrgCodeListIncludeSelfEnable(new ArrayList<String>(keyWordSet));
                strings.retainAll(parentOrgCodeSet);
                if (MdmApprovalConfig.SubmitterCompareType.IN_PARENT.getValue().equals(submitter.getCompareType()) && strings.size() > 0) {
                    return true;
                }
                if (!MdmApprovalConfig.SubmitterCompareType.NOT_IN_PARENT.getValue().equals(submitter.getCompareType()) || strings.size() != 0) return false;
                return true;
            }
            if (!MdmApprovalConfig.SubmitterCompareType.IN_CHILDREN.getValue().equals(submitter.getCompareType()) && !MdmApprovalConfig.SubmitterCompareType.NOT_IN_CHILDREN.getValue().equals(submitter.getCompareType())) throw new BusinessException("\u65e0\u6548\u7684\u5339\u914d\u65b9\u5f0f");
            List<String> childrenOrgCodeSet = OrgUtil.getChildrenOrgCodeListIncludeSelfEnable(new ArrayList<String>(keyWordSet));
            strings.retainAll(childrenOrgCodeSet);
            if (MdmApprovalConfig.SubmitterCompareType.IN_CHILDREN.getValue().equals(submitter.getCompareType()) && strings.size() > 0) {
                return true;
            }
            if (!MdmApprovalConfig.SubmitterCompareType.NOT_IN_CHILDREN.getValue().equals(submitter.getCompareType()) || strings.size() != 0) return false;
            return true;
        }
        if (MdmApprovalConfig.SubmitterType.POSITION.getValue().equals(submitter.getSubmitterType())) {
            if (!StringUtils.isNotEmpty((CharSequence)user.getPoscode())) return false;
            String positionCode = user.getPoscode();
            if (MdmApprovalConfig.SubmitterCompareType.EQ.getValue().equals(submitter.getCompareType())) {
                if (!keyWordSet.contains(positionCode)) return false;
                return true;
            }
            if (MdmApprovalConfig.SubmitterCompareType.NE.getValue().equals(submitter.getCompareType())) {
                if (keyWordSet.contains(positionCode)) return false;
                return true;
            }
            if (MdmApprovalConfig.SubmitterCompareType.IN_PARENT.getValue().equals(submitter.getCompareType()) || MdmApprovalConfig.SubmitterCompareType.NOT_IN_PARENT.getValue().equals(submitter.getCompareType())) {
                HashSet<String> parentPositionCodeSet = new HashSet<String>(PositionUtil.getParentPositionCodeListIncludeSelfEnable(new ArrayList<String>(keyWordSet)));
                if (MdmApprovalConfig.SubmitterCompareType.IN_PARENT.getValue().equals(submitter.getCompareType()) && parentPositionCodeSet.contains(positionCode)) {
                    return true;
                }
                if (!MdmApprovalConfig.SubmitterCompareType.NOT_IN_PARENT.getValue().equals(submitter.getCompareType()) || parentPositionCodeSet.contains(positionCode)) return false;
                return true;
            }
            if (!MdmApprovalConfig.SubmitterCompareType.IN_CHILDREN.getValue().equals(submitter.getCompareType()) && !MdmApprovalConfig.SubmitterCompareType.NOT_IN_CHILDREN.getValue().equals(submitter.getCompareType())) throw new BusinessException("\u65e0\u6548\u7684\u5339\u914d\u65b9\u5f0f");
            HashSet<String> childrenPositionCodeSet = new HashSet<String>(PositionUtil.getChildrenPositionCodeListIncludeSelfEnable(new ArrayList<String>(keyWordSet)));
            if (MdmApprovalConfig.SubmitterCompareType.IN_CHILDREN.getValue().equals(submitter.getCompareType()) && childrenPositionCodeSet.contains(positionCode)) {
                return true;
            }
            if (!MdmApprovalConfig.SubmitterCompareType.NOT_IN_CHILDREN.getValue().equals(submitter.getCompareType()) || childrenPositionCodeSet.contains(positionCode)) return false;
            return true;
        }
        if (!MdmApprovalConfig.SubmitterType.ROLE.getValue().equals(submitter.getSubmitterType())) return false;
        HashSet roleCodeSet = new HashSet(16);
        if (UserTypeEnum.USER.getCode().equals(user.getUsertype())) {
            Result roleByPositionCode = mdmRoleFeign.getRoleByPositionCode(user.getPoscode());
            if (!roleByPositionCode.isSuccess()) {
                throw new BusinessException(roleByPositionCode.getMessage());
            }
            roleCodeSet.addAll((Collection)roleByPositionCode.getResult());
        } else {
            Result roleByUserName = mdmRoleFeign.getRoleByUserName(user.getUsername());
            if (!roleByUserName.isSuccess()) {
                throw new BusinessException(roleByUserName.getMessage());
            }
            roleCodeSet.addAll((Collection)roleByUserName.getResult());
        }
        if (MdmApprovalConfig.SubmitterCompareType.EQ.getValue().equals(submitter.getCompareType())) {
            roleCodeSet.retainAll(keyWordSet);
            if (roleCodeSet.size() <= 0) return false;
            return true;
        }
        if (!MdmApprovalConfig.SubmitterCompareType.NE.getValue().equals(submitter.getCompareType())) return false;
        roleCodeSet.retainAll(keyWordSet);
        if (roleCodeSet.size() != 0) return false;
        return true;
    }

    private static MdmApprovalConfigRedisVo get(String businessCode) {
        MdmApprovalConfigRedisVo redisVo = null;
        if (!ApprovalConfigUtil.checkLock(businessCode)) {
            String key = "MDM_APPROVAL_CONFIG_0426:" + businessCode;
            Object o = redisService.get(key);
            if (o == null) {
                Result result = mdmApprovalConfigFeign.queryForRedis(businessCode);
                Assert.isTrue((boolean)result.isSuccess(), (String)"\u83b7\u53d6\u5ba1\u6279\u914d\u7f6e\u5931\u8d25");
                if (result.getResult() == null) {
                    ApprovalConfigUtil.lock(businessCode);
                } else {
                    redisVo = (MdmApprovalConfigRedisVo)result.getResult();
                    redisService.setSeconds(key, (Object)redisVo, 2592000L);
                }
            } else {
                redisVo = (MdmApprovalConfigRedisVo)o;
            }
        }
        return redisVo;
    }

    private static void lock(String businessCode) {
        redisService.set("MDM_APPROVAL_CONFIG_LOCK_0426:" + businessCode, (Object)2592000);
    }

    private static boolean checkLock(String businessCode) {
        Object o = redisService.get("MDM_APPROVAL_CONFIG_LOCK_0426:" + businessCode);
        return o != null;
    }
}

