/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.util;

import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;

public class PinyinUtils {
    HanyuPinyinOutputFormat format = new HanyuPinyinOutputFormat();
    static PinyinUtils record = new PinyinUtils();

    public PinyinUtils() {
        this.format.setCaseType(HanyuPinyinCaseType.UPPERCASE);
        this.format.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
    }

    public static String toPinLower(String str, String spera) {
        try {
            String pinYin = record.toPinYin(str, spera, Type.LOWERCASE);
            if ("0123456789".contains(pinYin)) {
                pinYin = PinyinUtils.numBerToPinyin(pinYin);
            }
            return pinYin;
        }
        catch (BadHanyuPinyinOutputFormatCombination e) {
            return "";
        }
    }

    public static String toPinYinFirstUpper(String str, String spera) {
        try {
            String pinYin = record.toPinYin(str, spera, Type.FIRSTUPPER);
            if ("0123456789".contains(pinYin)) {
                pinYin = PinyinUtils.numBerToPinyin(pinYin);
            }
            return pinYin;
        }
        catch (BadHanyuPinyinOutputFormatCombination e) {
            return "";
        }
    }

    public static String toPinYin(String str, String spera) {
        try {
            String pinYin = record.toPinYin(str, spera, Type.UPPERCASE);
            return pinYin;
        }
        catch (BadHanyuPinyinOutputFormatCombination e) {
            return "";
        }
    }

    public static String OnlyFirstChar_Upper(String str) {
        try {
            String pinYin = record.toPinYin(str, " ", Type.FIRSTUPPER);
            if (pinYin.length() == 0) {
                return "";
            }
            String[] array = pinYin.split(" ");
            String firstchar = "";
            for (String ste : array) {
                if (ste.length() <= 0) continue;
                firstchar = firstchar + ste.substring(0, 1).toUpperCase();
            }
            return firstchar;
        }
        catch (BadHanyuPinyinOutputFormatCombination e) {
            return "";
        }
    }

    public String toPinYin(String str, String spera, Type type) throws BadHanyuPinyinOutputFormatCombination {
        if (str == null || str.trim().length() == 0) {
            return "";
        }
        if (type == Type.UPPERCASE) {
            this.format.setCaseType(HanyuPinyinCaseType.UPPERCASE);
        } else {
            this.format.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        }
        String py = "";
        String temp = "";
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c <= '\u0080') {
                py = py + c;
                continue;
            }
            String[] t = PinyinHelper.toHanyuPinyinStringArray((char)c, (HanyuPinyinOutputFormat)this.format);
            if (t == null) {
                py = py + c;
                continue;
            }
            temp = t[0];
            if (type == Type.FIRSTUPPER) {
                temp = t[0].toUpperCase().charAt(0) + temp.substring(1);
            }
            py = py + temp + (i == str.length() - 1 ? "" : spera);
        }
        return py.trim();
    }

    public static String getFirstSpell(String chinese) {
        StringBuffer pybf = new StringBuffer();
        char[] arr = chinese.toCharArray();
        HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
        defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] > '\u0080') {
                try {
                    String[] temp = PinyinHelper.toHanyuPinyinStringArray((char)arr[i], (HanyuPinyinOutputFormat)defaultFormat);
                    if (temp == null) continue;
                    pybf.append(temp[0].charAt(0));
                }
                catch (BadHanyuPinyinOutputFormatCombination e) {
                    e.printStackTrace();
                }
                continue;
            }
            pybf.append(arr[i]);
        }
        return pybf.toString().replaceAll("\\W", "").trim();
    }

    public static String numBerToPinyin(String str) {
        String pinyin = null;
        switch (str) {
            case "0": {
                pinyin = "Z";
                break;
            }
            case "1": {
                pinyin = "Y";
                break;
            }
            case "2": {
                pinyin = "E";
                break;
            }
            case "3": {
                pinyin = "S";
                break;
            }
            case "4": {
                pinyin = "S";
                break;
            }
            case "5": {
                pinyin = "W";
                break;
            }
            case "6": {
                pinyin = "L";
                break;
            }
            case "7": {
                pinyin = "Q";
                break;
            }
            case "8": {
                pinyin = "B";
                break;
            }
            case "9": {
                pinyin = "J";
            }
        }
        return pinyin;
    }

    public static void main(String[] args) throws BadHanyuPinyinOutputFormatCombination {
        System.out.println(PinyinUtils.toPinLower("\u8d75\u6ce2\u84dd", ""));
    }

    public static enum Type {
        UPPERCASE,
        LOWERCASE,
        FIRSTUPPER,
        ONLYFIRSTCHAR;

    }
}

