/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.util;

import com.biz.crm.activiti.act.TaActBaseFeign;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.nebular.activiti.act.req.StartProcessReqVo;
import com.biz.crm.nebular.activiti.vo.ActivitiBusinessVo;
import com.biz.crm.nebular.activiti.vo.AttachmentVo;
import com.biz.crm.util.CommonConstant;
import com.biz.crm.util.Result;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ActivityUtils {
    private static final Logger log = LoggerFactory.getLogger(ActivityUtils.class);
    private static TaActBaseFeign actBaseFeign;

    @Autowired
    public void setActBaseFeign(TaActBaseFeign actBaseFeign) {
        ActivityUtils.actBaseFeign = actBaseFeign;
    }

    public static String startProcess(StartProcessReqVo processReqVo) {
        Result stringResult;
        ActivitiBusinessVo activitiBusinessVo = new ActivitiBusinessVo();
        activitiBusinessVo.setProcessKey(processReqVo.getProcessKey());
        activitiBusinessVo.setBusinessIdOrNum(processReqVo.getFormNo());
        activitiBusinessVo.setRemark(processReqVo.getRemark());
        activitiBusinessVo.setVariables(processReqVo.getVariables());
        activitiBusinessVo.setProcessTitle(processReqVo.getTitle());
        activitiBusinessVo.setTargetText(processReqVo.getKeyTargetListJson());
        if (CollectionUtils.isNotEmpty((Collection)processReqVo.getFileList())) {
            List attachmentVos = processReqVo.getFileList().stream().map(o -> {
                AttachmentVo attachmentVo = new AttachmentVo();
                attachmentVo.setFileName(o.getObjectName());
                attachmentVo.setObjectName(o.getObjectName());
                attachmentVo.setFileAddress(o.getFileAddress());
                return attachmentVo;
            }).collect(Collectors.toList());
            activitiBusinessVo.setAttachmentVos(attachmentVos);
        }
        if (!Objects.equals(CommonConstant.SC_OK_200, (stringResult = actBaseFeign.startProcess(activitiBusinessVo)).getCode())) {
            throw new BusinessException(stringResult.getMessage());
        }
        String s = (String)ApiResultUtil.objResult((Result)stringResult, (boolean)true);
        return s;
    }
}

