/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.util;

import com.biz.crm.base.BusinessException;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.UserUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringJoiner;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class JobHelper {
    private static final Logger log = LoggerFactory.getLogger(JobHelper.class);
    private static final long JOB_RUNNING_TIME = 2764800L;
    private static final int JOB_BIZ_DATA_PAGE_SIZE = 500;
    @Resource
    private RedisService redisService;

    public int getJobBizDataPageSize() {
        return 500;
    }

    public void executeJob(JobContext context) {
        String jobTime = context.getJobTime();
        Boolean compulsive = context.getCompulsive();
        String key = context.getJob().name() + jobTime;
        if (null != compulsive && compulsive.booleanValue()) {
            this.compulsiveJob(context, key);
            return;
        }
        this.jobIsDone(context, key);
        this.doJobExecute(context, key);
        this.updateJobEndStatus(context, key);
    }

    private void doJobExecute(JobContext context, String key) {
        try {
            UserUtils.doTokenForUserName("admin", 2764800L);
            context.getExecutor().execute();
        }
        catch (Exception e) {
            String redisHash = context.getRedisHash();
            if (this.redisService.hmHasKey(redisHash, (Object)key).booleanValue()) {
                this.redisService.hmDelete(redisHash, new Object[]{key});
            }
            log.error("\u4efb\u52a1[" + context.getJob().name() + "]\u542f\u52a8\u5931\u8d25", (Throwable)e);
            throw new BusinessException("\u4efb\u52a1[" + context.getJob().name() + "]\u542f\u52a8\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01", (Throwable)e);
        }
    }

    private void jobIsDone(JobContext context, String key) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setIp(this.getIp(context));
        jobInfo.setEndStatus(false);
        String redisHash = context.getRedisHash();
        boolean result = this.redisService.putIfAbsent(redisHash, key, (Object)jobInfo, 2764800L);
        if (!result) {
            jobInfo = (JobInfo)this.redisService.hmget(redisHash, (Object)key);
            throw new BusinessException("\u5e94\u7528\u670d\u52a1[" + jobInfo.getIp() + "]\u5df2\u7ecf\u6267\u884c\u8fc7\u4efb\u52a1[" + context.getJob().name() + "]\uff0c\u4efb\u52a1\u65f6\u95f4[" + context.getJobTime() + "],\u4f60\u53ef\u9009\u62e9\u5f3a\u5236\u542f\u52a8\u4efb\u52a1\uff01");
        }
    }

    private void compulsiveJob(JobContext context, String key) {
        String redisHash = context.getRedisHash();
        JobInfo jobInfo = (JobInfo)this.redisService.hmget(redisHash, (Object)key);
        if (null != jobInfo && !jobInfo.getEndStatus().booleanValue()) {
            throw new BusinessException("\u4efb\u52a1[" + context.getJob().name() + "]\u542f\u52a8\u5931\u8d25\uff0c\u5df2\u6709\u4efb\u52a1\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
        }
        jobInfo = new JobInfo();
        jobInfo.setIp(this.getIp(context));
        jobInfo.setEndStatus(false);
        this.redisService.put(redisHash, key, (Object)jobInfo, 2764800L);
        this.doJobExecute(context, key);
        this.updateJobEndStatus(context, key);
    }

    private void updateJobEndStatus(JobContext context, String key) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setIp(this.getIp(context));
        jobInfo.setEndStatus(true);
        this.redisService.put(context.getRedisHash(), key, (Object)jobInfo, 2764800L);
    }

    private String getIp(JobContext context) {
        String ip = "do not get ip";
        try {
            ip = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            log.warn("\u4efb\u52a1[" + context.getJob().name() + "]\uff1a\u672a\u83b7\u53d6\u5230\u672c\u673aip", (Throwable)e);
        }
        return ip;
    }

    public static enum Job {
        PLAN_INFO_SETTLEMENT_JOB,
        RESOLVE_SFA_VISIT_STEP_ACTIVITY_EXECUTION_JOB,
        INTEGRAL_DETAIL_JOB;

    }

    public static class JobInfo {
        private String ip;
        private Boolean endStatus;

        public String getIp() {
            return this.ip;
        }

        public Boolean getEndStatus() {
            return this.endStatus;
        }

        public void setIp(String ip) {
            this.ip = ip;
        }

        public void setEndStatus(Boolean endStatus) {
            this.endStatus = endStatus;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JobInfo)) {
                return false;
            }
            JobInfo other = (JobInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$ip = this.getIp();
            String other$ip = other.getIp();
            if (this$ip == null ? other$ip != null : !this$ip.equals(other$ip)) {
                return false;
            }
            Boolean this$endStatus = this.getEndStatus();
            Boolean other$endStatus = other.getEndStatus();
            return !(this$endStatus == null ? other$endStatus != null : !((Object)this$endStatus).equals(other$endStatus));
        }

        protected boolean canEqual(Object other) {
            return other instanceof JobInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $ip = this.getIp();
            result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
            Boolean $endStatus = this.getEndStatus();
            result = result * 59 + ($endStatus == null ? 43 : ((Object)$endStatus).hashCode());
            return result;
        }

        public String toString() {
            return "JobHelper.JobInfo(ip=" + this.getIp() + ", endStatus=" + this.getEndStatus() + ")";
        }
    }

    public static interface JobExecutor {
        public void execute();
    }

    public static class JobContext {
        private JobExecutor executor;
        private Job job;
        private String jobTime;
        private Boolean compulsive;
        private String redisHash;

        public void setJob(Job job) {
            if (null == job) {
                return;
            }
            this.redisHash = new StringJoiner(":").add("SFA_VISIT").add(job.name()).toString();
            this.job = job;
        }

        public JobExecutor getExecutor() {
            return this.executor;
        }

        public Job getJob() {
            return this.job;
        }

        public String getJobTime() {
            return this.jobTime;
        }

        public Boolean getCompulsive() {
            return this.compulsive;
        }

        public String getRedisHash() {
            return this.redisHash;
        }

        public void setExecutor(JobExecutor executor) {
            this.executor = executor;
        }

        public void setJobTime(String jobTime) {
            this.jobTime = jobTime;
        }

        public void setCompulsive(Boolean compulsive) {
            this.compulsive = compulsive;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JobContext)) {
                return false;
            }
            JobContext other = (JobContext)o;
            if (!other.canEqual(this)) {
                return false;
            }
            JobExecutor this$executor = this.getExecutor();
            JobExecutor other$executor = other.getExecutor();
            if (this$executor == null ? other$executor != null : !this$executor.equals(other$executor)) {
                return false;
            }
            Job this$job = this.getJob();
            Job other$job = other.getJob();
            if (this$job == null ? other$job != null : !((Object)((Object)this$job)).equals((Object)other$job)) {
                return false;
            }
            String this$jobTime = this.getJobTime();
            String other$jobTime = other.getJobTime();
            if (this$jobTime == null ? other$jobTime != null : !this$jobTime.equals(other$jobTime)) {
                return false;
            }
            Boolean this$compulsive = this.getCompulsive();
            Boolean other$compulsive = other.getCompulsive();
            if (this$compulsive == null ? other$compulsive != null : !((Object)this$compulsive).equals(other$compulsive)) {
                return false;
            }
            String this$redisHash = this.getRedisHash();
            String other$redisHash = other.getRedisHash();
            return !(this$redisHash == null ? other$redisHash != null : !this$redisHash.equals(other$redisHash));
        }

        protected boolean canEqual(Object other) {
            return other instanceof JobContext;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            JobExecutor $executor = this.getExecutor();
            result = result * 59 + ($executor == null ? 43 : $executor.hashCode());
            Job $job = this.getJob();
            result = result * 59 + ($job == null ? 43 : ((Object)((Object)$job)).hashCode());
            String $jobTime = this.getJobTime();
            result = result * 59 + ($jobTime == null ? 43 : $jobTime.hashCode());
            Boolean $compulsive = this.getCompulsive();
            result = result * 59 + ($compulsive == null ? 43 : ((Object)$compulsive).hashCode());
            String $redisHash = this.getRedisHash();
            result = result * 59 + ($redisHash == null ? 43 : $redisHash.hashCode());
            return result;
        }

        public String toString() {
            return "JobHelper.JobContext(executor=" + this.getExecutor() + ", job=" + (Object)((Object)this.getJob()) + ", jobTime=" + this.getJobTime() + ", compulsive=" + this.getCompulsive() + ", redisHash=" + this.getRedisHash() + ")";
        }
    }
}

