/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.util;

import com.biz.crm.base.BusinessException;
import com.biz.crm.config.SpringApplicationContextUtil;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.UserUtils;
import java.util.StringJoiner;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class JobHelper {
    private static final Logger log = LoggerFactory.getLogger(JobHelper.class);
    private static final long JOB_RUNNING_TIME = 172800L;
    private static final int JOB_BIZ_DATA_PAGE_SIZE = 500;
    public static final String redisHash = new StringJoiner(":").add("SFA_JOB").toString();
    @Resource
    private RedisService redisService;

    public int getJobBizDataPageSize() {
        return 500;
    }

    public void executeJobSaveContext(JobContext context) {
        this.saveContext(context);
        this.doJobExecute(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveContext(JobContext context) {
        String key = context.getJob().name();
        Job job = context.getJob();
        JobHelper jobHelper = this;
        synchronized (jobHelper) {
            if (!this.redisService.putIfAbsent(redisHash, key, (Object)context, 172800L)) {
                String msg = "\u4efb\u52a1[" + job.name() + "]\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01";
                log.warn(msg);
                throw new BusinessException(msg);
            }
        }
    }

    @Async
    public void executeJobAsyncSaveContext(JobContext context) {
        this.executeJobSaveContext(context);
    }

    @Async
    public void executeJobAsync(JobContext context) {
        this.doJobExecute(context);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doJobExecute(JobContext context) {
        String key = context.getJob().name();
        Job job = context.getJob();
        try {
            UserUtils.doTokenForUserName("admin", 172800L);
            JobExecutor jobExecutor = (JobExecutor)SpringApplicationContextUtil.getApplicationContext().getBean(context.getExecutorBeanClass());
            jobExecutor.executeJob(context.getJobParam());
            if (this.redisService.hmHasKey(redisHash, (Object)key) == false) return;
        }
        catch (BeansException e) {
            try {
                log.error("\u4efb\u52a1[" + context.getJob().name() + "]\u542f\u52a8\u5931\u8d25", (Throwable)e);
                throw new BusinessException("\u4efb\u52a1[" + job.name() + "]\u542f\u52a8\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01", (Throwable)e);
                catch (Exception e2) {
                    log.error("\u4efb\u52a1[" + context.getJob().name() + "]\u542f\u52a8\u5931\u8d25", (Throwable)e2);
                    throw new BusinessException("\u4efb\u52a1[" + job.name() + "]\u542f\u52a8\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01", (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                if (this.redisService.hmHasKey(redisHash, (Object)key) == false) throw throwable;
                this.redisService.hmDelete(redisHash, new Object[]{key});
                throw throwable;
            }
        }
        this.redisService.hmDelete(redisHash, new Object[]{key});
    }

    public static enum Job {
        PLAN_INFO_SETTLEMENT_JOB,
        RESOLVE_SFA_VISIT_STEP_ACTIVITY_EXECUTION_JOB,
        VISIT_DAY_RATE_JOB,
        INTEGRAL_MONTH_JOB;

    }

    public static interface JobExecutor {
        public void executeJob(Object var1);
    }

    public static class JobContext {
        private Class<? extends JobExecutor> executorBeanClass;
        private Job job;
        private Object jobParam;

        public Class<? extends JobExecutor> getExecutorBeanClass() {
            return this.executorBeanClass;
        }

        public Job getJob() {
            return this.job;
        }

        public Object getJobParam() {
            return this.jobParam;
        }

        public void setExecutorBeanClass(Class<? extends JobExecutor> executorBeanClass) {
            this.executorBeanClass = executorBeanClass;
        }

        public void setJob(Job job) {
            this.job = job;
        }

        public void setJobParam(Object jobParam) {
            this.jobParam = jobParam;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JobContext)) {
                return false;
            }
            JobContext other = (JobContext)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Class<? extends JobExecutor> this$executorBeanClass = this.getExecutorBeanClass();
            Class<? extends JobExecutor> other$executorBeanClass = other.getExecutorBeanClass();
            if (this$executorBeanClass == null ? other$executorBeanClass != null : !this$executorBeanClass.equals(other$executorBeanClass)) {
                return false;
            }
            Job this$job = this.getJob();
            Job other$job = other.getJob();
            if (this$job == null ? other$job != null : !((Object)((Object)this$job)).equals((Object)other$job)) {
                return false;
            }
            Object this$jobParam = this.getJobParam();
            Object other$jobParam = other.getJobParam();
            return !(this$jobParam == null ? other$jobParam != null : !this$jobParam.equals(other$jobParam));
        }

        protected boolean canEqual(Object other) {
            return other instanceof JobContext;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<? extends JobExecutor> $executorBeanClass = this.getExecutorBeanClass();
            result = result * 59 + ($executorBeanClass == null ? 43 : $executorBeanClass.hashCode());
            Job $job = this.getJob();
            result = result * 59 + ($job == null ? 43 : ((Object)((Object)$job)).hashCode());
            Object $jobParam = this.getJobParam();
            result = result * 59 + ($jobParam == null ? 43 : $jobParam.hashCode());
            return result;
        }

        public String toString() {
            return "JobHelper.JobContext(executorBeanClass=" + this.getExecutorBeanClass() + ", job=" + (Object)((Object)this.getJob()) + ", jobParam=" + this.getJobParam() + ")";
        }
    }
}

