/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.util.dms;

import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.dms.PromotionPolicyEunm;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;

public class PromotionPolicyUtil {
    public static final String promotionPolicyStatus(String enableStatus, String beginTime, String endTime) {
        if (CrmEnableStatusEnum.DISABLE.getCode().equals(enableStatus)) {
            return enableStatus;
        }
        return PromotionPolicyUtil.timeActive(beginTime, endTime);
    }

    public static final String promotionPolicyStatusNoEnable(String beginTime, String endTime) {
        return PromotionPolicyUtil.timeActive(beginTime, endTime);
    }

    public static final String timeActive(String beginTime, String endTime) {
        if (StringUtils.isBlank((CharSequence)beginTime) || StringUtils.isBlank((CharSequence)endTime)) {
            return PromotionPolicyEunm.PromotionPolicyStatusEunm.WAITING.getCode();
        }
        long tempBegin = DateUtils.parseDate((String)beginTime, (Locale)Locale.CHINESE, (String[])new String[]{"yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss"}).getTime();
        long tempEnd = DateUtils.parseDate((String)endTime, (Locale)Locale.CHINESE, (String[])new String[]{"yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss"}).getTime();
        long now = System.currentTimeMillis() / 1000L;
        if (tempBegin > now) {
            return PromotionPolicyEunm.PromotionPolicyStatusEunm.WAITING.getCode();
        }
        if (now > tempBegin && now < tempEnd) {
            return PromotionPolicyEunm.PromotionPolicyStatusEunm.RUNNING.getCode();
        }
        return PromotionPolicyEunm.PromotionPolicyStatusEunm.FINISHED.getCode();
    }
}

