/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.util;

public abstract class DistanceUtil {
    private static double EarthRadius = 6378137.0;

    private static double rad(double d) {
        return d * Math.PI / 180.0;
    }

    public static double getDistance(double firstLatitude, double firstLongitude, double secondLatitude, double secondLongitude) {
        double firstRadLat = DistanceUtil.rad(firstLatitude);
        double firstRadLng = DistanceUtil.rad(firstLongitude);
        double secondRadLat = DistanceUtil.rad(secondLatitude);
        double secondRadLng = DistanceUtil.rad(secondLongitude);
        double a = firstRadLat - secondRadLat;
        double b = firstRadLng - secondRadLng;
        double cal = 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin(a / 2.0), 2.0) + Math.cos(firstRadLat) * Math.cos(secondRadLat) * Math.pow(Math.sin(b / 2.0), 2.0))) * EarthRadius;
        double result = (double)Math.round(cal * 10000.0) / 10000.0;
        return result;
    }

    public static double GetPointDistance(String firstPoint, String secondPoint) {
        String[] firstArray = firstPoint.split(",");
        String[] secondArray = secondPoint.split(",");
        double firstLatitude = Double.valueOf(firstArray[0].trim());
        double firstLongitude = Double.valueOf(firstArray[1].trim());
        double secondLatitude = Double.valueOf(secondArray[0].trim());
        double secondLongitude = Double.valueOf(secondArray[1].trim());
        return DistanceUtil.getDistance(firstLatitude, firstLongitude, secondLatitude, secondLongitude);
    }
}

