/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.util.dms;

import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.dms.PromotionPolicyEunm;
import com.biz.crm.util.CrmDateUtils;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import org.apache.commons.lang3.StringUtils;

public class PromotionPolicyUtil {
    public static final String promotionPolicyStatus(String enableStatus, String beginTime, String endTime) {
        if (CrmEnableStatusEnum.DISABLE.getCode().equals(enableStatus)) {
            return enableStatus;
        }
        return PromotionPolicyUtil.timeActive(beginTime, endTime);
    }

    public static final String promotionPolicyStatusNoEnable(String beginTime, String endTime) {
        return PromotionPolicyUtil.timeActive(beginTime, endTime);
    }

    public static final String timeActive(String beginTime, String endTime) {
        if (StringUtils.isBlank((CharSequence)beginTime) || StringUtils.isBlank((CharSequence)endTime)) {
            return PromotionPolicyEunm.PromotionPolicyStatusEunm.WAITING.getCode();
        }
        long tempBegin = LocalDateTime.parse(beginTime, CrmDateUtils.yyyyMMddHHmmss).toEpochSecond(ZoneOffset.of("+8"));
        long tempEnd = LocalDateTime.parse(endTime, CrmDateUtils.yyyyMMddHHmmss).toEpochSecond(ZoneOffset.of("+8"));
        long now = System.currentTimeMillis() / 1000L;
        if (tempBegin > now) {
            return PromotionPolicyEunm.PromotionPolicyStatusEunm.WAITING.getCode();
        }
        if (now > tempBegin && now < tempEnd) {
            return PromotionPolicyEunm.PromotionPolicyStatusEunm.RUNNING.getCode();
        }
        return PromotionPolicyEunm.PromotionPolicyStatusEunm.FINISHED.getCode();
    }
}

