/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.util;

import com.alibaba.excel.util.CollectionUtils;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.config.SpringApplicationContextUtil;
import com.biz.crm.mdm.permission.MdmDataPermissionFeign;
import com.biz.crm.nebular.mdm.permission.MdmCurrentPermissionRespVo;
import com.biz.crm.nebular.mdm.permission.MdmPermissionSetVo;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PermissionUtil {
    private static final Logger log = LoggerFactory.getLogger(PermissionUtil.class);
    private static MdmDataPermissionFeign mdmDataPermissionFeign;

    public static List<MdmPermissionSetVo> currentUserPermissionSql() {
        if (mdmDataPermissionFeign == null) {
            mdmDataPermissionFeign = (MdmDataPermissionFeign)SpringApplicationContextUtil.getApplicationContext().getBean(MdmDataPermissionFeign.class);
        }
        return Optional.ofNullable(mdmDataPermissionFeign.currentUserPermissionSql()).map(Result::getResult).orElse(new ArrayList());
    }

    public static MdmCurrentPermissionRespVo currentUserPermissionList() {
        if (mdmDataPermissionFeign == null) {
            mdmDataPermissionFeign = (MdmDataPermissionFeign)SpringApplicationContextUtil.getApplicationContext().getBean(MdmDataPermissionFeign.class);
        }
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        Object functionCodeObj = ThreadLocalUtil.getObj((String)"functionCode");
        String menuCode = Objects.nonNull(menuCodeObj) ? menuCodeObj.toString() : null;
        String functionCode = Objects.nonNull(functionCodeObj) ? functionCodeObj.toString() : null;
        log.info("[\u6743\u9650\u5de5\u5177\u7c7b]\u83dc\u5355\u7f16\u7801:{}", (Object)menuCode);
        log.info("[\u6743\u9650\u5de5\u5177\u7c7b]\u529f\u80fd\u7f16\u7801:{}", (Object)functionCode);
        if (StringUtils.isEmpty((String)menuCode) || StringUtils.isEmpty((String)functionCode)) {
            return new MdmCurrentPermissionRespVo();
        }
        return Optional.ofNullable(mdmDataPermissionFeign.currentUserDataPermission(menuCode, functionCode)).map(Result::getResult).map(x -> {
            List permissionObjCodeList = Optional.ofNullable(x.getPermissionObjCodeList()).orElse(new ArrayList());
            List excludePermissionObjCodeList = Optional.ofNullable(x.getExcludePermissionObjCodeList()).orElse(new ArrayList());
            List filterPermissionObjCodeList = permissionObjCodeList.stream().filter(k -> CollectionUtils.isEmpty((Collection)excludePermissionObjCodeList) || !excludePermissionObjCodeList.contains(k)).collect(Collectors.toList());
            x.setFilterPermissionObjCodeList(filterPermissionObjCodeList);
            x.setPermissionObjCodeList(permissionObjCodeList);
            x.setExcludePermissionObjCodeList(excludePermissionObjCodeList);
            return x;
        }).orElse(new MdmCurrentPermissionRespVo());
    }
}

