/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.aop;

import com.alibaba.fastjson.JSONArray;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import io.swagger.annotations.ApiOperation;
import java.lang.reflect.Method;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class WebLogAspect {
    private static final Logger log = LoggerFactory.getLogger(WebLogAspect.class);

    @Before(value="@annotation(CrmLog) || @within(CrmGlobalLog)")
    public void doBefore(JoinPoint joinPoint) {
        HttpServletRequest request;
        String contentType;
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (requestAttributes != null && StringUtils.isNotEmpty((String)(contentType = (request = requestAttributes.getRequest()).getContentType())) && contentType.contains("application/json")) {
            Class<?> clazz = joinPoint.getTarget().getClass();
            Method method = ((MethodSignature)joinPoint.getSignature()).getMethod();
            ApiOperation apiOperation = method.getAnnotation(ApiOperation.class);
            log.info("------------------------------------------AOP\u65e5\u5fd7start--------------------------------------------------------");
            log.info("[AOP\u65e5\u5fd7]:\u7c7b\u540d:{}", (Object)clazz.getName());
            Optional.ofNullable(apiOperation).filter(x -> !StringUtils.isEmpty((String)x.value())).ifPresent(x -> log.info("[AOP\u65e5\u5fd7]:apiOperation\u6ce8\u91ca:{}", (Object)x.value()));
            log.info("[AOP\u65e5\u5fd7]:\u65b9\u6cd5\u540d:{}", (Object)method.getName());
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("[AOP\u65e5\u5fd7]:\u65b9\u6cd5\u5165\u53c2:{}");
            Optional.ofNullable(joinPoint.getArgs()).ifPresent(x -> {
                for (Object arg : x) {
                    String temp = JSONArray.toJSONString((Object)x);
                    log.info("[AOP\u65e5\u5fd7]:\u65b9\u6cd5\u5165\u53c2:{}", (Object)temp);
                    stringBuffer.append(temp);
                    stringBuffer.append("<=====>");
                }
            });
            UserRedis user = UserUtils.getUser();
            log.info("[AOP\u65e5\u5fd7]:\u8bf7\u6c42\u7528\u6237:{}", (Object)user);
            log.info("------------------------------------------AOP\u65e5\u5fd7end--------------------------------------------------------");
            ThreadLocalUtil.setParameter((String)stringBuffer.toString());
        }
    }
}

