/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.util.fee;

import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.fee.FeePoolOperationTypeGroupEnum;
import com.biz.crm.nebular.fee.pool.resp.FeePoolPageConfigVo;
import com.biz.crm.nebular.fee.pool.resp.FeeSelectOptionVo;
import com.biz.crm.nebular.mdm.dict.resp.DictDataVo;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.ParamUtil;
import com.biz.crm.util.StringUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.util.Assert;

public class FeePoolConfigUtil {
    public static final String FEE_POOL_AMOUNT_DESC = FeePoolConfigUtil.getFeePoolAmountDesc();

    public static FeePoolPageConfigVo getConfig(String configCode) {
        String adjustOperationType;
        String accountOperationType;
        Map<String, String> useTypeMap;
        String useType;
        String poolType;
        Map<String, String> feePoolGroupMap;
        FeePoolPageConfigVo configVo = new FeePoolPageConfigVo();
        Map<String, String> extendMap = DictUtil.getExtendMap("fee_pool_page_list_config", configCode);
        if (extendMap == null || extendMap.isEmpty()) {
            throw new BusinessException("\u672a\u627e\u5230\u914d\u7f6e\u3010" + configCode + "\u3011");
        }
        String poolGroup = extendMap.get("pool_group");
        if (StringUtils.isNotEmpty((String)poolGroup) && !(feePoolGroupMap = DictUtil.dictMap("fee_pool_group")).isEmpty()) {
            configVo.setPoolGroupList(Arrays.stream(poolGroup.split(",")).filter(feePoolGroupMap::containsKey).map(x -> {
                FeeSelectOptionVo vo = new FeeSelectOptionVo();
                vo.setValue(x);
                vo.setText((String)feePoolGroupMap.get(x));
                return vo;
            }).collect(Collectors.toList()));
        }
        if (StringUtils.isNotEmpty((String)(poolType = extendMap.get("pool_type")))) {
            Map<String, DictDataVo> feePoolTypeMap = DictUtil.list("fee_pool_type").stream().collect(Collectors.toMap(DictDataVo::getDictCode, v -> v));
            Map<String, String> payTypeMap = DictUtil.dictMap("fee_pool_pay_type");
            if (!feePoolTypeMap.isEmpty()) {
                configVo.setPoolTypeList(Arrays.stream(poolType.split(",")).filter(feePoolTypeMap::containsKey).map(x -> {
                    DictDataVo dictDataVo = (DictDataVo)feePoolTypeMap.get(x);
                    FeeSelectOptionVo vo = new FeeSelectOptionVo();
                    vo.setValue(x);
                    vo.setText(dictDataVo.getDictValue());
                    String payType = (String)dictDataVo.getExtendMap().get("pay_type");
                    if (StringUtils.isNotEmpty((String)payType)) {
                        FeeSelectOptionVo payTypeSelectVo = new FeeSelectOptionVo();
                        payTypeSelectVo.setValue(payType);
                        payTypeSelectVo.setText((String)payTypeMap.get(payType));
                        vo.setPayTypeList(Collections.singletonList(payTypeSelectVo));
                    }
                    return vo;
                }).collect(Collectors.toList()));
            }
        }
        if (StringUtils.isNotEmpty((String)(useType = extendMap.get("use_type"))) && !(useTypeMap = DictUtil.dictMap("fee_pool_use_type")).isEmpty()) {
            configVo.setUseTypeList(Arrays.stream(useType.split(",")).filter(useTypeMap::containsKey).map(x -> {
                FeeSelectOptionVo vo = new FeeSelectOptionVo();
                vo.setValue(x);
                vo.setText((String)useTypeMap.get(x));
                return vo;
            }).collect(Collectors.toList()));
        }
        List<DictDataVo> operationTypeList = DictUtil.list("fee_pool_operation_type");
        Map<String, String> operationTypeMap = operationTypeList.stream().collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictValue));
        String queryOperationType = extendMap.get("query_operation_type");
        if (StringUtils.isNotEmpty((String)queryOperationType) && !operationTypeMap.isEmpty()) {
            configVo.setQueryOperationTypeList(Arrays.stream(queryOperationType.split(",")).filter(operationTypeMap::containsKey).map(x -> {
                FeeSelectOptionVo vo = new FeeSelectOptionVo();
                vo.setValue(x);
                vo.setText((String)operationTypeMap.get(x));
                return vo;
            }).collect(Collectors.toList()));
        }
        if (StringUtils.isNotEmpty((String)(accountOperationType = extendMap.get("account_operation_type"))) && !operationTypeMap.isEmpty()) {
            configVo.setAccountOperationTypeList(Arrays.stream(accountOperationType.split(",")).filter(operationTypeMap::containsKey).map(x -> {
                FeeSelectOptionVo vo = new FeeSelectOptionVo();
                vo.setValue(x);
                vo.setText((String)operationTypeMap.get(x));
                return vo;
            }).collect(Collectors.toList()));
        }
        if (StringUtils.isNotEmpty((String)(adjustOperationType = extendMap.get("adjust_operation_type"))) && !operationTypeMap.isEmpty()) {
            configVo.setAdjustOperationTypeList(Arrays.stream(adjustOperationType.split(",")).filter(operationTypeMap::containsKey).map(x -> {
                FeeSelectOptionVo vo = new FeeSelectOptionVo();
                vo.setValue(x);
                vo.setText((String)operationTypeMap.get(x));
                return vo;
            }).collect(Collectors.toList()));
        }
        configVo.setFreezeOperationTypeList(operationTypeList.stream().filter(item -> FeePoolOperationTypeGroupEnum.FREEZE.getValue().equals(item.getExtendMap().get("operation_group"))).map(x -> {
            FeeSelectOptionVo optionVo = new FeeSelectOptionVo();
            optionVo.setValue(x.getDictCode());
            optionVo.setText(x.getDictValue());
            return optionVo;
        }).collect(Collectors.toList()));
        configVo.setUnfreezeOperationTypeList(operationTypeList.stream().filter(item -> FeePoolOperationTypeGroupEnum.UNFREEZE.getValue().equals(item.getExtendMap().get("operation_group"))).map(x -> {
            FeeSelectOptionVo optionVo = new FeeSelectOptionVo();
            optionVo.setValue(x.getDictCode());
            optionVo.setText(x.getDictValue());
            return optionVo;
        }).collect(Collectors.toList()));
        configVo.setLineDetailAdjustConfigCode(extendMap.get("line_detail_adjust_config_code"));
        return configVo;
    }

    public static List<String> getConfigQueryPoolTypeList(String configCode) {
        Map<String, String> extendMap = DictUtil.getExtendMap("fee_pool_page_list_config", configCode);
        if (extendMap == null || extendMap.isEmpty()) {
            throw new BusinessException("\u672a\u627e\u5230\u914d\u7f6e\u3010" + configCode + "\u3011\u7684\u67e5\u8be2\u8d39\u7528\u6c60\u7c7b\u578b");
        }
        String poolType = extendMap.get("pool_type");
        if (StringUtils.isNotEmpty((String)poolType)) {
            return Arrays.asList(poolType.split(","));
        }
        return Collections.emptyList();
    }

    public static List<String> getConfigQueryOperationTypeList(String configCode) {
        Map<String, String> extendMap = DictUtil.getExtendMap("fee_pool_page_list_config", configCode);
        if (extendMap == null || extendMap.isEmpty()) {
            throw new BusinessException("\u672a\u627e\u5230\u914d\u7f6e\u3010" + configCode + "\u3011\u7684\u67e5\u8be2\u8d39\u7528\u6c60\u7c7b\u578b");
        }
        String operationType = extendMap.get("query_operation_type");
        if (StringUtils.isNotEmpty((String)operationType)) {
            return Arrays.asList(operationType.split(","));
        }
        return Collections.emptyList();
    }

    public static String getConfigQueryPoolGroup(String configCode) {
        Map<String, String> extendMap = DictUtil.getExtendMap("fee_pool_page_list_config", configCode);
        if (extendMap == null || extendMap.isEmpty()) {
            throw new BusinessException("\u672a\u627e\u5230\u914d\u7f6e\u3010" + configCode + "\u3011\u7684\u67e5\u8be2\u8d39\u7528\u6c60\u5206\u7ec4");
        }
        String poolGroup = extendMap.get("pool_group");
        if (StringUtils.isNotEmpty((String)poolGroup)) {
            return poolGroup;
        }
        return null;
    }

    public static List<String> getOperationTypeList(FeePoolOperationTypeGroupEnum groupEnum) {
        return DictUtil.list("fee_pool_operation_type").stream().filter(item -> groupEnum == null || groupEnum.getValue().equals(item.getExtendMap().get("operation_group"))).map(DictDataVo::getDictCode).collect(Collectors.toList());
    }

    public static boolean checkOperationTypeGroup(String operationType, FeePoolOperationTypeGroupEnum groupEnum) {
        String operationTypeValue = DictUtil.dictValue("fee_pool_operation_type", operationType);
        Assert.hasText((String)operationTypeValue, (String)"\u65e0\u6548\u7684\u64cd\u4f5c\u7c7b\u578b");
        Map<String, String> extendMap = DictUtil.getExtendMap("fee_pool_operation_type", operationType);
        Assert.isTrue((boolean)extendMap.containsKey("operation_group"), (String)("\u64cd\u4f5c\u7c7b\u578b" + operationTypeValue + "\u672a\u914d\u7f6e\u5206\u7ec4"));
        return groupEnum.getValue().equals(extendMap.get("operation_group"));
    }

    public static String getPayType(String poolType) {
        String poolTypeValue = DictUtil.dictValue("fee_pool_type", poolType);
        Assert.hasText((String)poolTypeValue, (String)"\u65e0\u6548\u7684\u8d39\u7528\u6c60\u7c7b\u578b");
        Map<String, String> discountExtendMap = DictUtil.getExtendMap("fee_pool_type", poolType);
        String payType = discountExtendMap.get("pay_type");
        Assert.hasText((String)payType, (String)(poolTypeValue + "\u672a\u914d\u7f6e\u652f\u4ed8\u65b9\u5f0f"));
        return payType;
    }

    public static FeePoolOperationTypeGroupEnum getOperationTypeGroup(String operationType) {
        String operationTypeValue = DictUtil.dictValue("fee_pool_operation_type", operationType);
        Assert.hasText((String)operationTypeValue, (String)"\u65e0\u6548\u7684\u64cd\u4f5c\u7c7b\u578b");
        Map<String, String> extendMap = DictUtil.getExtendMap("fee_pool_operation_type", operationType);
        String group = extendMap.get("operation_group");
        Assert.hasText((String)group, (String)("\u64cd\u4f5c\u7c7b\u578b" + operationTypeValue + "\u672a\u914d\u7f6e\u5206\u7ec4"));
        FeePoolOperationTypeGroupEnum anEnum = FeePoolOperationTypeGroupEnum.getEnum((String)group);
        Assert.notNull((Object)anEnum, (String)("\u64cd\u4f5c\u7c7b\u578b" + operationTypeValue + "\u914d\u7f6e\u7684\u5206\u7ec4\u65e0\u6548"));
        return anEnum;
    }

    public static String getFeePoolAmountDesc() {
        String desc = ParamUtil.getParameterValueNoException("fee_pool_amount_desc");
        if (StringUtils.isEmpty((String)desc)) {
            return "\u91d1\u989d";
        }
        return desc;
    }
}

