/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.util;

import com.biz.crm.activiti.act.TaActBaseFeign;
import com.biz.crm.activiti.common.CallbackFeign;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.config.SpringApplicationContextUtil;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.nebular.activiti.act.req.StartProcessReqVo;
import com.biz.crm.nebular.activiti.vo.ActivitiBusinessVo;
import com.biz.crm.nebular.activiti.vo.AttachmentVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.Result;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ActivityUtils {
    private static final Logger log = LoggerFactory.getLogger(ActivityUtils.class);
    private static TaActBaseFeign actBaseFeign;

    @Autowired
    public void setActBaseFeign(TaActBaseFeign actBaseFeign) {
        ActivityUtils.actBaseFeign = actBaseFeign;
    }

    public static String startProcess(StartProcessReqVo processReqVo) {
        ActivitiBusinessVo activitiBusinessVo = new ActivitiBusinessVo();
        activitiBusinessVo.setProcessKey(processReqVo.getProcessKey());
        activitiBusinessVo.setBusinessId(processReqVo.getFormNo());
        activitiBusinessVo.setBusinessNo(processReqVo.getBusinessCode());
        activitiBusinessVo.setRemark(processReqVo.getRemark());
        activitiBusinessVo.setVariables(processReqVo.getVariables());
        activitiBusinessVo.setCostType(processReqVo.getCostType());
        activitiBusinessVo.setFormType(processReqVo.getFormType());
        activitiBusinessVo.setProcessTitle(processReqVo.getTitle());
        activitiBusinessVo.setKeyTargetListJson(processReqVo.getKeyTargetListJson());
        activitiBusinessVo.setCallBackFeign(processReqVo.getCallBackFeign());
        activitiBusinessVo.setPositionCode(processReqVo.getPosCode());
        if (CollectionUtils.isNotEmpty((Collection)processReqVo.getFileList())) {
            List attachmentVos = processReqVo.getFileList().stream().map(o -> {
                AttachmentVo attachmentVo = new AttachmentVo();
                attachmentVo.setFileName(o.getObjectName());
                attachmentVo.setObjectName(o.getObjectName());
                attachmentVo.setFileAddress(o.getFileAddress());
                return attachmentVo;
            }).collect(Collectors.toList());
            activitiBusinessVo.setAttachmentVos(attachmentVos);
        }
        Result stringResult = actBaseFeign.startProcess(activitiBusinessVo);
        String s = (String)ApiResultUtil.objResult((Result)stringResult, (boolean)true);
        return s;
    }

    public static void processCallBack(ActivitiCallBackVo callBackVo) {
        AssertUtils.isNotEmpty(callBackVo.getCallBackFeign(), "\u56de\u8c03\u65b9\u6cd5\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotNull(callBackVo.getProcessState(), "\u6d41\u7a0b\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty(callBackVo.getFormNo(), "\u4e1a\u52a1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty(callBackVo.getProcessNo(), "\u6d41\u7a0b\u5b9e\u4f8b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        CallbackFeign callbackFeign = null;
        callbackFeign = (CallbackFeign)SpringApplicationContextUtil.getApplicationContext().getBean(callBackVo.getCallBackFeign());
        Result callback = callbackFeign.callback(callBackVo);
        if (!callback.isSuccess()) {
            throw new BusinessException("\u4fee\u6539\u4e1a\u52a1\u7cfb\u7edf\u5355\u636e\u72b6\u6001\u5931\u8d25,\u5931\u8d25\u539f\u56e0:" + callback.getMessage());
        }
    }
}

