/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.util;

import java.beans.FeatureDescriptor;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapperImpl;

public class CrmBeanUtil {
    private static final Logger log = LoggerFactory.getLogger(CrmBeanUtil.class);

    public static void copyProperties(Object source, Object target) {
        if (null == source || null == target) {
            return;
        }
        BeanUtils.copyProperties((Object)source, (Object)target);
    }

    public static void copyPropertiesIgnoreEmpty(Object source, Object target) {
        if (null == source || null == target) {
            return;
        }
        BeanUtils.copyProperties((Object)source, (Object)target, (String[])CrmBeanUtil.getEmptyPropertyNames(source));
    }

    private static String[] getEmptyPropertyNames(Object source) {
        BeanWrapperImpl src = new BeanWrapperImpl(source);
        PropertyDescriptor[] pds = src.getPropertyDescriptors();
        HashSet<String> emptyNames = new HashSet<String>();
        for (PropertyDescriptor pd : pds) {
            Object srcValue = src.getPropertyValue(pd.getName());
            if (srcValue != null && !StringUtils.isBlank((CharSequence)srcValue.toString())) continue;
            emptyNames.add(pd.getName());
        }
        String[] result = new String[emptyNames.size()];
        return emptyNames.toArray(result);
    }

    public static <T> T copy(Object source, Class<T> target) {
        if (source == null) {
            return null;
        }
        try {
            T newInstance = target.newInstance();
            BeanUtils.copyProperties((Object)source, newInstance);
            return newInstance;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T, K> List<K> copyList(List<T> source, Class<K> target) {
        if (null == source || source.isEmpty()) {
            return new ArrayList();
        }
        return source.stream().map(e -> CrmBeanUtil.copy(e, target)).collect(Collectors.toList());
    }

    public static void copyExt10(Object source, Object target) {
        if (source == null || target == null) {
            return;
        }
        HashSet<String> props = new HashSet<String>(16);
        for (int i = 1; i <= 10; ++i) {
            props.add("ext" + i);
        }
        String[] filteredPropertyNames = (String[])Arrays.stream(BeanUtils.getPropertyDescriptors(source.getClass())).map(FeatureDescriptor::getName).filter(item -> !props.contains(item)).toArray(String[]::new);
        if (filteredPropertyNames.length > 0) {
            BeanUtils.copyProperties((Object)source, (Object)target, (String[])filteredPropertyNames);
        }
    }

    public static void copyExt50(Object source, Object target) {
        if (source == null || target == null) {
            return;
        }
        HashSet<String> props = new HashSet<String>(64);
        for (int i = 1; i <= 50; ++i) {
            props.add("ext" + i);
        }
        String[] filteredPropertyNames = (String[])Arrays.stream(BeanUtils.getPropertyDescriptors(source.getClass())).map(FeatureDescriptor::getName).filter(item -> !props.contains(item)).toArray(String[]::new);
        if (filteredPropertyNames.length > 0) {
            BeanUtils.copyProperties((Object)source, (Object)target, (String[])filteredPropertyNames);
        }
    }
}

