/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.util;

import com.biz.crm.util.ComConstant;
import com.biz.crm.util.Result;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.net.ssl.SSLException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.NoHttpResponseException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientUtils {
    private static final Logger log = LoggerFactory.getLogger(HttpClientUtils.class);
    private static final RequestConfig REQUEST_CONFIG_TIME_OUT = RequestConfig.custom().setSocketTimeout(20000).setConnectTimeout(50000).setConnectionRequestTimeout(50000).build();
    private static PoolingHttpClientConnectionManager cm = null;

    @PostConstruct
    public void init() {
        cm = new PoolingHttpClientConnectionManager();
        cm.setMaxTotal(1000);
        cm.setDefaultMaxPerRoute(1000);
    }

    public static CloseableHttpClient getClient(boolean isPooled) {
        HttpRequestRetryHandler retryHandler = new HttpRequestRetryHandler(){

            public boolean retryRequest(IOException e, int retryTimes, HttpContext httpContext) {
                boolean idempotent;
                if (retryTimes > 2) {
                    return false;
                }
                if (e instanceof UnknownHostException || e instanceof ConnectTimeoutException || !(e instanceof SSLException) || e instanceof NoHttpResponseException) {
                    return true;
                }
                HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)httpContext);
                HttpRequest request = clientContext.getRequest();
                boolean bl = idempotent = !(request instanceof HttpEntityEnclosingRequest);
                return idempotent;
            }
        };
        if (isPooled) {
            return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).setRetryHandler(retryHandler).build();
        }
        return HttpClients.createDefault();
    }

    public static final Result doPostWithRequest(String path, HttpServletRequest request) {
        Result result = new Result();
        Enumeration params = request.getParameterNames();
        ArrayList nameValuePairs = Lists.newArrayList();
        while (params.hasMoreElements()) {
            String paramName = (String)params.nextElement();
            nameValuePairs.add(new BasicNameValuePair(paramName, request.getParameter(paramName)));
        }
        HttpPost httpPost = new HttpPost(path);
        httpPost.setConfig(REQUEST_CONFIG_TIME_OUT);
        try {
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity((List)nameValuePairs));
            return HttpClientUtils.execReq(httpPost);
        }
        catch (UnsupportedEncodingException e) {
            log.error("do post error: ", (Throwable)e);
            result.setCode(ComConstant.SC_INTERNAL_SERVER_ERROR_500);
            result.setMessage(e.getMessage());
            return result;
        }
    }

    public static final Result<String> doPost(String path, Map<String, Object> params) {
        Result<String> result = new Result<String>();
        log.debug("doPost from " + path, params);
        HttpPost httpPost = new HttpPost(path);
        httpPost.setConfig(REQUEST_CONFIG_TIME_OUT);
        try {
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(HttpClientUtils.createParams(params)));
            result = HttpClientUtils.execReq(httpPost);
        }
        catch (UnsupportedEncodingException e) {
            log.error(e.getMessage(), (Throwable)e);
            result.setCode(ComConstant.SC_INTERNAL_SERVER_ERROR_500);
            result.setMessage(e.getMessage());
        }
        return result;
    }

    public static final Result<String> doPostWebService(String path, String xml) {
        log.info("\u8bf7\u6c42SAP\u4ea4\u4e92URL:{},XML:{}", (Object)path, (Object)xml);
        HttpPost httpPost = new HttpPost(path);
        httpPost.setConfig(REQUEST_CONFIG_TIME_OUT);
        StringEntity postingString = new StringEntity(xml, StandardCharsets.UTF_8.name());
        httpPost.setEntity((HttpEntity)postingString);
        httpPost.setHeader("Content-Type", "text/xml; charset=utf-8");
        Result<String> bodyAsString = HttpClientUtils.execReq(httpPost);
        log.info("\u8bf7\u6c42SAP\u4ea4\u4e92\u7ed3\u679cPost Result:{}", bodyAsString);
        return bodyAsString;
    }

    private static List<NameValuePair> createParams(Map<String, Object> params) {
        ArrayList nameValuePairs = Lists.newArrayList();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            nameValuePairs.add(new BasicNameValuePair(entry.getKey(), String.valueOf(entry.getValue())));
        }
        return nameValuePairs;
    }

    private static Result<String> execReq(HttpPost httpPost) {
        Result result;
        block8: {
            result = new Result();
            try {
                CloseableHttpResponse response = HttpClientUtils.getClient(true).execute((HttpUriRequest)httpPost);
                if (response != null) {
                    try {
                        if (response.getStatusLine().getStatusCode() == 200) {
                            result.setCode(ComConstant.SC_OK_200);
                            result.setResult((Object)EntityUtils.toString((HttpEntity)response.getEntity()));
                        } else {
                            result.setCode(ComConstant.SC_INTERNAL_SERVER_ERROR_500);
                            result.setMessage("http post request error: " + httpPost.getURI());
                        }
                        break block8;
                    }
                    finally {
                        EntityUtils.consume((HttpEntity)response.getEntity());
                    }
                }
                result.setCode(ComConstant.SC_INTERNAL_SERVER_ERROR_500);
                result.setMessage("http post request error: " + httpPost.getURI());
            }
            catch (IOException e) {
                log.error("doPost error: ", (Throwable)e);
                result.setCode(ComConstant.SC_INTERNAL_SERVER_ERROR_500);
                result.setMessage(e.getMessage());
            }
        }
        result.setCode(ComConstant.SC_INTERNAL_SERVER_ERROR_500);
        result.setMessage("\u672a\u77e5\u9519\u8bef\uff01");
        return result;
    }
}

