/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.util;

import com.biz.crm.base.BusinessException;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.config.TokenRenewalUtil;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.mdm.LoginFromTypeEnum;
import com.biz.crm.mdm.MdmCommonUserFeign;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRespVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserRespVo;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CookiesUtil;
import com.biz.crm.util.HttpServletRequestUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserAutoConfig;
import com.biz.crm.util.UserRedis;
import io.jsonwebtoken.lang.Assert;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class UserUtils {
    private static final Logger log = LoggerFactory.getLogger(UserUtils.class);
    private static UserAutoConfig userAutoConfig;
    private static RedisService redisService;
    private static MdmCommonUserFeign mdmCommonUserFeign;
    private static TokenRenewalUtil tokenRenewalUtil;

    @Autowired
    public void setRedisService(RedisService redisService) {
        UserUtils.redisService = redisService;
    }

    @Autowired
    public void setTokenRenewalUtil(TokenRenewalUtil tokenRenewalUtil) {
        UserUtils.tokenRenewalUtil = tokenRenewalUtil;
    }

    @Autowired
    public void setUserAutoConfig(UserAutoConfig userAutoConfig) {
        UserUtils.userAutoConfig = userAutoConfig;
    }

    @Autowired
    public void setMdmCommonUserFeign(MdmCommonUserFeign mdmCommonUserFeign) {
        UserUtils.mdmCommonUserFeign = mdmCommonUserFeign;
    }

    public static UserRedis getUser() {
        UserRedis user = ThreadLocalUtil.getUser();
        if (user != null && StringUtils.isNotEmpty((String)user.getUsername())) {
            return user;
        }
        UserRedis userRedis = null;
        try {
            String token = UserUtils.getToken();
            if (StringUtils.isEmpty((String)token)) {
                log.info("\u672a\u83b7\u53d6\u767b\u5f55\u7528\u6237token\u4fe1\u606f");
            } else {
                Object o = redisService.get("token:" + token);
                if (o == null) {
                    UserUtils.setUserSeconds(token, null, 10L);
                } else {
                    userRedis = (UserRedis)o;
                    ThreadLocalUtil.setUser((UserRedis)userRedis);
                }
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5f53\u524d\u7528\u6237:", (Throwable)e);
        }
        return userRedis;
    }

    public static String getToken() {
        Cookie cookie;
        String token;
        HttpServletRequest request = HttpServletRequestUtil.getRequest();
        Object tokenLock = ThreadLocalUtil.getObj((String)"loginUserToken");
        String string = token = tokenLock == null ? "" : tokenLock.toString();
        if (StringUtils.isNotEmpty((String)token) || request == null) {
            return token;
        }
        if (request != null && StringUtils.isEmpty((String)(token = request.getHeader("loginUserToken"))) && (cookie = CookiesUtil.getCookieByName((HttpServletRequest)request, (String)"loginUserToken")) != null) {
            token = cookie.getValue();
        }
        return token;
    }

    public static String getToken(String key) {
        return redisService.getAndSet("token:" + key);
    }

    public static void setToken(String token) {
        ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>();
        map.put("loginUserToken", token);
        ThreadLocalUtil.stObj(map);
    }

    public static void doTokenForNull() {
        if (StringUtils.isEmpty((String)userAutoConfig.getUsername())) {
            return;
        }
        try {
            ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>();
            String token = UUID.randomUUID().toString().replaceAll("-", "");
            map.put("loginUserToken", token);
            ThreadLocalUtil.stObj(map);
            UserUtils.createUserToRedis(token, userAutoConfig.getUsername(), LoginFromTypeEnum.TEMPORARY.getValue(), 3600L);
        }
        catch (Exception e) {
            log.error("\u9ed8\u8ba4\u8bbe\u7f6e\u6743\u9650\u9519\u8bef", (Throwable)e);
        }
    }

    public static void doTokenForUserName(String userName2, long seconds) {
        String token = UUID.randomUUID().toString().replaceAll("-", "");
        UserUtils.createUserToRedis(token, userName2, LoginFromTypeEnum.TEMPORARY.getValue(), seconds);
    }

    public static void setUser(String token, UserRedis userRedis) {
        Assert.hasText((String)token, (String)"token\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)userRedis, (String)"userRedis\u4e0d\u80fd\u4e3a\u7a7a");
        String username = userRedis.getUsername();
        String fromtype = userRedis.getFromtype();
        Assert.hasText((String)username, (String)"\u7528\u6237\u5e10\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)fromtype, (String)"\u767b\u5f55\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        UserUtils.setUserGroupSeconds(token, username, fromtype, 86400L);
        UserUtils.setDaysUser(token, userRedis);
    }

    @Deprecated
    public static void setUser(String token, String userName2) {
        Assert.hasText((String)token, (String)"token\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)userName2, (String)"\u7528\u6237\u5e10\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        UserRedis userRedis = new UserRedis();
        userRedis.setUsername(userName2);
        UserUtils.setDaysUser(token, userRedis);
        Result detail = mdmCommonUserFeign.detail(null, userName2);
        MdmUserRespVo mdmUserRespVo = Optional.ofNullable(detail).map(Result::getResult).orElseThrow(() -> new BusinessException("\u672a\u67e5\u8be2\u5230\u7528\u6237:" + userName2));
        userRedis.setRealname(mdmUserRespVo.getFullName());
        userRedis.setPoscode(mdmUserRespVo.getPositionCode());
        userRedis.setPosname(mdmUserRespVo.getPositionName());
        userRedis.setOrgname(mdmUserRespVo.getOrgName());
        userRedis.setOrgcode(mdmUserRespVo.getOrgCode());
        userRedis.setFromtype(LoginFromTypeEnum.TEMPORARY.getValue());
        UserUtils.setDaysUser(token, userRedis);
    }

    public static void setUser(String token, String userName2, String fromtype) {
        Assert.hasText((String)token, (String)"token\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)userName2, (String)"\u7528\u6237\u5e10\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        UserRedis userRedis = new UserRedis();
        userRedis.setUsername(userName2);
        UserUtils.setDaysUser(token, userRedis);
        Result detail = mdmCommonUserFeign.detail(null, userName2);
        MdmUserRespVo mdmUserRespVo = Optional.ofNullable(detail).map(Result::getResult).orElseThrow(() -> new BusinessException("\u672a\u67e5\u8be2\u5230\u7528\u6237:" + userName2));
        userRedis.setRealname(mdmUserRespVo.getFullName());
        userRedis.setPoscode(mdmUserRespVo.getPositionCode());
        userRedis.setPosname(mdmUserRespVo.getPositionName());
        userRedis.setOrgname(mdmUserRespVo.getOrgName());
        userRedis.setOrgcode(mdmUserRespVo.getOrgCode());
        userRedis.setFromtype(StringUtils.isNotEmpty((String)fromtype) ? fromtype : LoginFromTypeEnum.UNKNOWN.getValue());
        UserUtils.setDaysUser(token, userRedis);
    }

    public static UserRedis createUserToRedis(String token, String userName2, String fromtype, long seconds) {
        UserRedis userRedis = null;
        Assert.hasText((String)userName2, (String)"userName\u4e0d\u80fd\u4e3a\u7a7a");
        try {
            ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>();
            map.put("loginUserToken", token);
            ThreadLocalUtil.stObj(map);
            userRedis = new UserRedis();
            userRedis.setUsername(userName2);
            UserUtils.setUserSeconds(token, userRedis, seconds);
            Result detail = mdmCommonUserFeign.detail(null, userName2);
            MdmUserRespVo mdmUserRespVo = Optional.ofNullable(detail).map(Result::getResult).orElseThrow(() -> new BusinessException("\u672a\u67e5\u8be2\u5230\u7528\u6237:" + userName2));
            userRedis.setRealname(mdmUserRespVo.getFullName());
            MdmPositionRespVo mdmPositionRespVo = mdmUserRespVo.getPositionList().stream().filter(o -> YesNoEnum.yesNoEnum.ONE.getValue().equals(o.getPrimaryFlag())).findFirst().orElse(null);
            userRedis.setPoscode(mdmPositionRespVo.getPositionCode());
            userRedis.setPosname(mdmPositionRespVo.getPositionName());
            userRedis.setOrgname(mdmPositionRespVo.getOrgName());
            userRedis.setOrgcode(mdmPositionRespVo.getOrgCode());
            userRedis.setUsertype(mdmUserRespVo.getUserType());
            userRedis.setFromtype(StringUtils.isNotEmpty((String)fromtype) ? fromtype : LoginFromTypeEnum.UNKNOWN.getValue());
            UserUtils.setUserSeconds(token, userRedis, seconds);
            UserUtils.setUserGroupSeconds(token, userName2, fromtype, seconds);
        }
        catch (Exception e) {
            log.error("\u9ed8\u8ba4\u8bbe\u7f6e\u6743\u9650\u9519\u8bef", (Throwable)e);
        }
        return userRedis;
    }

    public static UserRedis createUserToRedis(String token, String userName2, String posCode, String fromtype, long seconds) {
        UserRedis userRedis = null;
        Assert.hasText((String)userName2, (String)"userName\u4e0d\u80fd\u4e3a\u7a7a");
        try {
            ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>();
            map.put("loginUserToken", token);
            ThreadLocalUtil.stObj(map);
            userRedis = new UserRedis();
            userRedis.setUsername(userName2);
            UserUtils.setUserSeconds(token, userRedis, seconds);
            Result detail = mdmCommonUserFeign.detail(null, userName2);
            MdmUserRespVo mdmUserRespVo = Optional.ofNullable(detail).map(Result::getResult).orElseThrow(() -> new BusinessException("\u672a\u67e5\u8be2\u5230\u7528\u6237:" + userName2));
            userRedis.setRealname(mdmUserRespVo.getFullName());
            MdmPositionRespVo mdmPositionRespVo = mdmUserRespVo.getPositionList().stream().filter(o -> posCode.equals(o.getPositionCode())).findFirst().orElse(null);
            userRedis.setPoscode(mdmPositionRespVo.getPositionCode());
            userRedis.setPosname(mdmPositionRespVo.getPositionName());
            userRedis.setOrgname(mdmPositionRespVo.getOrgName());
            userRedis.setOrgcode(mdmPositionRespVo.getOrgCode());
            userRedis.setUsertype(mdmUserRespVo.getUserType());
            userRedis.setFromtype(StringUtils.isNotEmpty((String)fromtype) ? fromtype : LoginFromTypeEnum.UNKNOWN.getValue());
            UserUtils.setUserSeconds(token, userRedis, seconds);
            UserUtils.setUserGroupSeconds(token, userName2, fromtype, seconds);
        }
        catch (Exception e) {
            log.error("\u9ed8\u8ba4\u8bbe\u7f6e\u6743\u9650\u9519\u8bef", (Throwable)e);
        }
        return userRedis;
    }

    public static void setUserToRedis(String token, UserRedis userRedis, String fromtype, long seconds) {
        Assert.hasText((String)token, (String)"token\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)userRedis, (String)"userRedis\u4e0d\u80fd\u4e3a\u7a7a");
        fromtype = StringUtils.isNotEmpty((String)fromtype) ? fromtype : LoginFromTypeEnum.UNKNOWN.getValue();
        String username = userRedis.getUsername();
        Assert.hasText((String)username, (String)"\u7528\u6237\u5e10\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        userRedis.setFromtype(fromtype);
        UserUtils.setUserGroupSeconds(token, username, fromtype, seconds);
        UserUtils.setUserSeconds(token, userRedis, seconds);
    }

    protected static void setDaysUser(String token, UserRedis userRedis) {
        UserUtils.setUserSeconds(token, userRedis, tokenRenewalUtil.getTokenTime());
    }

    private static void setUserSeconds(String token, UserRedis userRedis, long seconds) {
        redisService.setSeconds("token:" + token, (Object)userRedis, seconds);
        tokenRenewalUtil.login(token, seconds);
    }

    private static void setUserGroupSeconds(String token, String userName2, String fromtype, long seconds) {
        long currentTimeMillis = System.currentTimeMillis();
        redisService.hset("user_group_0324:" + userName2 + ":" + fromtype, token, (Object)(currentTimeMillis + 1000L * seconds), seconds);
    }

    protected static void deleteToken(String token) {
        Object o;
        if (StringUtils.isNotEmpty((String)token) && (o = redisService.get("token:" + token)) != null) {
            redisService.del(new String[]{"token:" + token});
            tokenRenewalUtil.loginOut(token);
            UserRedis userRedis = (UserRedis)o;
            if (StringUtils.isNotEmpty((String)userRedis.getUsername()) && StringUtils.isNotEmpty((String)userRedis.getFromtype())) {
                Map hmget = redisService.hmget("user_group_0324:" + userRedis.getUsername() + ":" + userRedis.getFromtype());
                HashSet<String> groupTokenSet = new HashSet<String>(16);
                if (hmget != null) {
                    long currentTimeMillis = System.currentTimeMillis();
                    Map map = hmget;
                    groupTokenSet.addAll(map.entrySet().stream().filter(entry -> (Long)entry.getValue() < currentTimeMillis).map(Map.Entry::getKey).collect(Collectors.toSet()));
                }
                groupTokenSet.add(token);
                redisService.hdel("user_group_0324:" + userRedis.getUsername() + ":" + userRedis.getFromtype(), groupTokenSet.toArray());
            }
        }
    }

    @Deprecated
    protected static void deleteToken(Set<String> tokens) {
        if (!tokens.isEmpty()) {
            tokens.forEach(token -> {
                Object o = redisService.get("token:" + token);
                if (o != null) {
                    redisService.del(new String[]{"token:" + token});
                    UserRedis userRedis = (UserRedis)o;
                    if (StringUtils.isNotEmpty((String)userRedis.getUsername()) && StringUtils.isNotEmpty((String)userRedis.getFromtype())) {
                        Map hmget = redisService.hmget("user_group_0324:" + userRedis.getUsername() + ":" + userRedis.getFromtype());
                        HashSet<String> groupTokenSet = new HashSet<String>(16);
                        if (hmget != null) {
                            long currentTimeMillis = System.currentTimeMillis();
                            Map map = hmget;
                            groupTokenSet.addAll(map.entrySet().stream().filter(entry -> (Long)entry.getValue() < currentTimeMillis).map(Map.Entry::getKey).collect(Collectors.toSet()));
                        }
                        groupTokenSet.add((String)token);
                        redisService.hdel("user_group_0324:" + userRedis.getUsername() + ":" + userRedis.getFromtype(), groupTokenSet.toArray());
                    }
                }
            });
        }
    }

    public static void deleteUser(String username) {
        UserUtils.deleteUser(Collections.singletonList(username));
    }

    public static void deleteUser(String username, List<String> fromtypeList) {
        if (StringUtils.isEmpty((String)username)) {
            return;
        }
        if (CollectionUtil.listEmpty(fromtypeList)) {
            return;
        }
        UserUtils.deleteUser(Collections.singletonList(username), fromtypeList);
    }

    public static void deleteUser(List<String> usernameList) {
        if (CollectionUtils.isEmpty(usernameList)) {
            return;
        }
        ArrayList<String> fromTypeList = new ArrayList<String>();
        for (LoginFromTypeEnum loginFromTypeEnum : LoginFromTypeEnum.values()) {
            fromTypeList.add(loginFromTypeEnum.getValue());
        }
        UserUtils.deleteUser(usernameList, fromTypeList);
    }

    public static void deleteUser(List<String> usernameList, List<String> fromtypeList) {
        if (CollectionUtil.listEmpty(usernameList)) {
            return;
        }
        if (CollectionUtil.listEmpty(fromtypeList)) {
            return;
        }
        HashSet tokenSet = new HashSet(16);
        HashSet<String> userGroupHashKeySet = new HashSet<String>(16);
        for (String username : usernameList) {
            for (String fromType : fromtypeList) {
                String hashKey = "user_group_0324:" + username + ":" + fromType;
                Map hmget = redisService.hmget(hashKey);
                if (hmget == null) continue;
                Set objects = hmget.keySet();
                tokenSet.addAll(objects);
                userGroupHashKeySet.add(hashKey);
            }
        }
        if (!tokenSet.isEmpty()) {
            redisService.del((String[])tokenSet.stream().map(x -> "token:" + x).toArray(String[]::new));
            for (String token : tokenSet) {
                tokenRenewalUtil.loginOut(token);
            }
            redisService.del(userGroupHashKeySet.toArray(new String[userGroupHashKeySet.size()]));
        }
    }

    public static void remove() {
        String username = Optional.ofNullable(UserUtils.getUser()).map(UserRedis::getUsername).orElse(null);
        if (!StringUtils.isEmpty((String)username)) {
            UserUtils.deleteUser(username);
        }
    }

    public static void logout() {
        String token = UserUtils.getToken();
        UserUtils.deleteToken(token);
    }

    public static void logout(String fromtype) {
        String username = Optional.ofNullable(UserUtils.getUser()).map(UserRedis::getUsername).orElse(null);
        UserUtils.deleteUser(username, Collections.singletonList(fromtype));
    }

    public static List<String> handleOrgCodes(String orgCode) {
        if (StringUtils.isEmpty((String)orgCode)) {
            return null;
        }
        return Arrays.asList(orgCode.split(","));
    }
}

