/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.util;

import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.mdm.org.MdmOrgRedisFeign;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgParentChildrenRedisVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRedisVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgReloadRedisVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.Result;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OrgUtil {
    private static final Logger log = LoggerFactory.getLogger(OrgUtil.class);
    private static RedisService redisService;
    private static MdmOrgRedisFeign mdmOrgRedisFeign;

    @Autowired
    public void setRedisService(RedisService redis) {
        redisService = redis;
    }

    @Autowired
    public void setMdmDictFeign(MdmOrgRedisFeign orgRedisFeign) {
        mdmOrgRedisFeign = orgRedisFeign;
    }

    public static MdmOrgRespVo getOrgByCode(String orgCode) {
        Map<String, MdmOrgRedisVo> orgRedisMap;
        if (orgCode != null && !"".equals(orgCode) && (orgRedisMap = OrgUtil.getOrgSelfRedisMapFromLocalFirst(Collections.singletonList(orgCode))).containsKey(orgCode)) {
            MdmOrgRedisVo mdmOrgRedisVo = orgRedisMap.get(orgCode);
            return CrmBeanUtil.copy(mdmOrgRedisVo, MdmOrgRespVo.class);
        }
        return null;
    }

    public static MdmOrgRespVo getTopParentOrgByCode(String orgCode) {
        List<MdmOrgRespVo> parentOrgListIncludeSelf;
        if (orgCode != null && !"".equals(orgCode) && (parentOrgListIncludeSelf = OrgUtil.getParentOrgListIncludeSelf(orgCode)) != null && parentOrgListIncludeSelf.size() > 0) {
            for (MdmOrgRespVo item : parentOrgListIncludeSelf) {
                if (item.getLevelNum() != 1 && item.getParentCode() != null && !"".equals(item.getParentCode())) continue;
                return item;
            }
        }
        return null;
    }

    public static List<MdmOrgRespVo> getOrgByCodeList(List<String> orgCodeList) {
        Map<String, MdmOrgRedisVo> orgRedisMap;
        ArrayList<MdmOrgRespVo> list = new ArrayList<MdmOrgRespVo>();
        if (orgCodeList != null && orgCodeList.size() > 0 && !(orgRedisMap = OrgUtil.getOrgSelfRedisMapFromLocalFirst(orgCodeList)).isEmpty()) {
            list.addAll(orgRedisMap.values().stream().map(item -> CrmBeanUtil.copy(item, MdmOrgRespVo.class)).collect(Collectors.toList()));
        }
        return list;
    }

    public static List<MdmOrgRespVo> getParentOrgListIncludeSelf(String orgCode) {
        List list;
        MdmOrgParentChildrenRedisVo redisVo;
        Map<String, MdmOrgParentChildrenRedisVo> map;
        if (orgCode != null && !"".equals(orgCode) && !(map = OrgUtil.getOrgParentRedisMapFromLocalFirst(Collections.singletonList(orgCode))).isEmpty() && (redisVo = map.get(orgCode)) != null && (list = redisVo.getList()) != null && list.size() > 0) {
            return CrmBeanUtil.copyList(list, MdmOrgRespVo.class);
        }
        return new ArrayList<MdmOrgRespVo>();
    }

    public static List<MdmOrgRespVo> getParentOrgListIncludeSelf(List<String> orgCodeList) {
        if (orgCodeList != null && orgCodeList.size() > 0) {
            Map<String, MdmOrgParentChildrenRedisVo> map = OrgUtil.getOrgParentRedisMapFromLocalFirst(orgCodeList);
            HashSet set = new HashSet(16);
            if (!map.isEmpty()) {
                for (String orgCode : orgCodeList) {
                    MdmOrgParentChildrenRedisVo redisVo;
                    if (!map.containsKey(orgCode) || (redisVo = map.get(orgCode)) == null || redisVo.getList() == null || redisVo.getList().size() <= 0) continue;
                    set.addAll(redisVo.getList());
                }
                if (!set.isEmpty()) {
                    return CrmBeanUtil.copyList(new ArrayList(set), MdmOrgRespVo.class);
                }
            }
        }
        return new ArrayList<MdmOrgRespVo>();
    }

    public static Map<String, List<MdmOrgRespVo>> getParentOrgMapIncludeSelf(List<String> orgCodeList) {
        return Optional.of(OrgUtil.getOrgParentRedisMapFromLocalFirst(orgCodeList)).map(Map::values).map(k -> k.stream().collect(Collectors.toMap(MdmOrgParentChildrenRedisVo::getOrgCode, x -> CrmBeanUtil.copyList(x.getList(), MdmOrgRespVo.class)))).orElse(new HashMap());
    }

    public static List<MdmOrgRespVo> getParentOrgListExcludeSelf(String orgCode) {
        List<MdmOrgRespVo> parentOrgListIncludeSelf;
        if (orgCode != null && !"".equals(orgCode) && (parentOrgListIncludeSelf = OrgUtil.getParentOrgListIncludeSelf(orgCode)) != null && parentOrgListIncludeSelf.size() > 0) {
            return parentOrgListIncludeSelf.stream().filter(item -> !orgCode.equals(item.getOrgCode())).collect(Collectors.toList());
        }
        return new ArrayList<MdmOrgRespVo>();
    }

    public static List<MdmOrgRespVo> getParentOrgListExcludeSelf(List<String> orgCodeList) {
        if (orgCodeList != null && orgCodeList.size() > 0) {
            Map<String, MdmOrgParentChildrenRedisVo> map = OrgUtil.getOrgParentRedisMapFromLocalFirst(orgCodeList);
            HashSet set = new HashSet(16);
            if (!map.isEmpty()) {
                for (String orgCode : orgCodeList) {
                    MdmOrgParentChildrenRedisVo redisVo;
                    if (!map.containsKey(orgCode) || (redisVo = map.get(orgCode)) == null || redisVo.getList() == null || redisVo.getList().size() <= 0) continue;
                    set.addAll(redisVo.getList().stream().filter(item -> !orgCode.equals(item.getOrgCode())).collect(Collectors.toSet()));
                }
                if (!set.isEmpty()) {
                    return CrmBeanUtil.copyList(new ArrayList(set), MdmOrgRespVo.class);
                }
            }
        }
        return new ArrayList<MdmOrgRespVo>();
    }

    public static List<MdmOrgRespVo> getParentOrgListExcludeAnySelf(List<String> orgCodeList) {
        List<MdmOrgRespVo> parentOrgListExcludeSelf;
        if (orgCodeList != null && orgCodeList.size() > 0 && (parentOrgListExcludeSelf = OrgUtil.getParentOrgListExcludeSelf(orgCodeList)) != null && parentOrgListExcludeSelf.size() > 0) {
            HashSet<String> orgCodeSet = new HashSet<String>(orgCodeList);
            return parentOrgListExcludeSelf.stream().filter(item -> !orgCodeSet.contains(item.getOrgCode())).collect(Collectors.toList());
        }
        return new ArrayList<MdmOrgRespVo>();
    }

    public static List<MdmOrgRespVo> getChildrenOrgListIncludeSelf(String orgCode) {
        List list;
        MdmOrgParentChildrenRedisVo redisVo;
        Map<String, MdmOrgParentChildrenRedisVo> map;
        if (orgCode != null && !"".equals(orgCode) && !(map = OrgUtil.getOrgChildrenRedisMapFromLocalFirst(Collections.singletonList(orgCode))).isEmpty() && (redisVo = map.get(orgCode)) != null && (list = redisVo.getList()) != null && list.size() > 0) {
            return CrmBeanUtil.copyList(list, MdmOrgRespVo.class);
        }
        return new ArrayList<MdmOrgRespVo>();
    }

    public static List<MdmOrgRespVo> getChildrenOrgListIncludeSelf(List<String> orgCodeList) {
        if (orgCodeList != null && orgCodeList.size() > 0) {
            Map<String, MdmOrgParentChildrenRedisVo> map = OrgUtil.getOrgChildrenRedisMapFromLocalFirst(orgCodeList);
            HashSet set = new HashSet(16);
            if (!map.isEmpty()) {
                for (String orgCode : orgCodeList) {
                    MdmOrgParentChildrenRedisVo redisVo;
                    if (!map.containsKey(orgCode) || (redisVo = map.get(orgCode)) == null || redisVo.getList() == null || redisVo.getList().size() <= 0) continue;
                    set.addAll(redisVo.getList());
                }
                if (!set.isEmpty()) {
                    return CrmBeanUtil.copyList(new ArrayList(set), MdmOrgRespVo.class);
                }
            }
        }
        return new ArrayList<MdmOrgRespVo>();
    }

    public static List<MdmOrgRespVo> getChildrenOrgListExcludeSelf(String orgCode) {
        List<MdmOrgRespVo> parentOrgListIncludeSelf;
        if (orgCode != null && !"".equals(orgCode) && (parentOrgListIncludeSelf = OrgUtil.getChildrenOrgListIncludeSelf(orgCode)) != null && parentOrgListIncludeSelf.size() > 0) {
            return parentOrgListIncludeSelf.stream().filter(item -> !orgCode.equals(item.getOrgCode())).collect(Collectors.toList());
        }
        return new ArrayList<MdmOrgRespVo>();
    }

    public static List<MdmOrgRespVo> getChildrenOrgListExcludeSelf(List<String> orgCodeList) {
        if (orgCodeList != null && orgCodeList.size() > 0) {
            Map<String, MdmOrgParentChildrenRedisVo> map = OrgUtil.getOrgChildrenRedisMapFromLocalFirst(orgCodeList);
            HashSet set = new HashSet(16);
            if (!map.isEmpty()) {
                for (String orgCode : orgCodeList) {
                    MdmOrgParentChildrenRedisVo redisVo;
                    if (!map.containsKey(orgCode) || (redisVo = map.get(orgCode)) == null || redisVo.getList() == null || redisVo.getList().size() <= 0) continue;
                    set.addAll(redisVo.getList().stream().filter(item -> !orgCode.equals(item.getOrgCode())).collect(Collectors.toSet()));
                }
                if (!set.isEmpty()) {
                    return CrmBeanUtil.copyList(new ArrayList(set), MdmOrgRespVo.class);
                }
            }
        }
        return new ArrayList<MdmOrgRespVo>();
    }

    public static List<MdmOrgRespVo> getChildrenOrgListExcludeAnySelf(List<String> orgCodeList) {
        List<MdmOrgRespVo> parentOrgListExcludeSelf;
        if (orgCodeList != null && orgCodeList.size() > 0 && (parentOrgListExcludeSelf = OrgUtil.getChildrenOrgListExcludeSelf(orgCodeList)) != null && parentOrgListExcludeSelf.size() > 0) {
            HashSet<String> orgCodeSet = new HashSet<String>(orgCodeList);
            return parentOrgListExcludeSelf.stream().filter(item -> !orgCodeSet.contains(item.getOrgCode())).collect(Collectors.toList());
        }
        return new ArrayList<MdmOrgRespVo>();
    }

    public static List<MdmOrgRespVo> getParentOrgListIncludeSelfEnable(String orgCode) {
        return OrgUtil.getParentOrgListIncludeSelf(orgCode).stream().filter(item -> CrmEnableStatusEnum.ENABLE.getCode().equals(item.getEnableStatus())).collect(Collectors.toList());
    }

    public static List<MdmOrgRespVo> getParentOrgListIncludeSelfEnable(List<String> orgCodeList) {
        return OrgUtil.getParentOrgListIncludeSelf(orgCodeList).stream().filter(item -> CrmEnableStatusEnum.ENABLE.getCode().equals(item.getEnableStatus())).collect(Collectors.toList());
    }

    public static List<MdmOrgRespVo> getParentOrgListExcludeSelfEnable(String orgCode) {
        return OrgUtil.getParentOrgListExcludeSelf(orgCode).stream().filter(item -> CrmEnableStatusEnum.ENABLE.getCode().equals(item.getEnableStatus())).collect(Collectors.toList());
    }

    public static List<MdmOrgRespVo> getParentOrgListExcludeSelfEnable(List<String> orgCodeList) {
        return OrgUtil.getParentOrgListExcludeSelf(orgCodeList).stream().filter(item -> CrmEnableStatusEnum.ENABLE.getCode().equals(item.getEnableStatus())).collect(Collectors.toList());
    }

    public static List<MdmOrgRespVo> getParentOrgListExcludeAnySelfEnable(List<String> orgCodeList) {
        return OrgUtil.getParentOrgListExcludeAnySelf(orgCodeList).stream().filter(item -> CrmEnableStatusEnum.ENABLE.getCode().equals(item.getEnableStatus())).collect(Collectors.toList());
    }

    public static List<MdmOrgRespVo> getChildrenOrgListIncludeSelfEnable(String orgCode) {
        return OrgUtil.getChildrenOrgListIncludeSelf(orgCode).stream().filter(item -> CrmEnableStatusEnum.ENABLE.getCode().equals(item.getEnableStatus())).collect(Collectors.toList());
    }

    public static List<MdmOrgRespVo> getChildrenOrgListIncludeSelfEnable(List<String> orgCodeList) {
        return OrgUtil.getChildrenOrgListIncludeSelf(orgCodeList).stream().filter(item -> CrmEnableStatusEnum.ENABLE.getCode().equals(item.getEnableStatus())).collect(Collectors.toList());
    }

    public static List<MdmOrgRespVo> getChildrenOrgListExcludeSelfEnable(String orgCode) {
        return OrgUtil.getChildrenOrgListExcludeSelf(orgCode).stream().filter(item -> CrmEnableStatusEnum.ENABLE.getCode().equals(item.getEnableStatus())).collect(Collectors.toList());
    }

    public static List<MdmOrgRespVo> getChildrenOrgListExcludeSelfEnable(List<String> orgCodeList) {
        return OrgUtil.getChildrenOrgListExcludeSelf(orgCodeList).stream().filter(item -> CrmEnableStatusEnum.ENABLE.getCode().equals(item.getEnableStatus())).collect(Collectors.toList());
    }

    public static List<MdmOrgRespVo> getChildrenOrgListExcludeAnySelfEnable(List<String> orgCodeList) {
        return OrgUtil.getChildrenOrgListExcludeAnySelf(orgCodeList).stream().filter(item -> CrmEnableStatusEnum.ENABLE.getCode().equals(item.getEnableStatus())).collect(Collectors.toList());
    }

    public static List<String> getParentOrgCodeListIncludeSelf(String orgCode) {
        return OrgUtil.getParentOrgListIncludeSelf(orgCode).stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
    }

    public static List<String> getParentOrgCodeListIncludeSelf(List<String> orgCodeList) {
        return OrgUtil.getParentOrgListIncludeSelf(orgCodeList).stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
    }

    public static List<String> getParentOrgCodeListExcludeSelf(String orgCode) {
        return OrgUtil.getParentOrgListExcludeSelf(orgCode).stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
    }

    public static List<String> getParentOrgCodeListExcludeSelf(List<String> orgCodeList) {
        return OrgUtil.getParentOrgListExcludeSelf(orgCodeList).stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
    }

    public static List<String> getParentOrgCodeListExcludeAnySelf(List<String> orgCodeList) {
        return OrgUtil.getParentOrgListExcludeAnySelf(orgCodeList).stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
    }

    public static List<String> getChildrenOrgCodeListIncludeSelf(String orgCode) {
        return OrgUtil.getChildrenOrgListIncludeSelf(orgCode).stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
    }

    public static List<String> getChildrenOrgCodeListIncludeSelf(List<String> orgCodeList) {
        return OrgUtil.getChildrenOrgListIncludeSelf(orgCodeList).stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
    }

    public static List<String> getChildrenOrgCodeListExcludeSelf(String orgCode) {
        return OrgUtil.getChildrenOrgListExcludeSelf(orgCode).stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
    }

    public static List<String> getChildrenOrgCodeListExcludeSelf(List<String> orgCodeList) {
        return OrgUtil.getChildrenOrgListExcludeSelf(orgCodeList).stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
    }

    public static List<String> getChildrenOrgCodeListExcludeAnySelf(List<String> orgCodeList) {
        return OrgUtil.getChildrenOrgListExcludeAnySelf(orgCodeList).stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
    }

    public static List<String> getParentOrgCodeListIncludeSelfEnable(String orgCode) {
        return OrgUtil.getParentOrgListIncludeSelfEnable(orgCode).stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
    }

    public static List<String> getParentOrgCodeListIncludeSelfEnable(List<String> orgCodeList) {
        return OrgUtil.getParentOrgListIncludeSelfEnable(orgCodeList).stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
    }

    public static List<String> getParentOrgCodeListExcludeSelfEnable(String orgCode) {
        return OrgUtil.getParentOrgListExcludeSelfEnable(orgCode).stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
    }

    public static List<String> getParentOrgCodeListExcludeSelfEnable(List<String> orgCodeList) {
        return OrgUtil.getParentOrgListExcludeSelfEnable(orgCodeList).stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
    }

    public static List<String> getParentOrgCodeListExcludeAnySelfEnable(List<String> orgCodeList) {
        return OrgUtil.getParentOrgListExcludeAnySelfEnable(orgCodeList).stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
    }

    public static List<String> getChildrenOrgCodeListIncludeSelfEnable(String orgCode) {
        return OrgUtil.getChildrenOrgListIncludeSelfEnable(orgCode).stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
    }

    public static List<String> getChildrenOrgCodeListIncludeSelfEnable(List<String> orgCodeList) {
        return OrgUtil.getChildrenOrgListIncludeSelfEnable(orgCodeList).stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
    }

    public static List<String> getChildrenOrgCodeListExcludeSelfEnable(String orgCode) {
        return OrgUtil.getChildrenOrgListExcludeSelfEnable(orgCode).stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
    }

    public static List<String> getChildrenOrgCodeListExcludeSelfEnable(List<String> orgCodeList) {
        return OrgUtil.getChildrenOrgListExcludeSelfEnable(orgCodeList).stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
    }

    public static List<String> getChildrenOrgCodeListExcludeAnySelfEnable(List<String> orgCodeList) {
        return OrgUtil.getChildrenOrgListExcludeAnySelfEnable(orgCodeList).stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
    }

    public static void deleteAllCache() {
        redisService.del(new String[]{"MDM_ORG_LOCK_HASH_0112:"});
        redisService.del(new String[]{"MDM_ORG_SELF_HASH_0112:"});
        redisService.del(new String[]{"MDM_ORG_PARENT_HASH_0112:"});
        redisService.del(new String[]{"MDM_ORG_CHILDREN_HASH_0112:"});
        ThreadLocalUtil.delOrg();
    }

    public static void reloadAllCache() {
        List list;
        OrgUtil.deleteAllCache();
        Result result = mdmOrgRedisFeign.findRedisReloadList();
        if (result.isSuccess() && (list = (List)result.getResult()) != null && list.size() > 0) {
            List partition = Lists.partition((List)list, (int)500);
            for (List item : partition) {
                Map<String, MdmOrgRedisVo> selfMap = item.stream().collect(Collectors.toMap(MdmOrgReloadRedisVo::getOrgCode, MdmOrgReloadRedisVo::getSelf));
                Map<String, List> parentMap = item.stream().collect(Collectors.toMap(MdmOrgReloadRedisVo::getOrgCode, MdmOrgReloadRedisVo::getParentList));
                Map<String, List> childrenMap = item.stream().collect(Collectors.toMap(MdmOrgReloadRedisVo::getOrgCode, MdmOrgReloadRedisVo::getChildrenList));
                redisService.hmset("MDM_ORG_SELF_HASH_0112:", new HashMap<String, MdmOrgRedisVo>(selfMap));
                redisService.hmset("MDM_ORG_PARENT_HASH_0112:", new HashMap<String, List>(parentMap));
                redisService.hmset("MDM_ORG_CHILDREN_HASH_0112:", new HashMap<String, List>(childrenMap));
            }
        }
    }

    private static Map<String, MdmOrgRedisVo> getOrgSelfRedisMapFromLocalFirst(List<String> orgCodeList) {
        HashMap<String, MdmOrgRedisVo> map = new HashMap<String, MdmOrgRedisVo>(16);
        try {
            if (orgCodeList != null && orgCodeList.size() > 0) {
                HashSet<String> getFromRedisCodeSet = new HashSet<String>(16);
                for (String orgCode : orgCodeList) {
                    if (ThreadLocalUtil.orgSelfContains((String)orgCode)) {
                        MdmOrgRedisVo fromOrgSelf = ThreadLocalUtil.getFromOrgSelf((String)orgCode);
                        map.put(orgCode, fromOrgSelf);
                        continue;
                    }
                    getFromRedisCodeSet.add(orgCode);
                }
                if (!getFromRedisCodeSet.isEmpty()) {
                    Map<String, MdmOrgRedisVo> mapFromRedisFirst = OrgUtil.getOrgSelfRedisMapFromRedisFirst(new ArrayList<String>(orgCodeList));
                    for (String orgCode : getFromRedisCodeSet) {
                        if (mapFromRedisFirst.containsKey(orgCode)) {
                            map.put(orgCode, mapFromRedisFirst.get(orgCode));
                        }
                        ThreadLocalUtil.addToOrgSelf((String)orgCode, (MdmOrgRedisVo)mapFromRedisFirst.get(orgCode));
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("\u7ec4\u7ec7\u67e5\u8be2\u5de5\u5177\u7c7b\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
        return map;
    }

    private static Map<String, MdmOrgRedisVo> getOrgSelfRedisMapFromRedisFirst(List<String> orgCodeList) {
        HashMap<String, MdmOrgRedisVo> map = new HashMap<String, MdmOrgRedisVo>(16);
        try {
            if (orgCodeList != null && orgCodeList.size() > 0) {
                Result result;
                Set getByFeignCodeSet;
                List collect;
                List orgListFromRedis;
                ArrayList<Object> redisVoList = new ArrayList<Object>();
                HashSet lockCodeList = new HashSet(16);
                List lockListFromHash = redisService.hmget("MDM_ORG_LOCK_HASH_0112:", new HashSet<String>(orgCodeList));
                if (lockListFromHash != null && lockListFromHash.size() > 0) {
                    lockCodeList.addAll(lockListFromHash.stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.toSet()));
                }
                Set notLockGetFromRedisCodeSet = orgCodeList.stream().filter(item -> !lockCodeList.contains(item)).collect(Collectors.toSet());
                HashSet redisHasCodeSet = new HashSet(16);
                if (!notLockGetFromRedisCodeSet.isEmpty() && (orgListFromRedis = redisService.hmget("MDM_ORG_SELF_HASH_0112:", new HashSet(notLockGetFromRedisCodeSet))) != null && orgListFromRedis.size() > 0 && (collect = orgListFromRedis.stream().filter(Objects::nonNull).map(item -> CrmBeanUtil.copy(item, MdmOrgRedisVo.class)).collect(Collectors.toList())).size() > 0) {
                    redisVoList.addAll(collect);
                    redisHasCodeSet.addAll(collect.stream().map(MdmOrgRedisVo::getOrgCode).collect(Collectors.toSet()));
                }
                if (!(getByFeignCodeSet = notLockGetFromRedisCodeSet.stream().filter(item -> !redisHasCodeSet.contains(item)).collect(Collectors.toSet())).isEmpty() && (result = mdmOrgRedisFeign.findRedisListByOrgCodeList(new ArrayList(getByFeignCodeSet))).isSuccess()) {
                    HashMap<String, String> lockCodeMap = new HashMap<String, String>(16);
                    List list = (List)result.getResult();
                    if (list != null && list.size() > 0) {
                        Map<String, MdmOrgRedisVo> collect2 = list.stream().collect(Collectors.toMap(MdmOrgRedisVo::getOrgCode, v -> v));
                        HashMap<String, MdmOrgRedisVo> cacheMap = new HashMap<String, MdmOrgRedisVo>(16);
                        for (String orgCode : getByFeignCodeSet) {
                            if (!collect2.containsKey(orgCode)) {
                                lockCodeMap.put(orgCode, orgCode);
                                continue;
                            }
                            redisVoList.add(collect2.get(orgCode));
                            cacheMap.put(orgCode, collect2.get(orgCode));
                        }
                        if (!cacheMap.isEmpty()) {
                            redisService.hmset("MDM_ORG_SELF_HASH_0112:", new HashMap(cacheMap));
                        }
                    } else {
                        lockCodeMap.putAll(getByFeignCodeSet.stream().collect(Collectors.toMap(k -> k, v -> v)));
                    }
                    if (!lockCodeMap.isEmpty()) {
                        redisService.hmset("MDM_ORG_LOCK_HASH_0112:", new HashMap(lockCodeMap), 3L);
                    }
                }
                if (redisVoList.size() > 0) {
                    map.putAll(redisVoList.stream().collect(Collectors.toMap(MdmOrgRedisVo::getOrgCode, v -> v)));
                }
            }
        }
        catch (Exception e) {
            log.error("\u7ec4\u7ec7\u67e5\u8be2\u5de5\u5177\u7c7b\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
        return map;
    }

    private static Map<String, MdmOrgParentChildrenRedisVo> getOrgParentRedisMapFromLocalFirst(List<String> orgCodeList) {
        HashMap<String, MdmOrgParentChildrenRedisVo> map = new HashMap<String, MdmOrgParentChildrenRedisVo>(16);
        try {
            if (orgCodeList != null && orgCodeList.size() > 0) {
                HashSet<String> getFromRedisCodeSet = new HashSet<String>(16);
                for (String orgCode : orgCodeList) {
                    if (ThreadLocalUtil.orgParentContains((String)orgCode)) {
                        MdmOrgParentChildrenRedisVo fromOrgParent = ThreadLocalUtil.getFromOrgParent((String)orgCode);
                        map.put(orgCode, fromOrgParent);
                        continue;
                    }
                    getFromRedisCodeSet.add(orgCode);
                }
                if (!getFromRedisCodeSet.isEmpty()) {
                    Map<String, MdmOrgParentChildrenRedisVo> mapFromRedisFirst = OrgUtil.getOrgParentRedisMapFromRedisFirst(new ArrayList<String>(orgCodeList));
                    for (String orgCode : getFromRedisCodeSet) {
                        if (mapFromRedisFirst.containsKey(orgCode)) {
                            map.put(orgCode, mapFromRedisFirst.get(orgCode));
                        }
                        ThreadLocalUtil.addToOrgParent((String)orgCode, (MdmOrgParentChildrenRedisVo)mapFromRedisFirst.get(orgCode));
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("\u7ec4\u7ec7\u67e5\u8be2\u5de5\u5177\u7c7b\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
        return map;
    }

    private static Map<String, MdmOrgParentChildrenRedisVo> getOrgParentRedisMapFromRedisFirst(List<String> orgCodeList) {
        HashMap<String, MdmOrgParentChildrenRedisVo> map = new HashMap<String, MdmOrgParentChildrenRedisVo>(16);
        try {
            if (orgCodeList != null && orgCodeList.size() > 0) {
                Result result;
                Set getByFeignCodeSet;
                List collect;
                List orgListFromRedis;
                ArrayList<Object> redisVoList = new ArrayList<Object>();
                HashSet lockCodeList = new HashSet(16);
                List lockListFromHash = redisService.hmget("MDM_ORG_LOCK_HASH_0112:", new HashSet<String>(orgCodeList));
                if (lockListFromHash != null && lockListFromHash.size() > 0) {
                    lockCodeList.addAll(lockListFromHash.stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.toSet()));
                }
                Set notLockGetFromRedisCodeSet = orgCodeList.stream().filter(item -> !lockCodeList.contains(item)).collect(Collectors.toSet());
                HashSet redisHasCodeSet = new HashSet(16);
                if (!notLockGetFromRedisCodeSet.isEmpty() && (orgListFromRedis = redisService.hmget("MDM_ORG_PARENT_HASH_0112:", new HashSet(notLockGetFromRedisCodeSet))) != null && orgListFromRedis.size() > 0 && (collect = orgListFromRedis.stream().filter(Objects::nonNull).map(item -> CrmBeanUtil.copy(item, MdmOrgParentChildrenRedisVo.class)).collect(Collectors.toList())).size() > 0) {
                    redisVoList.addAll(collect);
                    redisHasCodeSet.addAll(collect.stream().map(MdmOrgParentChildrenRedisVo::getOrgCode).collect(Collectors.toSet()));
                }
                if (!(getByFeignCodeSet = notLockGetFromRedisCodeSet.stream().filter(item -> !redisHasCodeSet.contains(item)).collect(Collectors.toSet())).isEmpty() && (result = mdmOrgRedisFeign.findRedisOrgParentListByCodeList(new ArrayList(getByFeignCodeSet))).isSuccess()) {
                    HashMap<String, String> lockCodeMap = new HashMap<String, String>(16);
                    List list = (List)result.getResult();
                    if (list != null && list.size() > 0) {
                        Map<String, MdmOrgParentChildrenRedisVo> collect2 = list.stream().collect(Collectors.toMap(MdmOrgParentChildrenRedisVo::getOrgCode, v -> v));
                        HashMap<String, MdmOrgParentChildrenRedisVo> cacheMap = new HashMap<String, MdmOrgParentChildrenRedisVo>(16);
                        for (String orgCode : getByFeignCodeSet) {
                            if (!collect2.containsKey(orgCode)) {
                                lockCodeMap.put(orgCode, orgCode);
                                continue;
                            }
                            redisVoList.add(collect2.get(orgCode));
                            cacheMap.put(orgCode, collect2.get(orgCode));
                        }
                        if (!cacheMap.isEmpty()) {
                            redisService.hmset("MDM_ORG_PARENT_HASH_0112:", new HashMap(cacheMap));
                        }
                    } else {
                        lockCodeMap.putAll(getByFeignCodeSet.stream().collect(Collectors.toMap(k -> k, v -> v)));
                    }
                    if (!lockCodeMap.isEmpty()) {
                        redisService.hmset("MDM_ORG_LOCK_HASH_0112:", new HashMap(lockCodeMap), 3L);
                    }
                }
                if (redisVoList.size() > 0) {
                    map.putAll(redisVoList.stream().collect(Collectors.toMap(MdmOrgParentChildrenRedisVo::getOrgCode, v -> v)));
                }
            }
        }
        catch (Exception e) {
            log.error("\u7ec4\u7ec7\u67e5\u8be2\u5de5\u5177\u7c7b\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
        return map;
    }

    private static Map<String, MdmOrgParentChildrenRedisVo> getOrgChildrenRedisMapFromLocalFirst(List<String> orgCodeList) {
        HashMap<String, MdmOrgParentChildrenRedisVo> map = new HashMap<String, MdmOrgParentChildrenRedisVo>(16);
        try {
            if (orgCodeList != null && orgCodeList.size() > 0) {
                HashSet<String> getFromRedisCodeSet = new HashSet<String>(16);
                for (String orgCode : orgCodeList) {
                    if (ThreadLocalUtil.orgChildrenContains((String)orgCode)) {
                        MdmOrgParentChildrenRedisVo fromOrgChildren = ThreadLocalUtil.getFromOrgChildren((String)orgCode);
                        map.put(orgCode, fromOrgChildren);
                        continue;
                    }
                    getFromRedisCodeSet.add(orgCode);
                }
                if (!getFromRedisCodeSet.isEmpty()) {
                    Map<String, MdmOrgParentChildrenRedisVo> mapFromRedisFirst = OrgUtil.getOrgChildrenRedisMapFromRedisFirst(new ArrayList<String>(orgCodeList));
                    for (String orgCode : getFromRedisCodeSet) {
                        if (mapFromRedisFirst.containsKey(orgCode)) {
                            map.put(orgCode, mapFromRedisFirst.get(orgCode));
                        }
                        ThreadLocalUtil.addToOrgChildren((String)orgCode, (MdmOrgParentChildrenRedisVo)mapFromRedisFirst.get(orgCode));
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("\u7ec4\u7ec7\u67e5\u8be2\u5de5\u5177\u7c7b\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
        return map;
    }

    private static Map<String, MdmOrgParentChildrenRedisVo> getOrgChildrenRedisMapFromRedisFirst(List<String> orgCodeList) {
        HashMap<String, MdmOrgParentChildrenRedisVo> map = new HashMap<String, MdmOrgParentChildrenRedisVo>(16);
        try {
            if (orgCodeList != null && orgCodeList.size() > 0) {
                Result result;
                Set getByFeignCodeSet;
                List collect;
                List orgListFromRedis;
                ArrayList<Object> redisVoList = new ArrayList<Object>();
                HashSet lockCodeList = new HashSet(16);
                List lockListFromHash = redisService.hmget("MDM_ORG_LOCK_HASH_0112:", new HashSet<String>(orgCodeList));
                if (lockListFromHash != null && lockListFromHash.size() > 0) {
                    lockCodeList.addAll(lockListFromHash.stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.toSet()));
                }
                Set notLockGetFromRedisCodeSet = orgCodeList.stream().filter(item -> !lockCodeList.contains(item)).collect(Collectors.toSet());
                HashSet redisHasCodeSet = new HashSet(16);
                if (!notLockGetFromRedisCodeSet.isEmpty() && (orgListFromRedis = redisService.hmget("MDM_ORG_CHILDREN_HASH_0112:", new HashSet(notLockGetFromRedisCodeSet))) != null && orgListFromRedis.size() > 0 && (collect = orgListFromRedis.stream().filter(Objects::nonNull).map(item -> CrmBeanUtil.copy(item, MdmOrgParentChildrenRedisVo.class)).collect(Collectors.toList())).size() > 0) {
                    redisVoList.addAll(collect);
                    redisHasCodeSet.addAll(collect.stream().map(MdmOrgParentChildrenRedisVo::getOrgCode).collect(Collectors.toSet()));
                }
                if (!(getByFeignCodeSet = notLockGetFromRedisCodeSet.stream().filter(item -> !redisHasCodeSet.contains(item)).collect(Collectors.toSet())).isEmpty() && (result = mdmOrgRedisFeign.findRedisOrgChildrenListByCodeList(new ArrayList(getByFeignCodeSet))).isSuccess()) {
                    HashMap<String, String> lockCodeMap = new HashMap<String, String>(16);
                    List list = (List)result.getResult();
                    if (list != null && list.size() > 0) {
                        Map<String, MdmOrgParentChildrenRedisVo> collect2 = list.stream().collect(Collectors.toMap(MdmOrgParentChildrenRedisVo::getOrgCode, v -> v));
                        HashMap<String, MdmOrgParentChildrenRedisVo> cacheMap = new HashMap<String, MdmOrgParentChildrenRedisVo>(16);
                        for (String orgCode : getByFeignCodeSet) {
                            if (!collect2.containsKey(orgCode)) {
                                lockCodeMap.put(orgCode, orgCode);
                                continue;
                            }
                            redisVoList.add(collect2.get(orgCode));
                            cacheMap.put(orgCode, collect2.get(orgCode));
                        }
                        if (!cacheMap.isEmpty()) {
                            redisService.hmset("MDM_ORG_CHILDREN_HASH_0112:", new HashMap(cacheMap));
                        }
                    } else {
                        lockCodeMap.putAll(getByFeignCodeSet.stream().collect(Collectors.toMap(k -> k, v -> v)));
                    }
                    if (!lockCodeMap.isEmpty()) {
                        redisService.hmset("MDM_ORG_LOCK_HASH_0112:", new HashMap(lockCodeMap), 3L);
                    }
                }
                if (redisVoList.size() > 0) {
                    map.putAll(redisVoList.stream().collect(Collectors.toMap(MdmOrgParentChildrenRedisVo::getOrgCode, v -> v)));
                }
            }
        }
        catch (Exception e) {
            log.error("\u7ec4\u7ec7\u67e5\u8be2\u5de5\u5177\u7c7b\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
        return map;
    }
}

