/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.util;

import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.mdm.cusorg.MdmCustomerOrgRedisFeign;
import com.biz.crm.nebular.mdm.cusorg.CusOrgVo;
import com.biz.crm.nebular.mdm.cusorg.MdmCustomerOrgParentChildrenRedisVo;
import com.biz.crm.nebular.mdm.cusorg.MdmCustomerOrgRedisVo;
import com.biz.crm.nebular.mdm.cusorg.MdmCustomerOrgReloadRedisVo;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.Result;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomerOrgUtil {
    private static final Logger log = LoggerFactory.getLogger(CustomerOrgUtil.class);
    private static RedisService redisService;
    private static MdmCustomerOrgRedisFeign mdmCustomerOrgRedisFeign;

    @Autowired
    public void setRedisService(RedisService redis) {
        redisService = redis;
    }

    @Autowired
    public void setMdmCustomerOrgRedisFeign(MdmCustomerOrgRedisFeign customerOrgRedisFeign) {
        mdmCustomerOrgRedisFeign = customerOrgRedisFeign;
    }

    public static CusOrgVo getCustomerOrgByCode(String customerOrgCode) {
        Map<String, MdmCustomerOrgRedisVo> customerOrgRedisMap;
        if (customerOrgCode != null && !"".equals(customerOrgCode) && (customerOrgRedisMap = CustomerOrgUtil.getCustomerOrgSelfRedisMapFromLocalFirst(Collections.singletonList(customerOrgCode))).containsKey(customerOrgCode)) {
            MdmCustomerOrgRedisVo mdmCustomerOrgRedisVo = customerOrgRedisMap.get(customerOrgCode);
            return CrmBeanUtil.copy(mdmCustomerOrgRedisVo, CusOrgVo.class);
        }
        return null;
    }

    public static List<CusOrgVo> getCustomerOrgByCodeList(List<String> customerOrgCodeList) {
        Map<String, MdmCustomerOrgRedisVo> customerOrgRedisMap;
        ArrayList<CusOrgVo> list = new ArrayList<CusOrgVo>();
        if (customerOrgCodeList != null && customerOrgCodeList.size() > 0 && !(customerOrgRedisMap = CustomerOrgUtil.getCustomerOrgSelfRedisMapFromLocalFirst(customerOrgCodeList)).isEmpty()) {
            list.addAll(customerOrgRedisMap.values().stream().map(item -> CrmBeanUtil.copy(item, CusOrgVo.class)).collect(Collectors.toList()));
        }
        return list;
    }

    public static List<CusOrgVo> getParentCustomerOrgListIncludeSelf(String customerOrgCode) {
        List list;
        MdmCustomerOrgParentChildrenRedisVo redisVo;
        Map<String, MdmCustomerOrgParentChildrenRedisVo> map;
        if (customerOrgCode != null && !"".equals(customerOrgCode) && !(map = CustomerOrgUtil.getCustomerOrgParentRedisMapFromLocalFirst(Collections.singletonList(customerOrgCode))).isEmpty() && (redisVo = map.get(customerOrgCode)) != null && (list = redisVo.getList()) != null && list.size() > 0) {
            return CrmBeanUtil.copyList(list, CusOrgVo.class);
        }
        return new ArrayList<CusOrgVo>();
    }

    public static List<CusOrgVo> getParentCustomerOrgListIncludeSelf(List<String> customerOrgCodeList) {
        if (customerOrgCodeList != null && customerOrgCodeList.size() > 0) {
            Map<String, MdmCustomerOrgParentChildrenRedisVo> map = CustomerOrgUtil.getCustomerOrgParentRedisMapFromLocalFirst(customerOrgCodeList);
            HashSet set = new HashSet(16);
            if (!map.isEmpty()) {
                for (String customerOrgCode : customerOrgCodeList) {
                    MdmCustomerOrgParentChildrenRedisVo redisVo;
                    if (!map.containsKey(customerOrgCode) || (redisVo = map.get(customerOrgCode)) == null || redisVo.getList() == null || redisVo.getList().size() <= 0) continue;
                    set.addAll(redisVo.getList());
                }
                if (!set.isEmpty()) {
                    return CrmBeanUtil.copyList(new ArrayList(set), CusOrgVo.class);
                }
            }
        }
        return new ArrayList<CusOrgVo>();
    }

    public static List<CusOrgVo> getParentCustomerOrgListExcludeSelf(String customerOrgCode) {
        List<CusOrgVo> parentCustomerOrgListIncludeSelf;
        if (customerOrgCode != null && !"".equals(customerOrgCode) && (parentCustomerOrgListIncludeSelf = CustomerOrgUtil.getParentCustomerOrgListIncludeSelf(customerOrgCode)) != null && parentCustomerOrgListIncludeSelf.size() > 0) {
            return parentCustomerOrgListIncludeSelf.stream().filter(item -> !customerOrgCode.equals(item.getCustomerOrgCode())).collect(Collectors.toList());
        }
        return new ArrayList<CusOrgVo>();
    }

    public static List<CusOrgVo> getParentCustomerOrgListExcludeSelf(List<String> customerOrgCodeList) {
        if (customerOrgCodeList != null && customerOrgCodeList.size() > 0) {
            Map<String, MdmCustomerOrgParentChildrenRedisVo> map = CustomerOrgUtil.getCustomerOrgParentRedisMapFromLocalFirst(customerOrgCodeList);
            HashSet set = new HashSet(16);
            if (!map.isEmpty()) {
                for (String customerOrgCode : customerOrgCodeList) {
                    MdmCustomerOrgParentChildrenRedisVo redisVo;
                    if (!map.containsKey(customerOrgCode) || (redisVo = map.get(customerOrgCode)) == null || redisVo.getList() == null || redisVo.getList().size() <= 0) continue;
                    set.addAll(redisVo.getList().stream().filter(item -> !customerOrgCode.equals(item.getCustomerOrgCode())).collect(Collectors.toSet()));
                }
                if (!set.isEmpty()) {
                    return CrmBeanUtil.copyList(new ArrayList(set), CusOrgVo.class);
                }
            }
        }
        return new ArrayList<CusOrgVo>();
    }

    public static List<CusOrgVo> getParentCustomerOrgListExcludeAnySelf(List<String> customerOrgCodeList) {
        List<CusOrgVo> parentCustomerOrgListExcludeSelf;
        if (customerOrgCodeList != null && customerOrgCodeList.size() > 0 && (parentCustomerOrgListExcludeSelf = CustomerOrgUtil.getParentCustomerOrgListExcludeSelf(customerOrgCodeList)) != null && parentCustomerOrgListExcludeSelf.size() > 0) {
            HashSet<String> customerOrgCodeSet = new HashSet<String>(customerOrgCodeList);
            return parentCustomerOrgListExcludeSelf.stream().filter(item -> !customerOrgCodeSet.contains(item.getCustomerOrgCode())).collect(Collectors.toList());
        }
        return new ArrayList<CusOrgVo>();
    }

    public static List<CusOrgVo> getChildrenCustomerOrgListIncludeSelf(String customerOrgCode) {
        List list;
        MdmCustomerOrgParentChildrenRedisVo redisVo;
        Map<String, MdmCustomerOrgParentChildrenRedisVo> map;
        if (customerOrgCode != null && !"".equals(customerOrgCode) && !(map = CustomerOrgUtil.getCustomerOrgChildrenRedisMapFromLocalFirst(Collections.singletonList(customerOrgCode))).isEmpty() && (redisVo = map.get(customerOrgCode)) != null && (list = redisVo.getList()) != null && list.size() > 0) {
            return CrmBeanUtil.copyList(list, CusOrgVo.class);
        }
        return new ArrayList<CusOrgVo>();
    }

    public static List<CusOrgVo> getChildrenCustomerOrgListIncludeSelf(List<String> customerOrgCodeList) {
        if (customerOrgCodeList != null && customerOrgCodeList.size() > 0) {
            Map<String, MdmCustomerOrgParentChildrenRedisVo> map = CustomerOrgUtil.getCustomerOrgChildrenRedisMapFromLocalFirst(customerOrgCodeList);
            HashSet set = new HashSet(16);
            if (!map.isEmpty()) {
                for (String customerOrgCode : customerOrgCodeList) {
                    MdmCustomerOrgParentChildrenRedisVo redisVo;
                    if (!map.containsKey(customerOrgCode) || (redisVo = map.get(customerOrgCode)) == null || redisVo.getList() == null || redisVo.getList().size() <= 0) continue;
                    set.addAll(redisVo.getList());
                }
                if (!set.isEmpty()) {
                    return CrmBeanUtil.copyList(new ArrayList(set), CusOrgVo.class);
                }
            }
        }
        return new ArrayList<CusOrgVo>();
    }

    public static List<CusOrgVo> getChildrenCustomerOrgListExcludeSelf(String customerOrgCode) {
        List<CusOrgVo> parentCustomerOrgListIncludeSelf;
        if (customerOrgCode != null && !"".equals(customerOrgCode) && (parentCustomerOrgListIncludeSelf = CustomerOrgUtil.getChildrenCustomerOrgListIncludeSelf(customerOrgCode)) != null && parentCustomerOrgListIncludeSelf.size() > 0) {
            return parentCustomerOrgListIncludeSelf.stream().filter(item -> !customerOrgCode.equals(item.getCustomerOrgCode())).collect(Collectors.toList());
        }
        return new ArrayList<CusOrgVo>();
    }

    public static List<CusOrgVo> getChildrenCustomerOrgListExcludeSelf(List<String> customerOrgCodeList) {
        if (customerOrgCodeList != null && customerOrgCodeList.size() > 0) {
            Map<String, MdmCustomerOrgParentChildrenRedisVo> map = CustomerOrgUtil.getCustomerOrgChildrenRedisMapFromLocalFirst(customerOrgCodeList);
            HashSet set = new HashSet(16);
            if (!map.isEmpty()) {
                for (String customerOrgCode : customerOrgCodeList) {
                    MdmCustomerOrgParentChildrenRedisVo redisVo;
                    if (!map.containsKey(customerOrgCode) || (redisVo = map.get(customerOrgCode)) == null || redisVo.getList() == null || redisVo.getList().size() <= 0) continue;
                    set.addAll(redisVo.getList().stream().filter(item -> !customerOrgCode.equals(item.getCustomerOrgCode())).collect(Collectors.toSet()));
                }
                if (!set.isEmpty()) {
                    return CrmBeanUtil.copyList(new ArrayList(set), CusOrgVo.class);
                }
            }
        }
        return new ArrayList<CusOrgVo>();
    }

    public static List<CusOrgVo> getChildrenCustomerOrgListExcludeAnySelf(List<String> customerOrgCodeList) {
        List<CusOrgVo> parentCustomerOrgListExcludeSelf;
        if (customerOrgCodeList != null && customerOrgCodeList.size() > 0 && (parentCustomerOrgListExcludeSelf = CustomerOrgUtil.getChildrenCustomerOrgListExcludeSelf(customerOrgCodeList)) != null && parentCustomerOrgListExcludeSelf.size() > 0) {
            HashSet<String> customerOrgCodeSet = new HashSet<String>(customerOrgCodeList);
            return parentCustomerOrgListExcludeSelf.stream().filter(item -> !customerOrgCodeSet.contains(item.getCustomerOrgCode())).collect(Collectors.toList());
        }
        return new ArrayList<CusOrgVo>();
    }

    public static List<CusOrgVo> getParentCustomerOrgListIncludeSelfEnable(String customerOrgCode) {
        return CustomerOrgUtil.getParentCustomerOrgListIncludeSelf(customerOrgCode).stream().filter(item -> CrmEnableStatusEnum.ENABLE.getCode().equals(item.getEnableStatus())).collect(Collectors.toList());
    }

    public static List<CusOrgVo> getParentCustomerOrgListIncludeSelfEnable(List<String> customerOrgCodeList) {
        return CustomerOrgUtil.getParentCustomerOrgListIncludeSelf(customerOrgCodeList).stream().filter(item -> CrmEnableStatusEnum.ENABLE.getCode().equals(item.getEnableStatus())).collect(Collectors.toList());
    }

    public static List<CusOrgVo> getParentCustomerOrgListExcludeSelfEnable(String customerOrgCode) {
        return CustomerOrgUtil.getParentCustomerOrgListExcludeSelf(customerOrgCode).stream().filter(item -> CrmEnableStatusEnum.ENABLE.getCode().equals(item.getEnableStatus())).collect(Collectors.toList());
    }

    public static List<CusOrgVo> getParentCustomerOrgListExcludeSelfEnable(List<String> customerOrgCodeList) {
        return CustomerOrgUtil.getParentCustomerOrgListExcludeSelf(customerOrgCodeList).stream().filter(item -> CrmEnableStatusEnum.ENABLE.getCode().equals(item.getEnableStatus())).collect(Collectors.toList());
    }

    public static List<CusOrgVo> getParentCustomerOrgListExcludeAnySelfEnable(List<String> customerOrgCodeList) {
        return CustomerOrgUtil.getParentCustomerOrgListExcludeAnySelf(customerOrgCodeList).stream().filter(item -> CrmEnableStatusEnum.ENABLE.getCode().equals(item.getEnableStatus())).collect(Collectors.toList());
    }

    public static List<CusOrgVo> getChildrenCustomerOrgListIncludeSelfEnable(String customerOrgCode) {
        return CustomerOrgUtil.getChildrenCustomerOrgListIncludeSelf(customerOrgCode).stream().filter(item -> CrmEnableStatusEnum.ENABLE.getCode().equals(item.getEnableStatus())).collect(Collectors.toList());
    }

    public static List<CusOrgVo> getChildrenCustomerOrgListIncludeSelfEnable(List<String> customerOrgCodeList) {
        return CustomerOrgUtil.getChildrenCustomerOrgListIncludeSelf(customerOrgCodeList).stream().filter(item -> CrmEnableStatusEnum.ENABLE.getCode().equals(item.getEnableStatus())).collect(Collectors.toList());
    }

    public static List<CusOrgVo> getChildrenCustomerOrgListExcludeSelfEnable(String customerOrgCode) {
        return CustomerOrgUtil.getChildrenCustomerOrgListExcludeSelf(customerOrgCode).stream().filter(item -> CrmEnableStatusEnum.ENABLE.getCode().equals(item.getEnableStatus())).collect(Collectors.toList());
    }

    public static List<CusOrgVo> getChildrenCustomerOrgListExcludeSelfEnable(List<String> customerOrgCodeList) {
        return CustomerOrgUtil.getChildrenCustomerOrgListExcludeSelf(customerOrgCodeList).stream().filter(item -> CrmEnableStatusEnum.ENABLE.getCode().equals(item.getEnableStatus())).collect(Collectors.toList());
    }

    public static List<CusOrgVo> getChildrenCustomerOrgListExcludeAnySelfEnable(List<String> customerOrgCodeList) {
        return CustomerOrgUtil.getChildrenCustomerOrgListExcludeAnySelf(customerOrgCodeList).stream().filter(item -> CrmEnableStatusEnum.ENABLE.getCode().equals(item.getEnableStatus())).collect(Collectors.toList());
    }

    public static List<String> getParentCustomerOrgCodeListIncludeSelf(String customerOrgCode) {
        return CustomerOrgUtil.getParentCustomerOrgListIncludeSelf(customerOrgCode).stream().map(CusOrgVo::getCustomerOrgCode).collect(Collectors.toList());
    }

    public static List<String> getParentCustomerOrgCodeListIncludeSelf(List<String> customerOrgCodeList) {
        return CustomerOrgUtil.getParentCustomerOrgListIncludeSelf(customerOrgCodeList).stream().map(CusOrgVo::getCustomerOrgCode).collect(Collectors.toList());
    }

    public static List<String> getParentCustomerOrgCodeListExcludeSelf(String customerOrgCode) {
        return CustomerOrgUtil.getParentCustomerOrgListExcludeSelf(customerOrgCode).stream().map(CusOrgVo::getCustomerOrgCode).collect(Collectors.toList());
    }

    public static List<String> getParentCustomerOrgCodeListExcludeSelf(List<String> customerOrgCodeList) {
        return CustomerOrgUtil.getParentCustomerOrgListExcludeSelf(customerOrgCodeList).stream().map(CusOrgVo::getCustomerOrgCode).collect(Collectors.toList());
    }

    public static List<String> getParentCustomerOrgCodeListExcludeAnySelf(List<String> customerOrgCodeList) {
        return CustomerOrgUtil.getParentCustomerOrgListExcludeAnySelf(customerOrgCodeList).stream().map(CusOrgVo::getCustomerOrgCode).collect(Collectors.toList());
    }

    public static List<String> getChildrenCustomerOrgCodeListIncludeSelf(String customerOrgCode) {
        return CustomerOrgUtil.getChildrenCustomerOrgListIncludeSelf(customerOrgCode).stream().map(CusOrgVo::getCustomerOrgCode).collect(Collectors.toList());
    }

    public static List<String> getChildrenCustomerOrgCodeListIncludeSelf(List<String> customerOrgCodeList) {
        return CustomerOrgUtil.getChildrenCustomerOrgListIncludeSelf(customerOrgCodeList).stream().map(CusOrgVo::getCustomerOrgCode).collect(Collectors.toList());
    }

    public static List<String> getChildrenCustomerOrgCodeListExcludeSelf(String customerOrgCode) {
        return CustomerOrgUtil.getChildrenCustomerOrgListExcludeSelf(customerOrgCode).stream().map(CusOrgVo::getCustomerOrgCode).collect(Collectors.toList());
    }

    public static List<String> getChildrenCustomerOrgCodeListExcludeSelf(List<String> customerOrgCodeList) {
        return CustomerOrgUtil.getChildrenCustomerOrgListExcludeSelf(customerOrgCodeList).stream().map(CusOrgVo::getCustomerOrgCode).collect(Collectors.toList());
    }

    public static List<String> getChildrenCustomerOrgCodeListExcludeAnySelf(List<String> customerOrgCodeList) {
        return CustomerOrgUtil.getChildrenCustomerOrgListExcludeAnySelf(customerOrgCodeList).stream().map(CusOrgVo::getCustomerOrgCode).collect(Collectors.toList());
    }

    public static List<String> getParentCustomerOrgCodeListIncludeSelfEnable(String customerOrgCode) {
        return CustomerOrgUtil.getParentCustomerOrgListIncludeSelfEnable(customerOrgCode).stream().map(CusOrgVo::getCustomerOrgCode).collect(Collectors.toList());
    }

    public static List<String> getParentCustomerOrgCodeListIncludeSelfEnable(List<String> customerOrgCodeList) {
        return CustomerOrgUtil.getParentCustomerOrgListIncludeSelfEnable(customerOrgCodeList).stream().map(CusOrgVo::getCustomerOrgCode).collect(Collectors.toList());
    }

    public static List<String> getParentCustomerOrgCodeListExcludeSelfEnable(String customerOrgCode) {
        return CustomerOrgUtil.getParentCustomerOrgListExcludeSelfEnable(customerOrgCode).stream().map(CusOrgVo::getCustomerOrgCode).collect(Collectors.toList());
    }

    public static List<String> getParentCustomerOrgCodeListExcludeSelfEnable(List<String> customerOrgCodeList) {
        return CustomerOrgUtil.getParentCustomerOrgListExcludeSelfEnable(customerOrgCodeList).stream().map(CusOrgVo::getCustomerOrgCode).collect(Collectors.toList());
    }

    public static List<String> getParentCustomerOrgCodeListExcludeAnySelfEnable(List<String> customerOrgCodeList) {
        return CustomerOrgUtil.getParentCustomerOrgListExcludeAnySelfEnable(customerOrgCodeList).stream().map(CusOrgVo::getCustomerOrgCode).collect(Collectors.toList());
    }

    public static List<String> getChildrenCustomerOrgCodeListIncludeSelfEnable(String customerOrgCode) {
        return CustomerOrgUtil.getChildrenCustomerOrgListIncludeSelfEnable(customerOrgCode).stream().map(CusOrgVo::getCustomerOrgCode).collect(Collectors.toList());
    }

    public static List<String> getChildrenCustomerOrgCodeListIncludeSelfEnable(List<String> customerOrgCodeList) {
        return CustomerOrgUtil.getChildrenCustomerOrgListIncludeSelfEnable(customerOrgCodeList).stream().map(CusOrgVo::getCustomerOrgCode).collect(Collectors.toList());
    }

    public static List<String> getChildrenCustomerOrgCodeListExcludeSelfEnable(String customerOrgCode) {
        return CustomerOrgUtil.getChildrenCustomerOrgListExcludeSelfEnable(customerOrgCode).stream().map(CusOrgVo::getCustomerOrgCode).collect(Collectors.toList());
    }

    public static List<String> getChildrenCustomerOrgCodeListExcludeSelfEnable(List<String> customerOrgCodeList) {
        return CustomerOrgUtil.getChildrenCustomerOrgListExcludeSelfEnable(customerOrgCodeList).stream().map(CusOrgVo::getCustomerOrgCode).collect(Collectors.toList());
    }

    public static List<String> getChildrenCustomerOrgCodeListExcludeAnySelfEnable(List<String> customerOrgCodeList) {
        return CustomerOrgUtil.getChildrenCustomerOrgListExcludeAnySelfEnable(customerOrgCodeList).stream().map(CusOrgVo::getCustomerOrgCode).collect(Collectors.toList());
    }

    public static void deleteAllCache() {
        redisService.del(new String[]{"MDM_CUSTOMER_ORG_LOCK_HASH_0201:"});
        redisService.del(new String[]{"MDM_CUSTOMER_ORG_SELF_HASH_0201:"});
        redisService.del(new String[]{"MDM_CUSTOMER_ORG_PARENT_HASH_0201:"});
        redisService.del(new String[]{"MDM_CUSTOMER_ORG_CHILDREN_HASH_0201:"});
        ThreadLocalUtil.delCustomerOrg();
    }

    public static void reloadAllCache() {
        List list;
        CustomerOrgUtil.deleteAllCache();
        Result result = mdmCustomerOrgRedisFeign.findRedisReloadList();
        if (result.isSuccess() && (list = (List)result.getResult()) != null && list.size() > 0) {
            List partition = Lists.partition((List)list, (int)500);
            for (List item : partition) {
                Map<String, MdmCustomerOrgRedisVo> selfMap = item.stream().collect(Collectors.toMap(MdmCustomerOrgReloadRedisVo::getCustomerOrgCode, MdmCustomerOrgReloadRedisVo::getSelf));
                Map<String, List> parentMap = item.stream().collect(Collectors.toMap(MdmCustomerOrgReloadRedisVo::getCustomerOrgCode, MdmCustomerOrgReloadRedisVo::getParentList));
                Map<String, List> childrenMap = item.stream().collect(Collectors.toMap(MdmCustomerOrgReloadRedisVo::getCustomerOrgCode, MdmCustomerOrgReloadRedisVo::getChildrenList));
                redisService.hmset("MDM_CUSTOMER_ORG_SELF_HASH_0201:", new HashMap<String, MdmCustomerOrgRedisVo>(selfMap), 7776000L);
                redisService.hmset("MDM_CUSTOMER_ORG_PARENT_HASH_0201:", new HashMap<String, List>(parentMap), 7776000L);
                redisService.hmset("MDM_CUSTOMER_ORG_CHILDREN_HASH_0201:", new HashMap<String, List>(childrenMap), 7776000L);
            }
        }
    }

    private static Map<String, MdmCustomerOrgRedisVo> getCustomerOrgSelfRedisMapFromLocalFirst(List<String> customerOrgCodeList) {
        HashMap<String, MdmCustomerOrgRedisVo> map = new HashMap<String, MdmCustomerOrgRedisVo>(16);
        try {
            if (customerOrgCodeList != null && customerOrgCodeList.size() > 0) {
                HashSet<String> getFromRedisCodeSet = new HashSet<String>(16);
                for (String customerOrgCode : customerOrgCodeList) {
                    if (ThreadLocalUtil.customerOrgSelfContains((String)customerOrgCode)) {
                        MdmCustomerOrgRedisVo fromCustomerOrgSelf = ThreadLocalUtil.getFromCustomerOrgSelf((String)customerOrgCode);
                        map.put(customerOrgCode, fromCustomerOrgSelf);
                        continue;
                    }
                    getFromRedisCodeSet.add(customerOrgCode);
                }
                if (!getFromRedisCodeSet.isEmpty()) {
                    Map<String, MdmCustomerOrgRedisVo> mapFromRedisFirst = CustomerOrgUtil.getCustomerOrgSelfRedisMapFromRedisFirst(new ArrayList<String>(customerOrgCodeList));
                    for (String customerOrgCode : getFromRedisCodeSet) {
                        if (mapFromRedisFirst.containsKey(customerOrgCode)) {
                            map.put(customerOrgCode, mapFromRedisFirst.get(customerOrgCode));
                        }
                        ThreadLocalUtil.addToCustomerOrgSelf((String)customerOrgCode, (MdmCustomerOrgRedisVo)mapFromRedisFirst.get(customerOrgCode));
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("\u5ba2\u6237\u7ec4\u7ec7\u67e5\u8be2\u5de5\u5177\u7c7b\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
        return map;
    }

    private static Map<String, MdmCustomerOrgRedisVo> getCustomerOrgSelfRedisMapFromRedisFirst(List<String> customerOrgCodeList) {
        HashMap<String, MdmCustomerOrgRedisVo> map = new HashMap<String, MdmCustomerOrgRedisVo>(16);
        try {
            if (customerOrgCodeList != null && customerOrgCodeList.size() > 0) {
                Result result;
                Set getByFeignCodeSet;
                List collect;
                List customerOrgListFromRedis;
                ArrayList<Object> redisVoList = new ArrayList<Object>();
                HashSet lockCodeList = new HashSet(16);
                List lockListFromHash = redisService.hmget("MDM_CUSTOMER_ORG_LOCK_HASH_0201:", new HashSet<String>(customerOrgCodeList));
                if (lockListFromHash != null && lockListFromHash.size() > 0) {
                    lockCodeList.addAll(lockListFromHash.stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.toSet()));
                }
                Set notLockGetFromRedisCodeSet = customerOrgCodeList.stream().filter(item -> !lockCodeList.contains(item)).collect(Collectors.toSet());
                HashSet redisHasCodeSet = new HashSet(16);
                if (!notLockGetFromRedisCodeSet.isEmpty() && (customerOrgListFromRedis = redisService.hmget("MDM_CUSTOMER_ORG_SELF_HASH_0201:", new HashSet(notLockGetFromRedisCodeSet))) != null && customerOrgListFromRedis.size() > 0 && (collect = customerOrgListFromRedis.stream().filter(Objects::nonNull).map(item -> CrmBeanUtil.copy(item, MdmCustomerOrgRedisVo.class)).collect(Collectors.toList())).size() > 0) {
                    redisVoList.addAll(collect);
                    redisHasCodeSet.addAll(collect.stream().map(MdmCustomerOrgRedisVo::getCustomerOrgCode).collect(Collectors.toSet()));
                }
                if (!(getByFeignCodeSet = notLockGetFromRedisCodeSet.stream().filter(item -> !redisHasCodeSet.contains(item)).collect(Collectors.toSet())).isEmpty() && (result = mdmCustomerOrgRedisFeign.findRedisListByCustomerOrgCodeList(new ArrayList(getByFeignCodeSet))).isSuccess()) {
                    HashMap<String, String> lockCodeMap = new HashMap<String, String>(16);
                    List list = (List)result.getResult();
                    if (list != null && list.size() > 0) {
                        Map<String, MdmCustomerOrgRedisVo> collect2 = list.stream().collect(Collectors.toMap(MdmCustomerOrgRedisVo::getCustomerOrgCode, v -> v));
                        HashMap<String, MdmCustomerOrgRedisVo> cacheMap = new HashMap<String, MdmCustomerOrgRedisVo>(16);
                        for (String customerOrgCode : getByFeignCodeSet) {
                            if (!collect2.containsKey(customerOrgCode)) {
                                lockCodeMap.put(customerOrgCode, customerOrgCode);
                                continue;
                            }
                            redisVoList.add(collect2.get(customerOrgCode));
                            cacheMap.put(customerOrgCode, collect2.get(customerOrgCode));
                        }
                        if (!cacheMap.isEmpty()) {
                            redisService.hmset("MDM_CUSTOMER_ORG_SELF_HASH_0201:", new HashMap(cacheMap), 7776000L);
                        }
                    } else {
                        lockCodeMap.putAll(getByFeignCodeSet.stream().collect(Collectors.toMap(k -> k, v -> v)));
                    }
                    if (!lockCodeMap.isEmpty()) {
                        redisService.hmset("MDM_CUSTOMER_ORG_LOCK_HASH_0201:", new HashMap(lockCodeMap), 3L);
                    }
                }
                if (redisVoList.size() > 0) {
                    map.putAll(redisVoList.stream().collect(Collectors.toMap(MdmCustomerOrgRedisVo::getCustomerOrgCode, v -> v)));
                }
            }
        }
        catch (Exception e) {
            log.error("\u5ba2\u6237\u7ec4\u7ec7\u67e5\u8be2\u5de5\u5177\u7c7b\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
        return map;
    }

    private static Map<String, MdmCustomerOrgParentChildrenRedisVo> getCustomerOrgParentRedisMapFromLocalFirst(List<String> customerOrgCodeList) {
        HashMap<String, MdmCustomerOrgParentChildrenRedisVo> map = new HashMap<String, MdmCustomerOrgParentChildrenRedisVo>(16);
        try {
            if (customerOrgCodeList != null && customerOrgCodeList.size() > 0) {
                HashSet<String> getFromRedisCodeSet = new HashSet<String>(16);
                for (String customerOrgCode : customerOrgCodeList) {
                    if (ThreadLocalUtil.customerOrgParentContains((String)customerOrgCode)) {
                        MdmCustomerOrgParentChildrenRedisVo fromCustomerOrgParent = ThreadLocalUtil.getFromCustomerOrgParent((String)customerOrgCode);
                        map.put(customerOrgCode, fromCustomerOrgParent);
                        continue;
                    }
                    getFromRedisCodeSet.add(customerOrgCode);
                }
                if (!getFromRedisCodeSet.isEmpty()) {
                    Map<String, MdmCustomerOrgParentChildrenRedisVo> mapFromRedisFirst = CustomerOrgUtil.getCustomerOrgParentRedisMapFromRedisFirst(new ArrayList<String>(customerOrgCodeList));
                    for (String customerOrgCode : getFromRedisCodeSet) {
                        if (mapFromRedisFirst.containsKey(customerOrgCode)) {
                            map.put(customerOrgCode, mapFromRedisFirst.get(customerOrgCode));
                        }
                        ThreadLocalUtil.addToCustomerOrgParent((String)customerOrgCode, (MdmCustomerOrgParentChildrenRedisVo)mapFromRedisFirst.get(customerOrgCode));
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("\u5ba2\u6237\u7ec4\u7ec7\u67e5\u8be2\u5de5\u5177\u7c7b\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
        return map;
    }

    private static Map<String, MdmCustomerOrgParentChildrenRedisVo> getCustomerOrgParentRedisMapFromRedisFirst(List<String> customerOrgCodeList) {
        HashMap<String, MdmCustomerOrgParentChildrenRedisVo> map = new HashMap<String, MdmCustomerOrgParentChildrenRedisVo>(16);
        try {
            if (customerOrgCodeList != null && customerOrgCodeList.size() > 0) {
                Result result;
                Set getByFeignCodeSet;
                List collect;
                List customerOrgListFromRedis;
                ArrayList<Object> redisVoList = new ArrayList<Object>();
                HashSet lockCodeList = new HashSet(16);
                List lockListFromHash = redisService.hmget("MDM_CUSTOMER_ORG_LOCK_HASH_0201:", new HashSet<String>(customerOrgCodeList));
                if (lockListFromHash != null && lockListFromHash.size() > 0) {
                    lockCodeList.addAll(lockListFromHash.stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.toSet()));
                }
                Set notLockGetFromRedisCodeSet = customerOrgCodeList.stream().filter(item -> !lockCodeList.contains(item)).collect(Collectors.toSet());
                HashSet redisHasCodeSet = new HashSet(16);
                if (!notLockGetFromRedisCodeSet.isEmpty() && (customerOrgListFromRedis = redisService.hmget("MDM_CUSTOMER_ORG_PARENT_HASH_0201:", new HashSet(notLockGetFromRedisCodeSet))) != null && customerOrgListFromRedis.size() > 0 && (collect = customerOrgListFromRedis.stream().filter(Objects::nonNull).map(item -> CrmBeanUtil.copy(item, MdmCustomerOrgParentChildrenRedisVo.class)).collect(Collectors.toList())).size() > 0) {
                    redisVoList.addAll(collect);
                    redisHasCodeSet.addAll(collect.stream().map(MdmCustomerOrgParentChildrenRedisVo::getCustomerOrgCode).collect(Collectors.toSet()));
                }
                if (!(getByFeignCodeSet = notLockGetFromRedisCodeSet.stream().filter(item -> !redisHasCodeSet.contains(item)).collect(Collectors.toSet())).isEmpty() && (result = mdmCustomerOrgRedisFeign.findRedisCustomerOrgParentListByCodeList(new ArrayList(getByFeignCodeSet))).isSuccess()) {
                    HashMap<String, String> lockCodeMap = new HashMap<String, String>(16);
                    List list = (List)result.getResult();
                    if (list != null && list.size() > 0) {
                        Map<String, MdmCustomerOrgParentChildrenRedisVo> collect2 = list.stream().collect(Collectors.toMap(MdmCustomerOrgParentChildrenRedisVo::getCustomerOrgCode, v -> v));
                        HashMap<String, MdmCustomerOrgParentChildrenRedisVo> cacheMap = new HashMap<String, MdmCustomerOrgParentChildrenRedisVo>(16);
                        for (String customerOrgCode : getByFeignCodeSet) {
                            if (!collect2.containsKey(customerOrgCode)) {
                                lockCodeMap.put(customerOrgCode, customerOrgCode);
                                continue;
                            }
                            redisVoList.add(collect2.get(customerOrgCode));
                            cacheMap.put(customerOrgCode, collect2.get(customerOrgCode));
                        }
                        if (!cacheMap.isEmpty()) {
                            redisService.hmset("MDM_CUSTOMER_ORG_PARENT_HASH_0201:", new HashMap(cacheMap), 7776000L);
                        }
                    } else {
                        lockCodeMap.putAll(getByFeignCodeSet.stream().collect(Collectors.toMap(k -> k, v -> v)));
                    }
                    if (!lockCodeMap.isEmpty()) {
                        redisService.hmset("MDM_CUSTOMER_ORG_LOCK_HASH_0201:", new HashMap(lockCodeMap), 3L);
                    }
                }
                if (redisVoList.size() > 0) {
                    map.putAll(redisVoList.stream().collect(Collectors.toMap(MdmCustomerOrgParentChildrenRedisVo::getCustomerOrgCode, v -> v)));
                }
            }
        }
        catch (Exception e) {
            log.error("\u5ba2\u6237\u7ec4\u7ec7\u67e5\u8be2\u5de5\u5177\u7c7b\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
        return map;
    }

    private static Map<String, MdmCustomerOrgParentChildrenRedisVo> getCustomerOrgChildrenRedisMapFromLocalFirst(List<String> customerOrgCodeList) {
        HashMap<String, MdmCustomerOrgParentChildrenRedisVo> map = new HashMap<String, MdmCustomerOrgParentChildrenRedisVo>(16);
        try {
            if (customerOrgCodeList != null && customerOrgCodeList.size() > 0) {
                HashSet<String> getFromRedisCodeSet = new HashSet<String>(16);
                for (String customerOrgCode : customerOrgCodeList) {
                    if (ThreadLocalUtil.customerOrgChildrenContains((String)customerOrgCode)) {
                        MdmCustomerOrgParentChildrenRedisVo fromCustomerOrgChildren = ThreadLocalUtil.getFromCustomerOrgChildren((String)customerOrgCode);
                        map.put(customerOrgCode, fromCustomerOrgChildren);
                        continue;
                    }
                    getFromRedisCodeSet.add(customerOrgCode);
                }
                if (!getFromRedisCodeSet.isEmpty()) {
                    Map<String, MdmCustomerOrgParentChildrenRedisVo> mapFromRedisFirst = CustomerOrgUtil.getCustomerOrgChildrenRedisMapFromRedisFirst(new ArrayList<String>(customerOrgCodeList));
                    for (String customerOrgCode : getFromRedisCodeSet) {
                        if (mapFromRedisFirst.containsKey(customerOrgCode)) {
                            map.put(customerOrgCode, mapFromRedisFirst.get(customerOrgCode));
                        }
                        ThreadLocalUtil.addToCustomerOrgChildren((String)customerOrgCode, (MdmCustomerOrgParentChildrenRedisVo)mapFromRedisFirst.get(customerOrgCode));
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("\u5ba2\u6237\u7ec4\u7ec7\u67e5\u8be2\u5de5\u5177\u7c7b\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
        return map;
    }

    private static Map<String, MdmCustomerOrgParentChildrenRedisVo> getCustomerOrgChildrenRedisMapFromRedisFirst(List<String> customerOrgCodeList) {
        HashMap<String, MdmCustomerOrgParentChildrenRedisVo> map = new HashMap<String, MdmCustomerOrgParentChildrenRedisVo>(16);
        try {
            if (customerOrgCodeList != null && customerOrgCodeList.size() > 0) {
                Result result;
                Set getByFeignCodeSet;
                List collect;
                List customerOrgListFromRedis;
                ArrayList<Object> redisVoList = new ArrayList<Object>();
                HashSet lockCodeList = new HashSet(16);
                List lockListFromHash = redisService.hmget("MDM_CUSTOMER_ORG_LOCK_HASH_0201:", new HashSet<String>(customerOrgCodeList));
                if (lockListFromHash != null && lockListFromHash.size() > 0) {
                    lockCodeList.addAll(lockListFromHash.stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.toSet()));
                }
                Set notLockGetFromRedisCodeSet = customerOrgCodeList.stream().filter(item -> !lockCodeList.contains(item)).collect(Collectors.toSet());
                HashSet redisHasCodeSet = new HashSet(16);
                if (!notLockGetFromRedisCodeSet.isEmpty() && (customerOrgListFromRedis = redisService.hmget("MDM_CUSTOMER_ORG_CHILDREN_HASH_0201:", new HashSet(notLockGetFromRedisCodeSet))) != null && customerOrgListFromRedis.size() > 0 && (collect = customerOrgListFromRedis.stream().filter(Objects::nonNull).map(item -> CrmBeanUtil.copy(item, MdmCustomerOrgParentChildrenRedisVo.class)).collect(Collectors.toList())).size() > 0) {
                    redisVoList.addAll(collect);
                    redisHasCodeSet.addAll(collect.stream().map(MdmCustomerOrgParentChildrenRedisVo::getCustomerOrgCode).collect(Collectors.toSet()));
                }
                if (!(getByFeignCodeSet = notLockGetFromRedisCodeSet.stream().filter(item -> !redisHasCodeSet.contains(item)).collect(Collectors.toSet())).isEmpty() && (result = mdmCustomerOrgRedisFeign.findRedisCustomerOrgChildrenListByCodeList(new ArrayList(getByFeignCodeSet))).isSuccess()) {
                    HashMap<String, String> lockCodeMap = new HashMap<String, String>(16);
                    List list = (List)result.getResult();
                    if (list != null && list.size() > 0) {
                        Map<String, MdmCustomerOrgParentChildrenRedisVo> collect2 = list.stream().collect(Collectors.toMap(MdmCustomerOrgParentChildrenRedisVo::getCustomerOrgCode, v -> v));
                        HashMap<String, MdmCustomerOrgParentChildrenRedisVo> cacheMap = new HashMap<String, MdmCustomerOrgParentChildrenRedisVo>(16);
                        for (String customerOrgCode : getByFeignCodeSet) {
                            if (!collect2.containsKey(customerOrgCode)) {
                                lockCodeMap.put(customerOrgCode, customerOrgCode);
                                continue;
                            }
                            redisVoList.add(collect2.get(customerOrgCode));
                            cacheMap.put(customerOrgCode, collect2.get(customerOrgCode));
                        }
                        if (!cacheMap.isEmpty()) {
                            redisService.hmset("MDM_CUSTOMER_ORG_CHILDREN_HASH_0201:", new HashMap(cacheMap), 7776000L);
                        }
                    } else {
                        lockCodeMap.putAll(getByFeignCodeSet.stream().collect(Collectors.toMap(k -> k, v -> v)));
                    }
                    if (!lockCodeMap.isEmpty()) {
                        redisService.hmset("MDM_CUSTOMER_ORG_LOCK_HASH_0201:", new HashMap(lockCodeMap), 3L);
                    }
                }
                if (redisVoList.size() > 0) {
                    map.putAll(redisVoList.stream().collect(Collectors.toMap(MdmCustomerOrgParentChildrenRedisVo::getCustomerOrgCode, v -> v)));
                }
            }
        }
        catch (Exception e) {
            log.error("\u5ba2\u6237\u7ec4\u7ec7\u67e5\u8be2\u5de5\u5177\u7c7b\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
        return map;
    }
}

