/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.util;

import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.mdm.position.MdmPositionFeign;
import com.biz.crm.mdm.position.MdmPositionRedisFeign;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionParentChildrenRedisVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRedisVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionReloadRedisVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRespVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserReqVo;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PositionUtil {
    private static final Logger log = LoggerFactory.getLogger(PositionUtil.class);
    private static RedisService redisService;
    private static MdmPositionRedisFeign mdmPositionRedisFeign;
    private static MdmPositionFeign mdmPositionFeign;

    public static List<MdmPositionRespVo> getAllPositionByUsername(String userName2) {
        if (StringUtils.isEmpty((String)userName2)) {
            return Lists.newArrayList();
        }
        MdmUserReqVo param = new MdmUserReqVo();
        param.setUserName(userName2);
        List positions = (List)mdmPositionFeign.getUserAllPositionList(param).getResult();
        if (CollectionUtil.listEmpty(positions)) {
            return Lists.newArrayList();
        }
        return positions;
    }

    @Autowired
    public void setRedisService(RedisService redis) {
        redisService = redis;
    }

    @Autowired
    public void setMdmPositionRedisFeign(MdmPositionRedisFeign positionRedisFeign) {
        mdmPositionRedisFeign = positionRedisFeign;
    }

    @Autowired
    public void setMdmPositionFeign(MdmPositionFeign mdmpositionfeign) {
        mdmPositionFeign = mdmpositionfeign;
    }

    public static MdmPositionRespVo getPositionByCode(String positionCode) {
        Map<String, MdmPositionRedisVo> positionRedisMap;
        if (positionCode != null && !"".equals(positionCode) && (positionRedisMap = PositionUtil.getPositionSelfRedisMapFromLocalFirst(Collections.singletonList(positionCode))).containsKey(positionCode)) {
            MdmPositionRedisVo mdmPositionRedisVo = positionRedisMap.get(positionCode);
            return CrmBeanUtil.copy(mdmPositionRedisVo, MdmPositionRespVo.class);
        }
        return null;
    }

    public static List<MdmPositionRespVo> getPositionByCodeList(List<String> positionCodeList) {
        HashSet strings;
        Map<String, MdmPositionRedisVo> positionRedisMap;
        ArrayList<MdmPositionRespVo> list = new ArrayList<MdmPositionRespVo>();
        if (positionCodeList != null && positionCodeList.size() > 0 && !(positionRedisMap = PositionUtil.getPositionSelfRedisMapFromLocalFirst(Lists.newArrayList((Iterable)(strings = Sets.newHashSet(positionCodeList))))).isEmpty()) {
            list.addAll(positionRedisMap.values().stream().map(item -> CrmBeanUtil.copy(item, MdmPositionRespVo.class)).collect(Collectors.toList()));
        }
        return list;
    }

    public static List<MdmPositionRespVo> getParentPositionListIncludeSelf(String positionCode) {
        List list;
        MdmPositionParentChildrenRedisVo redisVo;
        Map<String, MdmPositionParentChildrenRedisVo> map;
        if (positionCode != null && !"".equals(positionCode) && !(map = PositionUtil.getPositionParentRedisMapFromLocalFirst(Collections.singletonList(positionCode))).isEmpty() && (redisVo = map.get(positionCode)) != null && (list = redisVo.getList()) != null && list.size() > 0) {
            return CrmBeanUtil.copyList(list, MdmPositionRespVo.class);
        }
        return new ArrayList<MdmPositionRespVo>();
    }

    public static List<MdmPositionRespVo> getParentPositionListIncludeSelf(List<String> positionCodeList) {
        if (positionCodeList != null && positionCodeList.size() > 0) {
            Map<String, MdmPositionParentChildrenRedisVo> map = PositionUtil.getPositionParentRedisMapFromLocalFirst(positionCodeList);
            HashSet set = new HashSet(16);
            if (!map.isEmpty()) {
                for (String positionCode : positionCodeList) {
                    MdmPositionParentChildrenRedisVo redisVo;
                    if (!map.containsKey(positionCode) || (redisVo = map.get(positionCode)) == null || redisVo.getList() == null || redisVo.getList().size() <= 0) continue;
                    set.addAll(redisVo.getList());
                }
                if (!set.isEmpty()) {
                    return CrmBeanUtil.copyList(new ArrayList(set), MdmPositionRespVo.class);
                }
            }
        }
        return new ArrayList<MdmPositionRespVo>();
    }

    public static List<MdmPositionRespVo> getParentPositionListExcludeSelf(String positionCode) {
        List<MdmPositionRespVo> parentPositionListIncludeSelf;
        if (positionCode != null && !"".equals(positionCode) && (parentPositionListIncludeSelf = PositionUtil.getParentPositionListIncludeSelf(positionCode)) != null && parentPositionListIncludeSelf.size() > 0) {
            return parentPositionListIncludeSelf.stream().filter(item -> !positionCode.equals(item.getPositionCode())).collect(Collectors.toList());
        }
        return new ArrayList<MdmPositionRespVo>();
    }

    public static List<MdmPositionRespVo> getParentPositionListExcludeSelf(List<String> positionCodeList) {
        if (positionCodeList != null && positionCodeList.size() > 0) {
            Map<String, MdmPositionParentChildrenRedisVo> map = PositionUtil.getPositionParentRedisMapFromLocalFirst(positionCodeList);
            HashSet set = new HashSet(16);
            if (!map.isEmpty()) {
                for (String positionCode : positionCodeList) {
                    MdmPositionParentChildrenRedisVo redisVo;
                    if (!map.containsKey(positionCode) || (redisVo = map.get(positionCode)) == null || redisVo.getList() == null || redisVo.getList().size() <= 0) continue;
                    set.addAll(redisVo.getList().stream().filter(item -> !positionCode.equals(item.getPositionCode())).collect(Collectors.toSet()));
                }
                if (!set.isEmpty()) {
                    return CrmBeanUtil.copyList(new ArrayList(set), MdmPositionRespVo.class);
                }
            }
        }
        return new ArrayList<MdmPositionRespVo>();
    }

    public static List<MdmPositionRespVo> getParentPositionListExcludeAnySelf(List<String> positionCodeList) {
        List<MdmPositionRespVo> parentPositionListExcludeSelf;
        if (positionCodeList != null && positionCodeList.size() > 0 && (parentPositionListExcludeSelf = PositionUtil.getParentPositionListExcludeSelf(positionCodeList)) != null && parentPositionListExcludeSelf.size() > 0) {
            HashSet<String> positionCodeSet = new HashSet<String>(positionCodeList);
            return parentPositionListExcludeSelf.stream().filter(item -> !positionCodeSet.contains(item.getPositionCode())).collect(Collectors.toList());
        }
        return new ArrayList<MdmPositionRespVo>();
    }

    public static List<MdmPositionRespVo> getChildrenPositionListIncludeSelf(String positionCode) {
        List list;
        MdmPositionParentChildrenRedisVo redisVo;
        Map<String, MdmPositionParentChildrenRedisVo> map;
        if (positionCode != null && !"".equals(positionCode) && !(map = PositionUtil.getPositionChildrenRedisMapFromLocalFirst(Collections.singletonList(positionCode))).isEmpty() && (redisVo = map.get(positionCode)) != null && (list = redisVo.getList()) != null && list.size() > 0) {
            return CrmBeanUtil.copyList(list, MdmPositionRespVo.class);
        }
        return new ArrayList<MdmPositionRespVo>();
    }

    public static List<MdmPositionRespVo> getChildrenPositionListIncludeSelf(List<String> positionCodeList) {
        if (positionCodeList != null && positionCodeList.size() > 0) {
            Map<String, MdmPositionParentChildrenRedisVo> map = PositionUtil.getPositionChildrenRedisMapFromLocalFirst(positionCodeList);
            HashSet set = new HashSet(16);
            if (!map.isEmpty()) {
                for (String positionCode : positionCodeList) {
                    MdmPositionParentChildrenRedisVo redisVo;
                    if (!map.containsKey(positionCode) || (redisVo = map.get(positionCode)) == null || redisVo.getList() == null || redisVo.getList().size() <= 0) continue;
                    set.addAll(redisVo.getList());
                }
                if (!set.isEmpty()) {
                    return CrmBeanUtil.copyList(new ArrayList(set), MdmPositionRespVo.class);
                }
            }
        }
        return new ArrayList<MdmPositionRespVo>();
    }

    public static List<MdmPositionRespVo> getChildrenPositionListExcludeSelf(String positionCode) {
        List<MdmPositionRespVo> parentPositionListIncludeSelf;
        if (positionCode != null && !"".equals(positionCode) && (parentPositionListIncludeSelf = PositionUtil.getChildrenPositionListIncludeSelf(positionCode)) != null && parentPositionListIncludeSelf.size() > 0) {
            return parentPositionListIncludeSelf.stream().filter(item -> !positionCode.equals(item.getPositionCode())).collect(Collectors.toList());
        }
        return new ArrayList<MdmPositionRespVo>();
    }

    public static List<MdmPositionRespVo> getChildrenPositionListExcludeSelf(List<String> positionCodeList) {
        if (positionCodeList != null && positionCodeList.size() > 0) {
            Map<String, MdmPositionParentChildrenRedisVo> map = PositionUtil.getPositionChildrenRedisMapFromLocalFirst(positionCodeList);
            HashSet set = new HashSet(16);
            if (!map.isEmpty()) {
                for (String positionCode : positionCodeList) {
                    MdmPositionParentChildrenRedisVo redisVo;
                    if (!map.containsKey(positionCode) || (redisVo = map.get(positionCode)) == null || redisVo.getList() == null || redisVo.getList().size() <= 0) continue;
                    set.addAll(redisVo.getList().stream().filter(item -> !positionCode.equals(item.getPositionCode())).collect(Collectors.toSet()));
                }
                if (!set.isEmpty()) {
                    return CrmBeanUtil.copyList(new ArrayList(set), MdmPositionRespVo.class);
                }
            }
        }
        return new ArrayList<MdmPositionRespVo>();
    }

    public static List<MdmPositionRespVo> getChildrenPositionListExcludeAnySelf(List<String> positionCodeList) {
        List<MdmPositionRespVo> parentPositionListExcludeSelf;
        if (positionCodeList != null && positionCodeList.size() > 0 && (parentPositionListExcludeSelf = PositionUtil.getChildrenPositionListExcludeSelf(positionCodeList)) != null && parentPositionListExcludeSelf.size() > 0) {
            HashSet<String> positionCodeSet = new HashSet<String>(positionCodeList);
            return parentPositionListExcludeSelf.stream().filter(item -> !positionCodeSet.contains(item.getPositionCode())).collect(Collectors.toList());
        }
        return new ArrayList<MdmPositionRespVo>();
    }

    public static List<MdmPositionRespVo> getParentPositionListIncludeSelfEnable(String positionCode) {
        return PositionUtil.getParentPositionListIncludeSelf(positionCode).stream().filter(item -> CrmEnableStatusEnum.ENABLE.getCode().equals(item.getEnableStatus())).collect(Collectors.toList());
    }

    public static List<MdmPositionRespVo> getParentPositionListIncludeSelfEnable(List<String> positionCodeList) {
        return PositionUtil.getParentPositionListIncludeSelf(positionCodeList).stream().filter(item -> CrmEnableStatusEnum.ENABLE.getCode().equals(item.getEnableStatus())).collect(Collectors.toList());
    }

    public static List<MdmPositionRespVo> getParentPositionListExcludeSelfEnable(String positionCode) {
        return PositionUtil.getParentPositionListExcludeSelf(positionCode).stream().filter(item -> CrmEnableStatusEnum.ENABLE.getCode().equals(item.getEnableStatus())).collect(Collectors.toList());
    }

    public static List<MdmPositionRespVo> getParentPositionListExcludeSelfEnable(List<String> positionCodeList) {
        return PositionUtil.getParentPositionListExcludeSelf(positionCodeList).stream().filter(item -> CrmEnableStatusEnum.ENABLE.getCode().equals(item.getEnableStatus())).collect(Collectors.toList());
    }

    public static List<MdmPositionRespVo> getParentPositionListExcludeAnySelfEnable(List<String> positionCodeList) {
        return PositionUtil.getParentPositionListExcludeAnySelf(positionCodeList).stream().filter(item -> CrmEnableStatusEnum.ENABLE.getCode().equals(item.getEnableStatus())).collect(Collectors.toList());
    }

    public static List<MdmPositionRespVo> getChildrenPositionListIncludeSelfEnable(String positionCode) {
        return PositionUtil.getChildrenPositionListIncludeSelf(positionCode).stream().filter(item -> CrmEnableStatusEnum.ENABLE.getCode().equals(item.getEnableStatus())).collect(Collectors.toList());
    }

    public static List<MdmPositionRespVo> getChildrenPositionListIncludeSelfEnable(List<String> positionCodeList) {
        return PositionUtil.getChildrenPositionListIncludeSelf(positionCodeList).stream().filter(item -> CrmEnableStatusEnum.ENABLE.getCode().equals(item.getEnableStatus())).collect(Collectors.toList());
    }

    public static List<MdmPositionRespVo> getChildrenPositionListExcludeSelfEnable(String positionCode) {
        return PositionUtil.getChildrenPositionListExcludeSelf(positionCode).stream().filter(item -> CrmEnableStatusEnum.ENABLE.getCode().equals(item.getEnableStatus())).collect(Collectors.toList());
    }

    public static List<MdmPositionRespVo> getChildrenPositionListExcludeSelfEnable(List<String> positionCodeList) {
        return PositionUtil.getChildrenPositionListExcludeSelf(positionCodeList).stream().filter(item -> CrmEnableStatusEnum.ENABLE.getCode().equals(item.getEnableStatus())).collect(Collectors.toList());
    }

    public static List<MdmPositionRespVo> getChildrenPositionListExcludeAnySelfEnable(List<String> positionCodeList) {
        return PositionUtil.getChildrenPositionListExcludeAnySelf(positionCodeList).stream().filter(item -> CrmEnableStatusEnum.ENABLE.getCode().equals(item.getEnableStatus())).collect(Collectors.toList());
    }

    public static List<String> getParentPositionCodeListIncludeSelf(String positionCode) {
        return PositionUtil.getParentPositionListIncludeSelf(positionCode).stream().map(MdmPositionRespVo::getPositionCode).collect(Collectors.toList());
    }

    public static List<String> getParentPositionCodeListIncludeSelf(List<String> positionCodeList) {
        return PositionUtil.getParentPositionListIncludeSelf(positionCodeList).stream().map(MdmPositionRespVo::getPositionCode).collect(Collectors.toList());
    }

    public static List<String> getParentPositionCodeListExcludeSelf(String positionCode) {
        return PositionUtil.getParentPositionListExcludeSelf(positionCode).stream().map(MdmPositionRespVo::getPositionCode).collect(Collectors.toList());
    }

    public static List<String> getParentPositionCodeListExcludeSelf(List<String> positionCodeList) {
        return PositionUtil.getParentPositionListExcludeSelf(positionCodeList).stream().map(MdmPositionRespVo::getPositionCode).collect(Collectors.toList());
    }

    public static List<String> getParentPositionCodeListExcludeAnySelf(List<String> positionCodeList) {
        return PositionUtil.getParentPositionListExcludeAnySelf(positionCodeList).stream().map(MdmPositionRespVo::getPositionCode).collect(Collectors.toList());
    }

    public static List<String> getChildrenPositionCodeListIncludeSelf(String positionCode) {
        return PositionUtil.getChildrenPositionListIncludeSelf(positionCode).stream().map(MdmPositionRespVo::getPositionCode).collect(Collectors.toList());
    }

    public static List<String> getChildrenPositionCodeListIncludeSelf(List<String> positionCodeList) {
        return PositionUtil.getChildrenPositionListIncludeSelf(positionCodeList).stream().map(MdmPositionRespVo::getPositionCode).collect(Collectors.toList());
    }

    public static List<String> getChildrenPositionCodeListExcludeSelf(String positionCode) {
        return PositionUtil.getChildrenPositionListExcludeSelf(positionCode).stream().map(MdmPositionRespVo::getPositionCode).collect(Collectors.toList());
    }

    public static List<String> getChildrenPositionCodeListExcludeSelf(List<String> positionCodeList) {
        return PositionUtil.getChildrenPositionListExcludeSelf(positionCodeList).stream().map(MdmPositionRespVo::getPositionCode).collect(Collectors.toList());
    }

    public static List<String> getChildrenPositionCodeListExcludeAnySelf(List<String> positionCodeList) {
        return PositionUtil.getChildrenPositionListExcludeAnySelf(positionCodeList).stream().map(MdmPositionRespVo::getPositionCode).collect(Collectors.toList());
    }

    public static List<String> getParentPositionCodeListIncludeSelfEnable(String positionCode) {
        return PositionUtil.getParentPositionListIncludeSelfEnable(positionCode).stream().map(MdmPositionRespVo::getPositionCode).collect(Collectors.toList());
    }

    public static List<String> getParentPositionCodeListIncludeSelfEnable(List<String> positionCodeList) {
        return PositionUtil.getParentPositionListIncludeSelfEnable(positionCodeList).stream().map(MdmPositionRespVo::getPositionCode).collect(Collectors.toList());
    }

    public static List<String> getParentPositionCodeListExcludeSelfEnable(String positionCode) {
        return PositionUtil.getParentPositionListExcludeSelfEnable(positionCode).stream().map(MdmPositionRespVo::getPositionCode).collect(Collectors.toList());
    }

    public static List<String> getParentPositionCodeListExcludeSelfEnable(List<String> positionCodeList) {
        return PositionUtil.getParentPositionListExcludeSelfEnable(positionCodeList).stream().map(MdmPositionRespVo::getPositionCode).collect(Collectors.toList());
    }

    public static List<String> getParentPositionCodeListExcludeAnySelfEnable(List<String> positionCodeList) {
        return PositionUtil.getParentPositionListExcludeAnySelfEnable(positionCodeList).stream().map(MdmPositionRespVo::getPositionCode).collect(Collectors.toList());
    }

    public static List<String> getChildrenPositionCodeListIncludeSelfEnable(String positionCode) {
        return PositionUtil.getChildrenPositionListIncludeSelfEnable(positionCode).stream().map(MdmPositionRespVo::getPositionCode).collect(Collectors.toList());
    }

    public static List<String> getChildrenPositionCodeListIncludeSelfEnable(List<String> positionCodeList) {
        return PositionUtil.getChildrenPositionListIncludeSelfEnable(positionCodeList).stream().map(MdmPositionRespVo::getPositionCode).collect(Collectors.toList());
    }

    public static List<String> getChildrenPositionCodeListExcludeSelfEnable(String positionCode) {
        return PositionUtil.getChildrenPositionListExcludeSelfEnable(positionCode).stream().map(MdmPositionRespVo::getPositionCode).collect(Collectors.toList());
    }

    public static List<String> getChildrenPositionCodeListExcludeSelfEnable(List<String> positionCodeList) {
        return PositionUtil.getChildrenPositionListExcludeSelfEnable(positionCodeList).stream().map(MdmPositionRespVo::getPositionCode).collect(Collectors.toList());
    }

    public static List<String> getChildrenPositionCodeListExcludeAnySelfEnable(List<String> positionCodeList) {
        return PositionUtil.getChildrenPositionListExcludeAnySelfEnable(positionCodeList).stream().map(MdmPositionRespVo::getPositionCode).collect(Collectors.toList());
    }

    public static void deleteAllCache() {
        redisService.del(new String[]{"MDM_POSITION_LOCK_HASH_0407:"});
        redisService.del(new String[]{"MDM_POSITION_SELF_HASH_0407:"});
        redisService.del(new String[]{"MDM_POSITION_PARENT_HASH_0407:"});
        redisService.del(new String[]{"MDM_POSITION_CHILDREN_HASH_0407:"});
        ThreadLocalUtil.delPosition();
    }

    public static void reloadAllCache() {
        List list;
        PositionUtil.deleteAllCache();
        Result result = mdmPositionRedisFeign.findRedisReloadList();
        if (result.isSuccess() && (list = (List)result.getResult()) != null && list.size() > 0) {
            List partition = Lists.partition((List)list, (int)500);
            for (List item : partition) {
                Map<String, MdmPositionRedisVo> selfMap = item.stream().collect(Collectors.toMap(MdmPositionReloadRedisVo::getPositionCode, MdmPositionReloadRedisVo::getSelf));
                Map<String, List> parentMap = item.stream().collect(Collectors.toMap(MdmPositionReloadRedisVo::getPositionCode, MdmPositionReloadRedisVo::getParentList));
                Map<String, List> childrenMap = item.stream().collect(Collectors.toMap(MdmPositionReloadRedisVo::getPositionCode, MdmPositionReloadRedisVo::getChildrenList));
                redisService.hmset("MDM_POSITION_SELF_HASH_0407:", new HashMap<String, MdmPositionRedisVo>(selfMap));
                redisService.hmset("MDM_POSITION_PARENT_HASH_0407:", new HashMap<String, List>(parentMap));
                redisService.hmset("MDM_POSITION_CHILDREN_HASH_0407:", new HashMap<String, List>(childrenMap));
            }
        }
    }

    private static Map<String, MdmPositionRedisVo> getPositionSelfRedisMapFromLocalFirst(List<String> positionCodeList) {
        HashMap<String, MdmPositionRedisVo> map = new HashMap<String, MdmPositionRedisVo>(16);
        try {
            if (positionCodeList != null && positionCodeList.size() > 0) {
                HashSet<String> getFromRedisCodeSet = new HashSet<String>(16);
                for (String positionCode : positionCodeList) {
                    if (ThreadLocalUtil.positionSelfContains((String)positionCode)) {
                        MdmPositionRedisVo fromPositionSelf = ThreadLocalUtil.getFromPositionSelf((String)positionCode);
                        map.put(positionCode, fromPositionSelf);
                        continue;
                    }
                    getFromRedisCodeSet.add(positionCode);
                }
                if (!getFromRedisCodeSet.isEmpty()) {
                    Map<String, MdmPositionRedisVo> mapFromRedisFirst = PositionUtil.getPositionSelfRedisMapFromRedisFirst(new ArrayList<String>(positionCodeList));
                    for (String positionCode : getFromRedisCodeSet) {
                        if (mapFromRedisFirst.containsKey(positionCode)) {
                            map.put(positionCode, mapFromRedisFirst.get(positionCode));
                        }
                        ThreadLocalUtil.addToPositionSelf((String)positionCode, (MdmPositionRedisVo)mapFromRedisFirst.get(positionCode));
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("\u804c\u4f4d\u67e5\u8be2\u5de5\u5177\u7c7b\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
        return map;
    }

    private static Map<String, MdmPositionRedisVo> getPositionSelfRedisMapFromRedisFirst(List<String> positionCodeList) {
        HashMap<String, MdmPositionRedisVo> map = new HashMap<String, MdmPositionRedisVo>(16);
        try {
            if (positionCodeList != null && positionCodeList.size() > 0) {
                Result result;
                Set getByFeignCodeSet;
                List collect;
                List positionListFromRedis;
                ArrayList<Object> redisVoList = new ArrayList<Object>();
                HashSet lockCodeList = new HashSet(16);
                List lockListFromHash = redisService.hmget("MDM_POSITION_LOCK_HASH_0407:", new HashSet<String>(positionCodeList));
                if (lockListFromHash != null && lockListFromHash.size() > 0) {
                    lockCodeList.addAll(lockListFromHash.stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.toSet()));
                }
                Set notLockGetFromRedisCodeSet = positionCodeList.stream().filter(item -> !lockCodeList.contains(item)).collect(Collectors.toSet());
                HashSet redisHasCodeSet = new HashSet(16);
                if (!notLockGetFromRedisCodeSet.isEmpty() && (positionListFromRedis = redisService.hmget("MDM_POSITION_SELF_HASH_0407:", new HashSet(notLockGetFromRedisCodeSet))) != null && positionListFromRedis.size() > 0 && (collect = positionListFromRedis.stream().filter(Objects::nonNull).map(item -> CrmBeanUtil.copy(item, MdmPositionRedisVo.class)).collect(Collectors.toList())).size() > 0) {
                    redisVoList.addAll(collect);
                    redisHasCodeSet.addAll(collect.stream().map(MdmPositionRedisVo::getPositionCode).collect(Collectors.toSet()));
                }
                if (!(getByFeignCodeSet = notLockGetFromRedisCodeSet.stream().filter(item -> !redisHasCodeSet.contains(item)).collect(Collectors.toSet())).isEmpty() && (result = mdmPositionRedisFeign.findRedisListByPositionCodeList(new ArrayList(getByFeignCodeSet))).isSuccess()) {
                    HashMap<String, String> lockCodeMap = new HashMap<String, String>(16);
                    List list = (List)result.getResult();
                    if (list != null && list.size() > 0) {
                        Map<String, MdmPositionRedisVo> collect2 = list.stream().collect(Collectors.toMap(MdmPositionRedisVo::getPositionCode, v -> v));
                        HashMap<String, MdmPositionRedisVo> cacheMap = new HashMap<String, MdmPositionRedisVo>(16);
                        for (String positionCode : getByFeignCodeSet) {
                            if (!collect2.containsKey(positionCode)) {
                                lockCodeMap.put(positionCode, positionCode);
                                continue;
                            }
                            redisVoList.add(collect2.get(positionCode));
                            cacheMap.put(positionCode, collect2.get(positionCode));
                        }
                        if (!cacheMap.isEmpty()) {
                            redisService.hmset("MDM_POSITION_SELF_HASH_0407:", new HashMap(cacheMap));
                        }
                    } else {
                        lockCodeMap.putAll(getByFeignCodeSet.stream().collect(Collectors.toMap(k -> k, v -> v)));
                    }
                    if (!lockCodeMap.isEmpty()) {
                        redisService.hmset("MDM_POSITION_LOCK_HASH_0407:", new HashMap(lockCodeMap), 3L);
                    }
                }
                if (redisVoList.size() > 0) {
                    map.putAll(redisVoList.stream().collect(Collectors.toMap(MdmPositionRedisVo::getPositionCode, v -> v)));
                }
            }
        }
        catch (Exception e) {
            log.error("\u804c\u4f4d\u67e5\u8be2\u5de5\u5177\u7c7b\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
        return map;
    }

    private static Map<String, MdmPositionParentChildrenRedisVo> getPositionParentRedisMapFromLocalFirst(List<String> positionCodeList) {
        HashMap<String, MdmPositionParentChildrenRedisVo> map = new HashMap<String, MdmPositionParentChildrenRedisVo>(16);
        try {
            if (positionCodeList != null && positionCodeList.size() > 0) {
                HashSet<String> getFromRedisCodeSet = new HashSet<String>(16);
                for (String positionCode : positionCodeList) {
                    if (ThreadLocalUtil.positionParentContains((String)positionCode)) {
                        MdmPositionParentChildrenRedisVo fromPositionParent = ThreadLocalUtil.getFromPositionParent((String)positionCode);
                        map.put(positionCode, fromPositionParent);
                        continue;
                    }
                    getFromRedisCodeSet.add(positionCode);
                }
                if (!getFromRedisCodeSet.isEmpty()) {
                    Map<String, MdmPositionParentChildrenRedisVo> mapFromRedisFirst = PositionUtil.getPositionParentRedisMapFromRedisFirst(new ArrayList<String>(positionCodeList));
                    for (String positionCode : getFromRedisCodeSet) {
                        if (mapFromRedisFirst.containsKey(positionCode)) {
                            map.put(positionCode, mapFromRedisFirst.get(positionCode));
                        }
                        ThreadLocalUtil.addToPositionParent((String)positionCode, (MdmPositionParentChildrenRedisVo)mapFromRedisFirst.get(positionCode));
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("\u804c\u4f4d\u67e5\u8be2\u5de5\u5177\u7c7b\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
        return map;
    }

    private static Map<String, MdmPositionParentChildrenRedisVo> getPositionParentRedisMapFromRedisFirst(List<String> positionCodeList) {
        HashMap<String, MdmPositionParentChildrenRedisVo> map = new HashMap<String, MdmPositionParentChildrenRedisVo>(16);
        try {
            if (positionCodeList != null && positionCodeList.size() > 0) {
                Result result;
                Set getByFeignCodeSet;
                List collect;
                List positionListFromRedis;
                ArrayList<Object> redisVoList = new ArrayList<Object>();
                HashSet lockCodeList = new HashSet(16);
                List lockListFromHash = redisService.hmget("MDM_POSITION_LOCK_HASH_0407:", new HashSet<String>(positionCodeList));
                if (lockListFromHash != null && lockListFromHash.size() > 0) {
                    lockCodeList.addAll(lockListFromHash.stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.toSet()));
                }
                Set notLockGetFromRedisCodeSet = positionCodeList.stream().filter(item -> !lockCodeList.contains(item)).collect(Collectors.toSet());
                HashSet redisHasCodeSet = new HashSet(16);
                if (!notLockGetFromRedisCodeSet.isEmpty() && (positionListFromRedis = redisService.hmget("MDM_POSITION_PARENT_HASH_0407:", new HashSet(notLockGetFromRedisCodeSet))) != null && positionListFromRedis.size() > 0 && (collect = positionListFromRedis.stream().filter(Objects::nonNull).map(item -> CrmBeanUtil.copy(item, MdmPositionParentChildrenRedisVo.class)).collect(Collectors.toList())).size() > 0) {
                    redisVoList.addAll(collect);
                    redisHasCodeSet.addAll(collect.stream().map(MdmPositionParentChildrenRedisVo::getPositionCode).collect(Collectors.toSet()));
                }
                if (!(getByFeignCodeSet = notLockGetFromRedisCodeSet.stream().filter(item -> !redisHasCodeSet.contains(item)).collect(Collectors.toSet())).isEmpty() && (result = mdmPositionRedisFeign.findRedisPositionParentListByCodeList(new ArrayList(getByFeignCodeSet))).isSuccess()) {
                    HashMap<String, String> lockCodeMap = new HashMap<String, String>(16);
                    List list = (List)result.getResult();
                    if (list != null && list.size() > 0) {
                        Map<String, MdmPositionParentChildrenRedisVo> collect2 = list.stream().collect(Collectors.toMap(MdmPositionParentChildrenRedisVo::getPositionCode, v -> v));
                        HashMap<String, MdmPositionParentChildrenRedisVo> cacheMap = new HashMap<String, MdmPositionParentChildrenRedisVo>(16);
                        for (String positionCode : getByFeignCodeSet) {
                            if (!collect2.containsKey(positionCode)) {
                                lockCodeMap.put(positionCode, positionCode);
                                continue;
                            }
                            redisVoList.add(collect2.get(positionCode));
                            cacheMap.put(positionCode, collect2.get(positionCode));
                        }
                        if (!cacheMap.isEmpty()) {
                            redisService.hmset("MDM_POSITION_PARENT_HASH_0407:", new HashMap(cacheMap));
                        }
                    } else {
                        lockCodeMap.putAll(getByFeignCodeSet.stream().collect(Collectors.toMap(k -> k, v -> v)));
                    }
                    if (!lockCodeMap.isEmpty()) {
                        redisService.hmset("MDM_POSITION_LOCK_HASH_0407:", new HashMap(lockCodeMap), 3L);
                    }
                }
                if (redisVoList.size() > 0) {
                    map.putAll(redisVoList.stream().collect(Collectors.toMap(MdmPositionParentChildrenRedisVo::getPositionCode, v -> v)));
                }
            }
        }
        catch (Exception e) {
            log.error("\u804c\u4f4d\u67e5\u8be2\u5de5\u5177\u7c7b\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
        return map;
    }

    private static Map<String, MdmPositionParentChildrenRedisVo> getPositionChildrenRedisMapFromLocalFirst(List<String> positionCodeList) {
        HashMap<String, MdmPositionParentChildrenRedisVo> map = new HashMap<String, MdmPositionParentChildrenRedisVo>(16);
        try {
            if (positionCodeList != null && positionCodeList.size() > 0) {
                HashSet<String> getFromRedisCodeSet = new HashSet<String>(16);
                for (String positionCode : positionCodeList) {
                    if (ThreadLocalUtil.positionChildrenContains((String)positionCode)) {
                        MdmPositionParentChildrenRedisVo fromPositionChildren = ThreadLocalUtil.getFromPositionChildren((String)positionCode);
                        map.put(positionCode, fromPositionChildren);
                        continue;
                    }
                    getFromRedisCodeSet.add(positionCode);
                }
                if (!getFromRedisCodeSet.isEmpty()) {
                    Map<String, MdmPositionParentChildrenRedisVo> mapFromRedisFirst = PositionUtil.getPositionChildrenRedisMapFromRedisFirst(new ArrayList<String>(positionCodeList));
                    for (String positionCode : getFromRedisCodeSet) {
                        if (mapFromRedisFirst.containsKey(positionCode)) {
                            map.put(positionCode, mapFromRedisFirst.get(positionCode));
                        }
                        ThreadLocalUtil.addToPositionChildren((String)positionCode, (MdmPositionParentChildrenRedisVo)mapFromRedisFirst.get(positionCode));
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("\u804c\u4f4d\u67e5\u8be2\u5de5\u5177\u7c7b\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
        return map;
    }

    private static Map<String, MdmPositionParentChildrenRedisVo> getPositionChildrenRedisMapFromRedisFirst(List<String> positionCodeList) {
        HashMap<String, MdmPositionParentChildrenRedisVo> map = new HashMap<String, MdmPositionParentChildrenRedisVo>(16);
        try {
            if (positionCodeList != null && positionCodeList.size() > 0) {
                Result result;
                Set getByFeignCodeSet;
                List collect;
                List positionListFromRedis;
                ArrayList<Object> redisVoList = new ArrayList<Object>();
                HashSet lockCodeList = new HashSet(16);
                List lockListFromHash = redisService.hmget("MDM_POSITION_LOCK_HASH_0407:", new HashSet<String>(positionCodeList));
                if (lockListFromHash != null && lockListFromHash.size() > 0) {
                    lockCodeList.addAll(lockListFromHash.stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.toSet()));
                }
                Set notLockGetFromRedisCodeSet = positionCodeList.stream().filter(item -> !lockCodeList.contains(item)).collect(Collectors.toSet());
                HashSet redisHasCodeSet = new HashSet(16);
                if (!notLockGetFromRedisCodeSet.isEmpty() && (positionListFromRedis = redisService.hmget("MDM_POSITION_CHILDREN_HASH_0407:", new HashSet(notLockGetFromRedisCodeSet))) != null && positionListFromRedis.size() > 0 && (collect = positionListFromRedis.stream().filter(Objects::nonNull).map(item -> CrmBeanUtil.copy(item, MdmPositionParentChildrenRedisVo.class)).collect(Collectors.toList())).size() > 0) {
                    redisVoList.addAll(collect);
                    redisHasCodeSet.addAll(collect.stream().map(MdmPositionParentChildrenRedisVo::getPositionCode).collect(Collectors.toSet()));
                }
                if (!(getByFeignCodeSet = notLockGetFromRedisCodeSet.stream().filter(item -> !redisHasCodeSet.contains(item)).collect(Collectors.toSet())).isEmpty() && (result = mdmPositionRedisFeign.findRedisPositionChildrenListByCodeList(new ArrayList(getByFeignCodeSet))).isSuccess()) {
                    HashMap<String, String> lockCodeMap = new HashMap<String, String>(16);
                    List list = (List)result.getResult();
                    if (list != null && list.size() > 0) {
                        Map<String, MdmPositionParentChildrenRedisVo> collect2 = list.stream().collect(Collectors.toMap(MdmPositionParentChildrenRedisVo::getPositionCode, v -> v));
                        HashMap<String, MdmPositionParentChildrenRedisVo> cacheMap = new HashMap<String, MdmPositionParentChildrenRedisVo>(16);
                        for (String positionCode : getByFeignCodeSet) {
                            if (!collect2.containsKey(positionCode)) {
                                lockCodeMap.put(positionCode, positionCode);
                                continue;
                            }
                            redisVoList.add(collect2.get(positionCode));
                            cacheMap.put(positionCode, collect2.get(positionCode));
                        }
                        if (!cacheMap.isEmpty()) {
                            redisService.hmset("MDM_POSITION_CHILDREN_HASH_0407:", new HashMap(cacheMap));
                        }
                    } else {
                        lockCodeMap.putAll(getByFeignCodeSet.stream().collect(Collectors.toMap(k -> k, v -> v)));
                    }
                    if (!lockCodeMap.isEmpty()) {
                        redisService.hmset("MDM_POSITION_LOCK_HASH_0407:", new HashMap(lockCodeMap), 3L);
                    }
                }
                if (redisVoList.size() > 0) {
                    map.putAll(redisVoList.stream().collect(Collectors.toMap(MdmPositionParentChildrenRedisVo::getPositionCode, v -> v)));
                }
            }
        }
        catch (Exception e) {
            log.error("\u804c\u4f4d\u67e5\u8be2\u5de5\u5177\u7c7b\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
        return map;
    }
}

