/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.util.websocket;

import com.biz.crm.config.SpringApplicationContextUtil;
import com.biz.crm.util.websocket.feign.WebsocketFeign;
import com.biz.crm.util.websocket.vo.WebsocketMsg;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WebsocketUtil {
    private static final Logger log = LoggerFactory.getLogger(WebsocketUtil.class);
    @Autowired
    private WebsocketFeign websocketFeign;

    private void initFeign() {
        if (this.websocketFeign == null) {
            this.websocketFeign = (WebsocketFeign)SpringApplicationContextUtil.getApplicationContext().getBean(WebsocketFeign.class);
        }
    }

    public void sendMsg(WebsocketMsg websocketMsg) {
        try {
            this.websocketFeign.sendMsg(websocketMsg);
        }
        catch (Exception e) {
            log.error("\u53d1\u9001websock\u5931\u8d25", (Throwable)e);
        }
    }

    public void sendMsg(String sid, String msg) {
        WebsocketMsg websocketMsg = new WebsocketMsg();
        websocketMsg.setSid(sid);
        websocketMsg.setMsg(msg);
        try {
            this.websocketFeign.sendMsg(websocketMsg);
        }
        catch (Exception e) {
            log.error("\u53d1\u9001websock\u5931\u8d25", (Throwable)e);
        }
    }
}

