/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.util.weixin;

import com.alibaba.fastjson.JSON;
import com.biz.crm.base.BusinessException;
import com.biz.crm.config.SpringApplicationContextUtil;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.weixin.OpenIdVo;
import com.biz.crm.util.weixin.WeiXinConfig;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenIdUtil {
    private static final Logger log = LoggerFactory.getLogger(OpenIdUtil.class);

    private static String interfaceUtil(String path, String data) {
        String returnJson = "";
        InputStream is = null;
        HttpURLConnection conn = null;
        try {
            URL url = new URL(path);
            conn = (HttpURLConnection)url.openConnection();
            PrintWriter out = null;
            conn.setRequestProperty("accept", "*/*");
            conn.setRequestProperty("connection", "Keep-Alive");
            conn.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)");
            conn.setDoOutput(true);
            conn.setDoInput(true);
            out = new PrintWriter(conn.getOutputStream());
            out.print(data);
            out.flush();
            is = conn.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            String str = "";
            while ((str = br.readLine()) != null) {
                returnJson = str;
            }
            is.close();
            conn.disconnect();
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6openid\u5f02\u5e38", (Throwable)e);
            try {
                if (is != null) {
                    is.close();
                }
                if (conn != null) {
                    conn.disconnect();
                }
            }
            catch (Exception e1) {
                log.error("\u83b7\u53d6openid\u5f02\u5e38", (Throwable)e1);
            }
        }
        return returnJson;
    }

    public static OpenIdVo getSfaAppletOpenId(String code) {
        WeiXinConfig weiXinConfig = (WeiXinConfig)SpringApplicationContextUtil.getApplicationContext().getBean(WeiXinConfig.class);
        if (StringUtils.isEmpty((CharSequence)weiXinConfig.getAppid()) || StringUtils.isEmpty((CharSequence)weiXinConfig.getAppsecret())) {
            throw new BusinessException("\u672a\u914d\u7f6e\u5fae\u4fe1 appid ");
        }
        String URL2 = "https://api.weixin.qq.com/sns/jscode2session?appid=" + weiXinConfig.getAppid() + "&secret=" + weiXinConfig.getAppsecret() + "&js_code=" + code + "&grant_type=authorization_code";
        String returnJson = OpenIdUtil.interfaceUtil(URL2, "");
        if (StringUtils.isEmpty((CharSequence)returnJson)) {
            return null;
        }
        log.info("\u83b7\u53d6\u5fae\u4fe1\u767b\u5f55openId\u7b49\u4fe1\u606f:  " + returnJson);
        String session_key = JSON.parseObject((String)returnJson).getString("session_key");
        try {
            session_key = URLEncoder.encode(session_key, "UTF-8");
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6openid\u5f02\u5e38", (Throwable)e);
        }
        OpenIdVo openIdVo = JsonPropertyUtil.toObject(returnJson, OpenIdVo.class);
        openIdVo.setSession_key(session_key);
        log.info("\u83b7\u53d6\u5fae\u4fe1\u767b\u5f55session_key\u4fe1\u606f:  " + session_key);
        return openIdVo;
    }

    public static OpenIdVo getTerminalAppletOpenId(String code) {
        WeiXinConfig weiXinConfig = (WeiXinConfig)SpringApplicationContextUtil.getApplicationContext().getBean(WeiXinConfig.class);
        if (StringUtils.isEmpty((CharSequence)weiXinConfig.getTerminalAppid()) || StringUtils.isEmpty((CharSequence)weiXinConfig.getTerminalAppsecret())) {
            throw new BusinessException("\u672a\u914d\u7f6e\u5fae\u4fe1 appid ");
        }
        String URL2 = "https://api.weixin.qq.com/sns/jscode2session?appid=" + weiXinConfig.getTerminalAppid() + "&secret=" + weiXinConfig.getTerminalAppsecret() + "&js_code=" + code + "&grant_type=authorization_code";
        String returnJson = OpenIdUtil.interfaceUtil(URL2, "");
        if (StringUtils.isEmpty((CharSequence)returnJson)) {
            return null;
        }
        log.info("\u83b7\u53d6\u5fae\u4fe1\u767b\u5f55openId\u7b49\u4fe1\u606f:  " + returnJson);
        String session_key = JSON.parseObject((String)returnJson).getString("session_key");
        try {
            session_key = URLEncoder.encode(session_key, "UTF-8");
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6openid\u5f02\u5e38", (Throwable)e);
        }
        OpenIdVo openIdVo = JsonPropertyUtil.toObject(returnJson, OpenIdVo.class);
        openIdVo.setSession_key(session_key);
        log.info("\u83b7\u53d6\u5fae\u4fe1\u767b\u5f55session_key\u4fe1\u606f:  " + session_key);
        return openIdVo;
    }
}

