/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.util;

import com.biz.crm.base.BusinessException;
import java.util.Collection;
import java.util.Map;

public class ValidateUtils {
    public static void validate(Object obj, String errMsg) {
        if (obj == null || obj.toString().equals("")) {
            throw new BusinessException(errMsg);
        }
    }

    public static void validate(Object obj, String errMsg, Object ... format) {
        if (obj == null || obj.toString().equals("")) {
            throw new BusinessException(String.format(errMsg, format));
        }
    }

    public static void isEmpty(Collection collection, String errMsg, String ... format) {
        if (collection != null && collection.size() > 0) {
            throw new BusinessException(String.format(errMsg, format));
        }
    }

    public static void notEmpty(Collection collection, String errMsg, String ... format) {
        if (collection == null || collection.size() == 0) {
            throw new BusinessException(String.format(errMsg, format));
        }
    }

    public static void notEmpty(Map map, String errMsg, String ... format) {
        if (map == null || map.size() == 0) {
            throw new BusinessException(String.format(errMsg, format));
        }
    }

    public static void isTrue(boolean bol, String errMsg, Object ... format) {
        if (format != null) {
            errMsg = String.format(errMsg, format);
        }
        if (!bol) {
            throw new BusinessException(errMsg);
        }
    }
}

